/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dto;

import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphireims.dto.BaseDTO;
import com.sapphireims.itsm.dto.SdNotificationTemplateDetailsDTO;
import com.sapphireims.itsm.model.SdNotificationTemplate;
import com.sapphireims.itsm.model.SdNotificationTemplateDetails;
import com.sapphireims.util.CollectionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SdNotificationTemplateDTO
extends BaseDTO {
    private static final long serialVersionUID = -3175784688038011909L;
    private Integer templateId;
    private Integer projectId;
    private String projectName;
    private String templateName;
    private String description;
    private String templateBody;
    private int templateType;
    private byte isDeletionAllowed;
    private byte isSummaryIncluded;
    private byte isStateUpdatesIncluded;
    private int fieldType;
    private int htmlTemplateId;
    private List<SdNotificationTemplateDetailsDTO> sdNotificationTemplateDetails;

    private SdNotificationTemplateDTO(Builder builder) {
        this.templateId = builder.templateId;
        this.projectId = builder.projectId;
        this.projectName = builder.projectName;
        this.templateName = builder.templateName;
        this.description = builder.description;
        this.templateBody = builder.templateBody;
        this.templateType = builder.templateType;
        this.isDeletionAllowed = builder.isDeletionAllowed;
        this.isSummaryIncluded = builder.isSummaryIncluded;
        this.isStateUpdatesIncluded = builder.isStateUpdatesIncluded;
        this.fieldType = builder.fieldType;
        this.htmlTemplateId = builder.htmlTemplateId;
        this.sdNotificationTemplateDetails = builder.sdNotificationTemplateDetails;
    }

    public SdNotificationTemplateDTO() {
    }

    public SdNotificationTemplateDTO(SdNotificationTemplate request, Set<SdNotificationTemplateDetails> sdNotificationTemplateDetails, SdProjectMaster sdpm) {
        this.templateId = request.getTemplateId();
        this.projectId = sdpm.getProjectId();
        this.projectName = sdpm.getProjectName();
        this.templateName = request.getTemplateName();
        this.description = request.getDescription();
        this.templateBody = request.getTemplateBody();
        this.templateType = request.getTemplateType();
        this.isDeletionAllowed = request.getIsDeletionAllowed();
        this.isSummaryIncluded = request.getIsSummaryIncluded();
        this.isStateUpdatesIncluded = request.getIsStateUpdatesIncluded();
        this.fieldType = request.getFieldType();
        this.htmlTemplateId = request.getHtmlTemplateId();
        if (CollectionUtil.isNotEmpty(sdNotificationTemplateDetails)) {
            this.sdNotificationTemplateDetails = new ArrayList<SdNotificationTemplateDetailsDTO>(sdNotificationTemplateDetails.size());
            for (SdNotificationTemplateDetails sd : sdNotificationTemplateDetails) {
                this.sdNotificationTemplateDetails.add(new SdNotificationTemplateDetailsDTO(sd, request));
            }
        }
    }

    public Integer getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(Integer templateId) {
        this.templateId = templateId;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTemplateBody() {
        return this.templateBody;
    }

    public void setTemplateBody(String templateBody) {
        this.templateBody = templateBody;
    }

    public int getTemplateType() {
        return this.templateType;
    }

    public void setTemplateType(int templateType) {
        this.templateType = templateType;
    }

    public byte getIsDeletionAllowed() {
        return this.isDeletionAllowed;
    }

    public void setIsDeletionAllowed(byte isDeletionAllowed) {
        this.isDeletionAllowed = isDeletionAllowed;
    }

    public byte getIsSummaryIncluded() {
        return this.isSummaryIncluded;
    }

    public void setIsSummaryIncluded(byte isSummaryIncluded) {
        this.isSummaryIncluded = isSummaryIncluded;
    }

    public byte getIsStateUpdatesIncluded() {
        return this.isStateUpdatesIncluded;
    }

    public void setIsStateUpdatesIncluded(byte isStateUpdatesIncluded) {
        this.isStateUpdatesIncluded = isStateUpdatesIncluded;
    }

    public List<SdNotificationTemplateDetailsDTO> getSdNotificationTemplateDetails() {
        return this.sdNotificationTemplateDetails;
    }

    public void setSdNotificationTemplateDetails(List<SdNotificationTemplateDetailsDTO> sdNotificationTemplateDetails) {
        this.sdNotificationTemplateDetails = sdNotificationTemplateDetails;
    }

    public int getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(int fieldType) {
        this.fieldType = fieldType;
    }

    public int getHtmlTemplateId() {
        return this.htmlTemplateId;
    }

    public void setHtmlTemplateId(int htmlTemplateId) {
        this.htmlTemplateId = htmlTemplateId;
    }

    public Integer getId() {
        return this.getTemplateId();
    }

    public void setId(Integer id) {
        this.setTemplateId(this.templateId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer templateId;
        private Integer projectId;
        private String projectName;
        private String templateName;
        private String description;
        private String templateBody;
        private int templateType;
        private byte isDeletionAllowed;
        private byte isSummaryIncluded;
        private byte isStateUpdatesIncluded;
        private int fieldType;
        private int htmlTemplateId;
        private List<SdNotificationTemplateDetailsDTO> sdNotificationTemplateDetails;

        private Builder() {
        }

        public Builder withTemplateId(Integer templateId) {
            this.templateId = templateId;
            return this;
        }

        public Builder withProjectId(Integer projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder withProjectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public Builder withTemplateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withTemplateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public Builder withTemplateType(int templateType) {
            this.templateType = templateType;
            return this;
        }

        public Builder withIsDeletionAllowed(byte isDeletionAllowed) {
            this.isDeletionAllowed = isDeletionAllowed;
            return this;
        }

        public Builder withIsSummaryIncluded(byte isSummaryIncluded) {
            this.isSummaryIncluded = isSummaryIncluded;
            return this;
        }

        public Builder withIsStateUpdatesIncluded(byte isStateUpdatesIncluded) {
            this.isStateUpdatesIncluded = isStateUpdatesIncluded;
            return this;
        }

        public Builder getFieldType(int fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        public Builder withHtmlTemplateId(int htmlTemplateId) {
            this.htmlTemplateId = htmlTemplateId;
            return this;
        }

        public Builder withSdNotificationTemplateDetails(List<SdNotificationTemplateDetailsDTO> sdNotificationTemplateDetails) {
            this.sdNotificationTemplateDetails = sdNotificationTemplateDetails;
            return this;
        }

        public SdNotificationTemplateDTO build() {
            return new SdNotificationTemplateDTO(this);
        }
    }
}

