/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dto;

import com.sapphireims.dto.BaseDTO;
import com.sapphireims.itsm.model.SdOnaction;
import com.sapphireims.itsm.model.enummodel.DerivedFieldType;

public class SdOnactionDTO
extends BaseDTO {
    private static final long serialVersionUID = 4962914453852566233L;
    private Integer sno;
    private int moduleId;
    private int loadOn;
    private int valuesToLoad;
    private DerivedFieldType type;

    private SdOnactionDTO(Builder builder) {
        this.sno = builder.sno;
        this.moduleId = builder.moduleId;
        this.loadOn = builder.loadOn;
        this.valuesToLoad = builder.valuesToLoad;
        this.type = builder.type;
    }

    public SdOnactionDTO() {
    }

    public SdOnactionDTO(Integer sno, int moduleId, int loadOn, int valuesToLoad) {
        this.sno = sno;
        this.moduleId = moduleId;
        this.loadOn = loadOn;
        this.valuesToLoad = valuesToLoad;
        this.type = DerivedFieldType.getSdServiceParametersMasterEnum(moduleId);
    }

    public SdOnactionDTO(SdOnaction sd) {
        this(sd.getSno(), sd.getModuleId(), sd.getLoadOn(), sd.getValuesToLoad());
    }

    public Integer getSno() {
        return this.sno;
    }

    public void setSno(Integer sno) {
        this.sno = sno;
    }

    public int getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(int moduleId) {
        this.moduleId = moduleId;
    }

    public int getLoadOn() {
        return this.loadOn;
    }

    public void setLoadOn(int loadOn) {
        this.loadOn = loadOn;
    }

    public int getValuesToLoad() {
        return this.valuesToLoad;
    }

    public void setValuesToLoad(int valuesToLoad) {
        this.valuesToLoad = valuesToLoad;
    }

    public static long getSerialversionuid() {
        return 4962914453852566233L;
    }

    public DerivedFieldType getType() {
        return this.type;
    }

    public void setType(DerivedFieldType type) {
        this.type = type;
    }

    public Integer getId() {
        return this.getSno();
    }

    public void setId(Integer id) {
        this.setSno(id);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer sno;
        private int moduleId;
        private int loadOn;
        private int valuesToLoad;
        private DerivedFieldType type;

        private Builder() {
        }

        public Builder withSno(Integer sno) {
            this.sno = sno;
            return this;
        }

        public Builder withModuleId(int moduleId) {
            this.moduleId = moduleId;
            return this;
        }

        public Builder withLoadOn(int loadOn) {
            this.loadOn = loadOn;
            return this;
        }

        public Builder withValuesToLoad(int valuesToLoad) {
            this.valuesToLoad = valuesToLoad;
            return this;
        }

        public Builder withType(DerivedFieldType type) {
            this.type = type;
            return this;
        }

        public SdOnactionDTO build() {
            return new SdOnactionDTO(this);
        }
    }
}

