/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.sapphire.itsm.mailrouting.model.SdAdditionalparams;
import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphireims.dto.BaseDTO;
import com.sapphireims.itsm.dto.SdSearchProfilesDetailsDTO;
import com.sapphireims.itsm.dto.projectcopy.ProjectCopyExportResponce;
import com.sapphireims.itsm.dto.projectcopy.ProjectExportRequestDTO;
import com.sapphireims.itsm.model.SdSearchprofilesDetails;
import com.sapphireims.itsm.model.SdSearchprofilesMaster;
import com.sapphireims.util.CollectionUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SdSearchProfilesMasterDTO
extends BaseDTO {
    private static final long serialVersionUID = -6999217831145125892L;
    private Integer profileId;
    private String profileName;
    private String profileDescrption;
    private int projectId;
    private int userId;
    private int profileType;
    private byte access;
    private String colLookup;
    private String assetColLookup;
    private String cicolLookup;
    private Integer assetModuleId;
    private List<SdSearchProfilesDetailsDTO> sdSearchprofilesDetailses;
    @JsonIgnore
    private List<String> uniqueCategoryIds = new ArrayList<String>();

    public SdSearchProfilesMasterDTO() {
    }

    public SdSearchProfilesMasterDTO(SdSearchprofilesMaster m) {
        this.profileId = m.getProfileId();
        this.profileName = m.getProfileName();
        this.profileDescrption = m.getProfileDescrption();
        this.projectId = m.getProjectId();
        this.userId = m.getUserId();
        this.profileType = m.getProfileType();
        this.access = m.getAccess();
        this.colLookup = m.getColLookup();
        this.assetColLookup = m.getAssetColLookup();
        this.cicolLookup = m.getCicolLookup();
        this.assetModuleId = m.getAssetModuleId();
        if (CollectionUtil.isNotEmpty(m.getSdSearchprofilesDetailses())) {
            this.sdSearchprofilesDetailses = new ArrayList<SdSearchProfilesDetailsDTO>(m.getSdSearchprofilesDetailses().size());
            for (SdSearchprofilesDetails pfd : m.getSdSearchprofilesDetailses()) {
                this.sdSearchprofilesDetailses.add(new SdSearchProfilesDetailsDTO(pfd, m));
            }
        }
    }

    @JsonIgnore
    public SdSearchprofilesMaster getSdSearchprofilesMaster(SdProjectMaster sdProjectMaster, ProjectCopyExportResponce request, ProjectExportRequestDTO req) {
        SdSearchprofilesMaster sspm = new SdSearchprofilesMaster();
        sspm.setProfileName(this.profileName);
        sspm.setProfileDescrption(this.profileDescrption);
        sspm.setProjectId(sdProjectMaster.getProjectId());
        sspm.setUserId(this.userId != 0 ? 1 : 0);
        sspm.setProfileType(this.profileType);
        sspm.setAccess(this.access);
        sspm.setAssetColLookup(this.assetColLookup);
        sspm.setCicolLookup(this.cicolLookup);
        sspm.setAssetModuleId(this.assetModuleId);
        if (this.colLookup != null) {
            sspm.setColLookup(this.getColumnsList(this.colLookup, req));
        }
        if (CollectionUtil.isNotEmpty(this.sdSearchprofilesDetailses)) {
            HashSet<SdSearchprofilesDetails> sdSearchprofilesDetailses = new HashSet<SdSearchprofilesDetails>(this.sdSearchprofilesDetailses.size());
            Boolean isUserCreatedProfile = false;
            for (SdSearchProfilesDetailsDTO det : this.sdSearchprofilesDetailses) {
                SdSearchprofilesDetails details;
                if (det.getType() == null || det.getType().getValue() == 14) continue;
                if (det.getType().getValue() == 1 || det.getType().getValue() == 2 || det.getType().getValue() == 3 || det.getType().getValue() == 4 || det.getType().getValue() == 6 || det.getType().getValue() == 19 || det.getType().getValue() == 20 || det.getType().getValue() == 26) {
                    if (det.getParameterValue().trim().equals("") || det.getParameterValue() == null) continue;
                    if (det.getType().getValue() == 26) {
                        if (this.uniqueCategoryIds.contains(det.getParameterValue().trim())) continue;
                        this.uniqueCategoryIds.add(det.getParameterValue().trim());
                    }
                }
                if ((details = det.getSdSearchprofilesDetails(sspm, req, request, det, isUserCreatedProfile = Boolean.valueOf(det.getType().getValue() == 21))) == null) continue;
                sdSearchprofilesDetailses.add(details);
            }
            sspm.setSdSearchprofilesDetailses(sdSearchprofilesDetailses);
        }
        return sspm;
    }

    @JsonIgnore
    public String getColumnsList(String colmuns, ProjectExportRequestDTO req) {
        String[] colLokups;
        LinkedList<String> colList = new LinkedList<String>();
        for (String s : colLokups = colmuns.split(",")) {
            if (StringUtils.isNumeric((CharSequence)s)) {
                SdAdditionalparams add = req.getOldIdAdditionalparamsMap().get(Integer.parseInt(s));
                if (add == null) continue;
                colList.add(Integer.toString(add.getFieldid()));
                continue;
            }
            if (!StringUtils.isNotEmpty((CharSequence)s) || s == null) continue;
            colList.add(s);
        }
        return String.join((CharSequence)",", colList);
    }

    public SdSearchProfilesMasterDTO(Integer profileId, String profileName, String profileDescrption, int projectId, int userId, int profileType, byte access, String colLookup, String assetColLookup, String cicolLookup, Integer assetModuleId, List<SdSearchProfilesDetailsDTO> sdSearchprofilesDetailses) {
        this.profileId = profileId;
        this.profileName = profileName;
        this.profileDescrption = profileDescrption;
        this.projectId = projectId;
        this.userId = userId;
        this.profileType = profileType;
        this.access = access;
        this.colLookup = colLookup;
        this.assetColLookup = assetColLookup;
        this.cicolLookup = cicolLookup;
        this.assetModuleId = assetModuleId;
        this.sdSearchprofilesDetailses = sdSearchprofilesDetailses;
    }

    public Integer getProfileId() {
        return this.profileId;
    }

    public void setProfileId(Integer profileId) {
        this.profileId = profileId;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getProfileDescrption() {
        return this.profileDescrption;
    }

    public void setProfileDescrption(String profileDescrption) {
        this.profileDescrption = profileDescrption;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public int getProfileType() {
        return this.profileType;
    }

    public void setProfileType(int profileType) {
        this.profileType = profileType;
    }

    public byte getAccess() {
        return this.access;
    }

    public void setAccess(byte access) {
        this.access = access;
    }

    public String getColLookup() {
        return this.colLookup;
    }

    public void setColLookup(String colLookup) {
        this.colLookup = colLookup;
    }

    public String getAssetColLookup() {
        return this.assetColLookup;
    }

    public void setAssetColLookup(String assetColLookup) {
        this.assetColLookup = assetColLookup;
    }

    public String getCicolLookup() {
        return this.cicolLookup;
    }

    public void setCicolLookup(String cicolLookup) {
        this.cicolLookup = cicolLookup;
    }

    public Integer getAssetModuleId() {
        return this.assetModuleId;
    }

    public void setAssetModuleId(Integer assetModuleId) {
        this.assetModuleId = assetModuleId;
    }

    public List<SdSearchProfilesDetailsDTO> getSdSearchprofilesDetailses() {
        return this.sdSearchprofilesDetailses;
    }

    public void setSdSearchprofilesDetailses(List<SdSearchProfilesDetailsDTO> sdSearchprofilesDetailses) {
        this.sdSearchprofilesDetailses = sdSearchprofilesDetailses;
    }

    public Integer getId() {
        return this.profileId;
    }

    public void setId(Integer id) {
        this.setProfileId(id);
    }
}

