/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphireims.dto.BaseDTO;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.itsm.dto.SdServiceParametersDetailsDTO;
import com.sapphireims.itsm.dto.SdServicecatalogueCategorydetailsDTO;
import com.sapphireims.itsm.dto.SdServicecatalogueDetailsDTO;
import com.sapphireims.itsm.dto.SdSettingoperationHistoryDTO;
import com.sapphireims.itsm.model.SdService;
import com.sapphireims.itsm.model.SdServiceParametersDetails;
import com.sapphireims.itsm.model.SdServicecatalogueCategorydetails;
import com.sapphireims.itsm.model.SdServicecatalogueDetails;
import com.sapphireims.util.CollectionUtil;
import com.sapphireims.util.Validate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SdServiceDTO
extends BaseDTO {
    private static final long serialVersionUID = -6390841827490992060L;
    private Integer serviceId;
    private Integer projectId;
    private String projectName;
    private String serviceName;
    private String serviceDescription;
    private int status;
    private String defaultImageName;
    private String shortName;
    private byte isMobileVisibility;
    private List<SdServiceParametersDetailsDTO> parametersDetails;
    private List<SdServicecatalogueCategorydetailsDTO> servicecatalogueCategorydetails;
    private List<SdServicecatalogueDetailsDTO> servicecatalogueDetails;
    private SdSettingoperationHistoryDTO historyDTO;

    private SdServiceDTO(Builder builder) {
        this.serviceId = builder.serviceId;
        this.projectId = builder.projectId;
        this.projectName = builder.projectName;
        this.serviceName = builder.serviceName;
        this.serviceDescription = builder.serviceDescription;
        this.status = builder.status;
        this.defaultImageName = builder.defaultImageName;
        this.shortName = builder.shortName;
        this.isMobileVisibility = builder.isMobileVisibility;
        this.parametersDetails = builder.parametersDetails;
        this.servicecatalogueCategorydetails = builder.servicecatalogueCategorydetails;
        this.servicecatalogueDetails = builder.servicecatalogueDetails;
    }

    public SdServiceDTO() {
    }

    @JsonIgnore
    public SdServiceDTO addServicecatalogueCategorydetails(Collection<SdServicecatalogueCategorydetails> servicecatalogueCategorydetails) {
        if (CollectionUtil.isNotEmpty(servicecatalogueCategorydetails)) {
            this.servicecatalogueCategorydetails = new ArrayList<SdServicecatalogueCategorydetailsDTO>(servicecatalogueCategorydetails.size());
            for (SdServicecatalogueCategorydetails d : servicecatalogueCategorydetails) {
                this.servicecatalogueCategorydetails.add(new SdServicecatalogueCategorydetailsDTO(d));
            }
        }
        return this;
    }

    @JsonIgnore
    public SdServiceDTO addServicecatalogueDetails(Collection<SdServicecatalogueDetails> servicecatalogueDetails) {
        if (CollectionUtil.isNotEmpty(servicecatalogueDetails)) {
            this.servicecatalogueDetails = new ArrayList<SdServicecatalogueDetailsDTO>(servicecatalogueDetails.size());
            for (SdServicecatalogueDetails d : servicecatalogueDetails) {
                this.servicecatalogueDetails.add(new SdServicecatalogueDetailsDTO(d));
            }
        }
        return this;
    }

    public SdServiceDTO(SdService service, SdProjectMaster sdpm, Collection<SdServiceParametersDetails> parametersDetails) {
        this.serviceId = service.getServiceId();
        this.projectId = sdpm.getProjectId();
        this.projectName = sdpm.getProjectName();
        this.serviceName = service.getServiceName();
        this.serviceDescription = service.getServiceDescription();
        this.status = service.getStatus();
        this.defaultImageName = service.getDefaultImageName();
        this.shortName = service.getShortName();
        this.isMobileVisibility = service.getIsMobileVisibility();
        if (CollectionUtil.isNotEmpty(parametersDetails)) {
            this.parametersDetails = new ArrayList<SdServiceParametersDetailsDTO>(parametersDetails.size());
            for (SdServiceParametersDetails det : parametersDetails) {
                this.parametersDetails.add(new SdServiceParametersDetailsDTO(det));
            }
        }
    }

    public SdServiceDTO addSdServiceParametersDetails(SdServiceParametersDetails de) {
        if (this.parametersDetails == null) {
            this.parametersDetails = new ArrayList<SdServiceParametersDetailsDTO>();
        }
        this.parametersDetails.add(new SdServiceParametersDetailsDTO(de));
        return this;
    }

    public SdServiceDTO(SdService service, SdProjectMaster sdpm) {
        this.serviceId = service.getServiceId();
        this.projectId = sdpm.getProjectId();
        this.projectName = sdpm.getProjectName();
        this.serviceName = service.getServiceName();
        this.serviceDescription = service.getServiceDescription();
        this.status = service.getStatus();
        this.defaultImageName = service.getDefaultImageName();
        this.shortName = service.getShortName();
        this.isMobileVisibility = service.getIsMobileVisibility();
    }

    public SdServiceDTO(SdService service) {
        this.serviceId = service.getServiceId();
        this.setId(service.getServiceId());
        this.serviceName = service.getServiceName();
        this.serviceDescription = service.getServiceDescription();
        this.status = service.getStatus();
        this.defaultImageName = service.getDefaultImageName();
        this.shortName = service.getShortName();
        this.isMobileVisibility = service.getIsMobileVisibility();
    }

    public List<SdServicecatalogueCategorydetailsDTO> getServicecatalogueCategorydetails() {
        return this.servicecatalogueCategorydetails;
    }

    public void setServicecatalogueCategorydetails(List<SdServicecatalogueCategorydetailsDTO> servicecatalogueCategorydetails) {
        this.servicecatalogueCategorydetails = servicecatalogueCategorydetails;
    }

    public List<SdServicecatalogueDetailsDTO> getServicecatalogueDetails() {
        return this.servicecatalogueDetails;
    }

    public void setServicecatalogueDetails(List<SdServicecatalogueDetailsDTO> servicecatalogueDetails) {
        this.servicecatalogueDetails = servicecatalogueDetails;
    }

    public Integer getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(Integer serviceId) {
        this.serviceId = serviceId;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceDescription() {
        return this.serviceDescription;
    }

    public void setServiceDescription(String serviceDescription) {
        this.serviceDescription = serviceDescription;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getDefaultImageName() {
        return this.defaultImageName;
    }

    public void setDefaultImageName(String defaultImageName) {
        this.defaultImageName = defaultImageName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public byte getIsMobileVisibility() {
        return this.isMobileVisibility;
    }

    public void setIsMobileVisibility(byte isMobileVisibility) {
        this.isMobileVisibility = isMobileVisibility;
    }

    public List<SdServiceParametersDetailsDTO> getParametersDetails() {
        return this.parametersDetails;
    }

    public void setParametersDetails(List<SdServiceParametersDetailsDTO> parametersDetails) {
        this.parametersDetails = parametersDetails;
    }

    public SdSettingoperationHistoryDTO getHistoryDTO() {
        return this.historyDTO;
    }

    public void setHistoryDTO(SdSettingoperationHistoryDTO historyDTO) {
        this.historyDTO = historyDTO;
    }

    public void validate() throws DomainException, ValidationException {
        Validate.notNull((Object)this.serviceName, (String)"Service Name can't be null", (Object[])new Object[0]);
        Validate.notNull(this.parametersDetails, (String)"parametersDetails can't be null", (Object[])new Object[0]);
    }

    public Integer getId() {
        return this.getServiceId();
    }

    public void setId(Integer id) {
        this.setServiceId(id);
    }

    public String toString() {
        return "SdServiceDTO [serviceId=" + this.serviceId + ", projectId=" + this.projectId + ", projectName=" + this.projectName + ", serviceName=" + this.serviceName + ", serviceDescription=" + this.serviceDescription + ", status=" + this.status + ", defaultImageName=" + this.defaultImageName + ", shortName=" + this.shortName + ", isMobileVisibility=" + this.isMobileVisibility + ", parametersDetails=" + String.valueOf(this.parametersDetails) + ", servicecatalogueCategorydetails=" + String.valueOf(this.servicecatalogueCategorydetails) + ", servicecatalogueDetails=" + String.valueOf(this.servicecatalogueDetails) + ", historyDTO=" + String.valueOf((Object)this.historyDTO) + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer serviceId;
        private Integer projectId;
        private String projectName;
        private String serviceName;
        private String serviceDescription;
        private int status;
        private String defaultImageName;
        private String shortName;
        private byte isMobileVisibility;
        private List<SdServiceParametersDetailsDTO> parametersDetails;
        private List<SdServicecatalogueCategorydetailsDTO> servicecatalogueCategorydetails;
        private List<SdServicecatalogueDetailsDTO> servicecatalogueDetails;

        private Builder() {
        }

        public Builder withServiceId(Integer serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public Builder withProjectId(Integer projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder withProjectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public Builder withServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder withServiceDescription(String serviceDescription) {
            this.serviceDescription = serviceDescription;
            return this;
        }

        public Builder withStatus(int status) {
            this.status = status;
            return this;
        }

        public Builder withDefaultImageName(String defaultImageName) {
            this.defaultImageName = defaultImageName;
            return this;
        }

        public Builder withShortName(String shortName) {
            this.shortName = shortName;
            return this;
        }

        public Builder withIsMobileVisibility(byte isMobileVisibility) {
            this.isMobileVisibility = isMobileVisibility;
            return this;
        }

        public Builder withParametersDetails(List<SdServiceParametersDetailsDTO> parametersDetails) {
            this.parametersDetails = parametersDetails;
            return this;
        }

        public Builder withServicecatalogueCategorydetails(List<SdServicecatalogueCategorydetailsDTO> servicecatalogueCategorydetails) {
            this.servicecatalogueCategorydetails = servicecatalogueCategorydetails;
            return this;
        }

        public Builder withServicecatalogueDetails(List<SdServicecatalogueDetailsDTO> servicecatalogueDetails) {
            this.servicecatalogueDetails = servicecatalogueDetails;
            return this;
        }

        public SdServiceDTO build() {
            return new SdServiceDTO(this);
        }
    }
}

