/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dto;

import com.sapphireims.dto.BaseDTO;
import com.sapphireims.itsm.model.SdServicereqHistorystatements;

public class SdServicereqHistorystatementsDTO
extends BaseDTO {
    private static final long serialVersionUID = 8264464976294323899L;
    private Integer statementId;
    private Integer projectId;
    private String natureOfChange;
    private String statement;

    public SdServicereqHistorystatementsDTO() {
    }

    public SdServicereqHistorystatementsDTO(Integer statementId, Integer projectId, String natureOfChange, String statement) {
        this.statementId = statementId;
        this.projectId = projectId;
        this.natureOfChange = natureOfChange;
        this.statement = statement;
    }

    public SdServicereqHistorystatementsDTO(SdServicereqHistorystatements history) {
        this.statementId = history.getStatementId();
        this.projectId = history.getSdProjectMaster().getProjectId();
        this.natureOfChange = history.getNatureOfChange();
        this.statement = history.getStatement();
    }

    public Integer getStatementId() {
        return this.statementId;
    }

    public void setStatementId(Integer statementId) {
        this.statementId = statementId;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public String getNatureOfChange() {
        return this.natureOfChange;
    }

    public void setNatureOfChange(String natureOfChange) {
        this.natureOfChange = natureOfChange;
    }

    public String getStatement() {
        return this.statement;
    }

    public void setStatement(String statement) {
        this.statement = statement;
    }

    public Integer getId() {
        return this.getStatementId();
    }

    public void setId(Integer id) {
        this.setStatementId(id);
    }

    private SdServicereqHistorystatementsDTO(Builder builder) {
        this.statementId = builder.statementId;
        this.projectId = builder.projectId;
        this.natureOfChange = builder.natureOfChange;
        this.statement = builder.statement;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Integer statementId;
        private Integer projectId;
        private String natureOfChange;
        private String statement;

        public Builder withStatementId(Integer statementId) {
            this.statementId = statementId;
            return this;
        }

        public Builder withProjectId(Integer projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder withNatureOfChange(String natureOfChange) {
            this.natureOfChange = natureOfChange;
            return this;
        }

        public Builder withStatement(String statement) {
            this.statement = statement;
            return this;
        }

        public SdServicereqHistorystatementsDTO build() {
            return new SdServicereqHistorystatementsDTO(this);
        }
    }
}

