/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dto;

import com.google.common.base.MoreObjects;
import com.sapphire.itsm.mailrouting.model.SdStatesMaster;
import com.sapphireims.dto.BaseDTO;
import com.sapphireims.itsm.dto.SdMultiapprovalMasterDTO;
import com.sapphireims.itsm.dto.SdSettingoperationHistoryDTO;
import com.sapphireims.itsm.dto.SdStateRolesDTO;
import com.sapphireims.itsm.dto.SdStatecategoryDetailsDTO;
import com.sapphireims.itsm.dto.SdStatesFixedfieldsDTO;
import com.sapphireims.itsm.model.SdMultiapprovalDetails;
import com.sapphireims.itsm.model.SdMultiapprovalMaster;
import com.sapphireims.itsm.model.SdStateRoles;
import com.sapphireims.itsm.model.SdStatecategoryDetails;
import com.sapphireims.itsm.model.SdStatesFixedfields;
import com.sapphireims.itsm.model.enummodel.SdStateFixedField;
import com.sapphireims.util.CollectionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SdStatesMasterDTO
extends BaseDTO {
    private static final long serialVersionUID = -1234579178410703010L;
    private Integer stateId;
    private Integer projectId;
    private String projectName;
    private String stateName;
    private Byte isPurgeIntervalConsider;
    private Integer timeInterval;
    private byte deletionAllowed;
    private int status;
    private byte isStartState;
    private byte isEndState;
    private String shortName;
    private String color;
    private Integer stateCategoryId;
    private String inheritedFrom;
    private String stateCategoryName;
    private String inheritedFromText;
    private int isInheritedFromChangedForEdit;
    private List<SdStatecategoryDetailsDTO> sdStatecategoryDetailses;
    private List<SdStatesFixedfieldsDTO> sdStatesFixedfieldses;
    private List<SdStateRolesDTO> sdStateRoles;
    private List<SdMultiapprovalMasterDTO> sdMultiapprovalMasters;
    private SdSettingoperationHistoryDTO historyDTO;
    private SdStateFixedField sdStateFixedField;
    private List<SdSettingoperationHistoryDTO> sdSettingoperationHistoryDTOList;

    public SdStatesMasterDTO() {
    }

    public SdStatesMasterDTO(Integer id) {
        super(id);
        this.stateId = id;
    }

    public SdStatesMasterDTO(SdStatesMaster stm, Set<SdStatecategoryDetails> sdStatecategoryDetailses, Set<SdStatesFixedfields> sdStatesFixedfieldses) {
        this.stateId = stm.getStateId();
        this.id = stm.getStateId();
        this.projectId = stm.getSdProjectMaster().getProjectId();
        this.projectName = stm.getSdProjectMaster().getProjectName();
        this.stateName = stm.getStateName();
        this.isPurgeIntervalConsider = stm.getIsPurgeIntervalConsider();
        this.timeInterval = stm.getTimeInterval();
        this.deletionAllowed = stm.getDeletionAllowed();
        this.status = stm.getStatus();
        this.isStartState = stm.getIsStartState();
        this.isEndState = stm.getIsEndState();
        this.shortName = stm.getShortName();
        this.color = stm.getColor();
        if (CollectionUtil.isNotEmpty(sdStatecategoryDetailses)) {
            this.sdStatecategoryDetailses = new ArrayList<SdStatecategoryDetailsDTO>(sdStatecategoryDetailses.size());
            for (SdStatecategoryDetails sdStatecategoryDetails : sdStatecategoryDetailses) {
                this.sdStatecategoryDetailses.add(new SdStatecategoryDetailsDTO(sdStatecategoryDetails, stm));
            }
        }
        if (CollectionUtil.isNotEmpty(sdStatesFixedfieldses)) {
            this.sdStatesFixedfieldses = new ArrayList<SdStatesFixedfieldsDTO>(sdStatesFixedfieldses.size());
            for (SdStatesFixedfields sdStatesFixedfields : sdStatesFixedfieldses) {
                this.sdStatesFixedfieldses.add(new SdStatesFixedfieldsDTO(sdStatesFixedfields, stm, sdStatesFixedfields.getSdStatesFixedfieldsPermissionses()));
                this.sdStateFixedField = SdStateFixedField.getSdStateFixedFieldEnum(sdStatesFixedfields.getInput());
            }
        }
    }

    public SdStatesMasterDTO(SdStatesMaster stm) {
        this.stateId = stm.getStateId();
        this.id = stm.getStateId();
        this.projectId = stm.getSdProjectMaster().getProjectId();
        this.projectName = stm.getSdProjectMaster().getProjectName();
        this.stateName = stm.getStateName();
        this.isPurgeIntervalConsider = stm.getIsPurgeIntervalConsider();
        this.timeInterval = stm.getTimeInterval();
        this.deletionAllowed = stm.getDeletionAllowed();
        this.status = stm.getStatus();
        this.isStartState = stm.getIsStartState();
        this.isEndState = stm.getIsEndState();
        this.shortName = stm.getShortName();
        this.color = stm.getColor();
    }

    public SdStatesMasterDTO(SdStatesMasterDTO stm) {
        this.stateId = stm.getStateId();
        this.id = stm.getStateId();
        this.stateName = stm.getStateName();
        this.isPurgeIntervalConsider = stm.getIsPurgeIntervalConsider();
        this.timeInterval = stm.getTimeInterval();
        this.deletionAllowed = stm.getDeletionAllowed();
        this.status = stm.getStatus();
        this.isStartState = stm.getIsStartState();
        this.isEndState = stm.getIsEndState();
        this.shortName = stm.getShortName();
        this.color = stm.getColor();
        this.stateCategoryId = CollectionUtil.isNotEmpty(stm.getSdStatecategoryDetailses()) ? stm.getSdStatecategoryDetailses().get(0).getStateCategoryId() : 0;
    }

    public SdStatesMasterDTO addSdStateRoles(List<SdStateRoles> sdStateRoles, SdStatesMaster stm) {
        if (CollectionUtil.isNotEmpty(sdStateRoles)) {
            this.sdStateRoles = new ArrayList<SdStateRolesDTO>(sdStateRoles.size());
            for (SdStateRoles r : sdStateRoles) {
                this.sdStateRoles.add(new SdStateRolesDTO(r, stm));
            }
        }
        return this;
    }

    public SdStatesMasterDTO addSdMultiapprovalMasters(List<SdMultiapprovalMaster> sdMultiapprovalMasters, SdStatesMaster stm, Map<Integer, List<SdMultiapprovalDetails>> multiapprovalDetailsByMultiapprovalMaster) {
        if (CollectionUtil.isNotEmpty(sdMultiapprovalMasters)) {
            this.sdMultiapprovalMasters = new ArrayList<SdMultiapprovalMasterDTO>(sdMultiapprovalMasters.size());
            for (SdMultiapprovalMaster sd : sdMultiapprovalMasters) {
                SdMultiapprovalMasterDTO sdMu = new SdMultiapprovalMasterDTO(sd, stm);
                if (multiapprovalDetailsByMultiapprovalMaster.containsKey(sd.getAppRuleId())) {
                    sdMu = sdMu.addMultiapprovalDetails(multiapprovalDetailsByMultiapprovalMaster.get(sd.getAppRuleId()), sd);
                }
                this.sdMultiapprovalMasters.add(sdMu);
            }
        }
        return this;
    }

    public boolean containsStaeCategory(Integer categoryId) {
        if (CollectionUtil.isNotEmpty(this.sdStatecategoryDetailses)) {
            return this.sdStatecategoryDetailses.stream().anyMatch(s -> s.getStateCategoryId() == categoryId.intValue());
        }
        return false;
    }

    public Integer getStateId() {
        return this.stateId;
    }

    public void setStateId(Integer stateId) {
        this.stateId = stateId;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getStateName() {
        return this.stateName;
    }

    public void setStateName(String stateName) {
        this.stateName = stateName;
    }

    public Byte getIsPurgeIntervalConsider() {
        return this.isPurgeIntervalConsider;
    }

    public void setIsPurgeIntervalConsider(Byte isPurgeIntervalConsider) {
        this.isPurgeIntervalConsider = isPurgeIntervalConsider;
    }

    public Integer getTimeInterval() {
        return this.timeInterval;
    }

    public void setTimeInterval(Integer timeInterval) {
        this.timeInterval = timeInterval;
    }

    public byte getDeletionAllowed() {
        return this.deletionAllowed;
    }

    public void setDeletionAllowed(byte deletionAllowed) {
        this.deletionAllowed = deletionAllowed;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public byte getIsStartState() {
        return this.isStartState;
    }

    public void setIsStartState(byte isStartState) {
        this.isStartState = isStartState;
    }

    public byte getIsEndState() {
        return this.isEndState;
    }

    public void setIsEndState(byte isEndState) {
        this.isEndState = isEndState;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public Integer getStateCategoryId() {
        return this.stateCategoryId;
    }

    public void setStateCategoryId(Integer stateCategoryId) {
        this.stateCategoryId = stateCategoryId;
    }

    public String getInheritedFrom() {
        return this.inheritedFrom;
    }

    public void setInheritedFrom(String inheritedFrom) {
        this.inheritedFrom = inheritedFrom;
    }

    public String getStateCategoryName() {
        return this.stateCategoryName;
    }

    public void setStateCategoryName(String stateCategoryName) {
        this.stateCategoryName = stateCategoryName;
    }

    public String getInheritedFromText() {
        return this.inheritedFromText;
    }

    public void setInheritedFromText(String inheritedFromText) {
        this.inheritedFromText = inheritedFromText;
    }

    public int getIsInheritedFromChangedForEdit() {
        return this.isInheritedFromChangedForEdit;
    }

    public void setIsInheritedFromChangedForEdit(int isInheritedFromChangedForEdit) {
        this.isInheritedFromChangedForEdit = isInheritedFromChangedForEdit;
    }

    public List<SdStatecategoryDetailsDTO> getSdStatecategoryDetailses() {
        return this.sdStatecategoryDetailses;
    }

    public void setSdStatecategoryDetailses(List<SdStatecategoryDetailsDTO> sdStatecategoryDetailses) {
        this.sdStatecategoryDetailses = sdStatecategoryDetailses;
    }

    public List<SdStatesFixedfieldsDTO> getSdStatesFixedfieldses() {
        return this.sdStatesFixedfieldses;
    }

    public void setSdStatesFixedfieldses(List<SdStatesFixedfieldsDTO> sdStatesFixedfieldses) {
        this.sdStatesFixedfieldses = sdStatesFixedfieldses;
    }

    public List<SdStateRolesDTO> getSdStateRoles() {
        return this.sdStateRoles;
    }

    public void setSdStateRoles(List<SdStateRolesDTO> sdStateRoles) {
        this.sdStateRoles = sdStateRoles;
    }

    public List<SdMultiapprovalMasterDTO> getSdMultiapprovalMasters() {
        return this.sdMultiapprovalMasters;
    }

    public void setSdMultiapprovalMasters(List<SdMultiapprovalMasterDTO> sdMultiapprovalMasters) {
        this.sdMultiapprovalMasters = sdMultiapprovalMasters;
    }

    public SdSettingoperationHistoryDTO getHistoryDTO() {
        return this.historyDTO;
    }

    public void setHistoryDTO(SdSettingoperationHistoryDTO historyDTO) {
        this.historyDTO = historyDTO;
    }

    public SdStateFixedField getSdStateFixedField() {
        return this.sdStateFixedField;
    }

    public void setSdStateFixedField(SdStateFixedField sdStateFixedField) {
        this.sdStateFixedField = sdStateFixedField;
    }

    public List<SdSettingoperationHistoryDTO> getSdSettingoperationHistoryDTOList() {
        return this.sdSettingoperationHistoryDTOList;
    }

    public void setSdSettingoperationHistoryDTOList(List<SdSettingoperationHistoryDTO> sdSettingoperationHistoryDTOList) {
        this.sdSettingoperationHistoryDTOList = sdSettingoperationHistoryDTOList;
    }

    public Integer getId() {
        return this.getStateId();
    }

    public void setId(Integer id) {
        this.setStateId(id);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.stateId, this.projectId, this.projectName, this.stateName, this.isPurgeIntervalConsider, this.timeInterval, this.deletionAllowed, this.status, this.isStartState, this.isEndState, this.shortName, this.color, this.stateCategoryId, this.inheritedFrom, this.stateCategoryName, this.inheritedFromText, this.isInheritedFromChangedForEdit, this.sdStatecategoryDetailses, this.sdStatesFixedfieldses, this.sdStateRoles, this.sdMultiapprovalMasters, this.historyDTO, this.sdStateFixedField});
    }

    public boolean equals(Object object) {
        if (object instanceof SdStatesMasterDTO) {
            if (!super.equals(object)) {
                return false;
            }
            SdStatesMasterDTO that = (SdStatesMasterDTO)((Object)object);
            return Objects.equals(this.stateId, that.stateId) && Objects.equals(this.projectId, that.projectId) && Objects.equals(this.projectName, that.projectName) && Objects.equals(this.stateName, that.stateName) && Objects.equals(this.isPurgeIntervalConsider, that.isPurgeIntervalConsider) && Objects.equals(this.timeInterval, that.timeInterval) && this.deletionAllowed == that.deletionAllowed && this.status == that.status && this.isStartState == that.isStartState && this.isEndState == that.isEndState && Objects.equals(this.shortName, that.shortName) && Objects.equals(this.color, that.color) && Objects.equals(this.stateCategoryId, that.stateCategoryId) && Objects.equals(this.inheritedFrom, that.inheritedFrom) && Objects.equals(this.stateCategoryName, that.stateCategoryName) && Objects.equals(this.inheritedFromText, that.inheritedFromText) && this.isInheritedFromChangedForEdit == that.isInheritedFromChangedForEdit && Objects.equals(this.sdStatecategoryDetailses, that.sdStatecategoryDetailses) && Objects.equals(this.sdStatesFixedfieldses, that.sdStatesFixedfieldses) && Objects.equals(this.sdStateRoles, that.sdStateRoles) && Objects.equals(this.sdMultiapprovalMasters, that.sdMultiapprovalMasters) && Objects.equals((Object)this.historyDTO, (Object)that.historyDTO) && Objects.equals((Object)this.sdStateFixedField, (Object)that.sdStateFixedField);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("super", (Object)super.toString()).add("serialVersionUID", -1234579178410703010L).add("stateId", (Object)this.stateId).add("projectId", (Object)this.projectId).add("projectName", (Object)this.projectName).add("stateName", (Object)this.stateName).add("isPurgeIntervalConsider", (Object)this.isPurgeIntervalConsider).add("timeInterval", (Object)this.timeInterval).add("deletionAllowed", (int)this.deletionAllowed).add("status", this.status).add("isStartState", (int)this.isStartState).add("isEndState", (int)this.isEndState).add("shortName", (Object)this.shortName).add("color", (Object)this.color).add("stateCategoryId", (Object)this.stateCategoryId).add("inheritedFrom", (Object)this.inheritedFrom).add("stateCategoryName", (Object)this.stateCategoryName).add("inheritedFromText", (Object)this.inheritedFromText).add("isInheritedFromChangedForEdit", this.isInheritedFromChangedForEdit).add("sdStatecategoryDetailses", this.sdStatecategoryDetailses).add("sdStatesFixedfieldses", this.sdStatesFixedfieldses).add("sdStateRoles", this.sdStateRoles).add("sdMultiapprovalMasters", this.sdMultiapprovalMasters).add("historyDTO", (Object)this.historyDTO).add("sdStateFixedField", (Object)this.sdStateFixedField).toString();
    }
}

