/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.sapphire.itsm.mailrouting.model.SdProjectRoles;
import com.sapphireims.dto.BaseDTO;
import com.sapphireims.itsm.dto.projectcopy.ProjectCopyExportResponce;
import com.sapphireims.itsm.dto.projectcopy.ProjectCopyType;
import com.sapphireims.itsm.dto.projectcopy.ProjectExportRequestDTO;
import com.sapphireims.itsm.model.Departmentmaster;
import com.sapphireims.itsm.model.SdTeamDetails;
import com.sapphireims.itsm.model.SdTeamMaster;
import com.sapphireims.itsm.model.Servicedesklocationmaster;
import com.sapphireims.itsm.model.enummodel.TeamType;

public class SdTeamDetailsDTO
extends BaseDTO {
    private static final long serialVersionUID = -2353950878175977643L;
    private Integer teamId;
    private String name;
    private int parameterType;
    private String parameterValue;
    private int ouparentParameterValue;
    private TeamType type;

    public SdTeamDetailsDTO() {
    }

    public SdTeamDetailsDTO(SdTeamDetails d, SdTeamMaster m) {
        this.id = d.getId();
        this.teamId = m.getTeamId();
        this.name = m.getName();
        this.parameterType = d.getParameterType();
        this.parameterValue = d.getParameterValue();
        this.ouparentParameterValue = d.getOuparentParameterValue();
        this.type = TeamType.getTeamTypeEnum(this.parameterType);
    }

    @JsonIgnore
    public SdTeamDetails getSdTeamDetails(SdTeamMaster m, ProjectExportRequestDTO req, ProjectCopyExportResponce request) {
        String accessValue = this.parameterValue;
        switch (this.type) {
            case DEPARTMENT: {
                if (request.getType() != ProjectCopyType.UAT_TO_PRODUCTION) break;
                Departmentmaster d = req.getTenant().getMapDepartments().get(Integer.parseInt(accessValue));
                accessValue = d != null ? Integer.toString(d.getDepartmentId()) : null;
                break;
            }
            case LOCATION: {
                if (request.getType() != ProjectCopyType.UAT_TO_PRODUCTION) break;
                Servicedesklocationmaster l = req.getTenant().getMapLocations().get(Integer.parseInt(accessValue));
                accessValue = l != null ? Integer.toString(l.getLocationId()) : null;
                break;
            }
            case ROLE: {
                SdProjectRoles role = req.getOldIdSdProjectRoles().get(Integer.parseInt(accessValue));
                accessValue = role != null ? Integer.toString(role.getProjectRoleId()) : null;
                break;
            }
            case USER: {
                accessValue = "1";
                break;
            }
            default: {
                accessValue = null;
            }
        }
        if (accessValue != null) {
            return new SdTeamDetails(m, this.parameterType, accessValue, this.ouparentParameterValue);
        }
        return null;
    }

    public SdTeamDetailsDTO(Integer id, Integer teamId, String name, int parameterType, String parameterValue, int ouparentParameterValue) {
        this.id = id;
        this.teamId = teamId;
        this.name = name;
        this.parameterType = parameterType;
        this.parameterValue = parameterValue;
        this.ouparentParameterValue = ouparentParameterValue;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public int getParameterType() {
        return this.parameterType;
    }

    public void setParameterType(int parameterType) {
        this.parameterType = parameterType;
    }

    public String getParameterValue() {
        return this.parameterValue;
    }

    public void setParameterValue(String parameterValue) {
        this.parameterValue = parameterValue;
    }

    public int getOuparentParameterValue() {
        return this.ouparentParameterValue;
    }

    public void setOuparentParameterValue(int ouparentParameterValue) {
        this.ouparentParameterValue = ouparentParameterValue;
    }

    public Integer getTeamId() {
        return this.teamId;
    }

    public void setTeamId(Integer teamId) {
        this.teamId = teamId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TeamType getType() {
        return this.type;
    }

    public void setType(TeamType type) {
        this.type = type;
    }
}

