/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphireims.dto.BaseDTO;
import com.sapphireims.itsm.dto.SdTeamDetailsDTO;
import com.sapphireims.itsm.dto.projectcopy.ProjectCopyExportResponce;
import com.sapphireims.itsm.dto.projectcopy.ProjectExportRequestDTO;
import com.sapphireims.itsm.model.SdTeamDetails;
import com.sapphireims.itsm.model.SdTeamMaster;
import com.sapphireims.util.CollectionUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class SdTeamMasterDTO
extends BaseDTO {
    private static final long serialVersionUID = -1484327263265733169L;
    private Integer teamId;
    private Integer projectId;
    private String projectName;
    private String name;
    private String description;
    private byte status;
    private List<SdTeamDetailsDTO> sdTeamDetailses;

    public SdTeamMasterDTO(SdTeamMaster m, SdProjectMaster p) {
        this.teamId = m.getTeamId();
        this.projectId = p.getProjectId();
        this.projectName = p.getProjectName();
        this.name = m.getName();
        this.description = m.getDescription();
        this.status = m.getStatus();
        if (CollectionUtil.isNotEmpty(m.getSdTeamDetailses())) {
            this.sdTeamDetailses = new ArrayList<SdTeamDetailsDTO>(m.getSdTeamDetailses().size());
            for (SdTeamDetails d : m.getSdTeamDetailses()) {
                this.sdTeamDetailses.add(new SdTeamDetailsDTO(d, m));
            }
        }
    }

    @JsonIgnore
    public SdTeamMaster getSdTeamMaster(SdProjectMaster sdProjectMaster, ProjectExportRequestDTO req, ProjectCopyExportResponce request) {
        SdTeamMaster m = new SdTeamMaster(sdProjectMaster, this.name, this.description, this.status);
        if (CollectionUtil.isNotEmpty(this.sdTeamDetailses)) {
            ArrayList<SdTeamDetails> sdTeamDetailses = new ArrayList<SdTeamDetails>(this.sdTeamDetailses.size());
            for (SdTeamDetailsDTO d : this.sdTeamDetailses) {
                SdTeamDetails details = d.getSdTeamDetails(m, req, request);
                if (details == null) continue;
                sdTeamDetailses.add(details);
            }
            m.setSdTeamDetailses(new HashSet<SdTeamDetails>(sdTeamDetailses));
        }
        return m;
    }

    public SdTeamMasterDTO() {
    }

    public SdTeamMasterDTO(Integer teamId, Integer projectId, String projectName, String name, String description, byte status, List<SdTeamDetailsDTO> sdTeamDetailses) {
        this.teamId = teamId;
        this.projectId = projectId;
        this.projectName = projectName;
        this.name = name;
        this.description = description;
        this.status = status;
        this.sdTeamDetailses = sdTeamDetailses;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Integer getTeamId() {
        return this.teamId;
    }

    public void setTeamId(Integer teamId) {
        this.teamId = teamId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public byte getStatus() {
        return this.status;
    }

    public void setStatus(byte status) {
        this.status = status;
    }

    public List<SdTeamDetailsDTO> getSdTeamDetailses() {
        return this.sdTeamDetailses;
    }

    public void setSdTeamDetailses(List<SdTeamDetailsDTO> sdTeamDetailses) {
        this.sdTeamDetailses = sdTeamDetailses;
    }

    public Integer getId() {
        return this.teamId;
    }

    public void setId(Integer id) {
        this.setTeamId(id);
    }
}

