/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dto;

import com.sapphireims.dto.BaseDTO;
import com.sapphireims.exception.DomainException;
import com.sapphireims.itsm.model.SdTemplate;
import com.sapphireims.itsm.model.enummodel.TemplateType;
import com.sapphireims.util.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class SdTemplateDTO
extends BaseDTO {
    private static final long serialVersionUID = -6312946264914211190L;
    private String name;
    private String template;
    private TemplateType type;
    private Integer projectId;
    private String projectName;
    private String attachmentName;
    private Integer assetModuleId;
    private Integer isCMDB;

    private SdTemplateDTO(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.template = builder.template;
        this.type = builder.type;
        this.projectId = builder.projectId;
        this.projectName = builder.projectName;
        this.attachmentName = builder.attachmentName;
        this.assetModuleId = builder.assetModuleId;
        this.isCMDB = builder.isCMDB;
    }

    public SdTemplateDTO() {
    }

    public SdTemplateDTO(SdTemplate sd) {
        super(sd.getId());
        this.id = sd.getId();
        this.name = sd.getName();
        this.template = sd.getTemplate();
        this.type = sd.getType();
        if (sd.getIsCMDB() == 0) {
            this.projectId = sd.getSdProjectMaster().getProjectId();
            this.projectName = sd.getSdProjectMaster().getProjectName();
            this.isCMDB = 0;
        } else {
            this.assetModuleId = sd.getAssetModuleId();
            this.isCMDB = sd.getIsCMDB();
        }
        this.attachmentName = sd.getAttachmentName();
    }

    public SdTemplateDTO(String name, String template, TemplateType type, Integer projectId, String projectName, String attachmentName) {
        this.name = name;
        this.template = template;
        this.type = type;
        this.projectId = projectId;
        this.projectName = projectName;
        this.attachmentName = attachmentName;
    }

    public void validate() throws DomainException {
        Validate.notNull((Object)this.name, (String)"Template Name can't Be Empty", (Object[])new Object[0]);
        Validate.notNull((Object)this.template, (String)"Template can't be Empty", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)this.type), (String)"Template type Can't be EMpty ", (Object[])new Object[0]);
        Validate.notNull((Object)this.projectId, (String)"Project id is Manditory", (Object[])new Object[0]);
    }

    public String getAttachmentName() {
        return this.attachmentName;
    }

    public void setAttachmentName(String attachmentName) {
        this.attachmentName = attachmentName;
    }

    public SdTemplateDTO(Integer id) {
        super(id);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public TemplateType getType() {
        return this.type;
    }

    public void setType(TemplateType type) {
        this.type = type;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Integer getAssetModuleId() {
        return this.assetModuleId;
    }

    public void setAssetModuleId(Integer assetModuleId) {
        this.assetModuleId = assetModuleId;
    }

    public Integer getIsCMDB() {
        return this.isCMDB;
    }

    public void setIsCMDB(Integer isCMDB) {
        this.isCMDB = isCMDB;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)((Object)this));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer id;
        private String name;
        private String template;
        private TemplateType type;
        private Integer projectId;
        private String projectName;
        private String attachmentName;
        private Integer assetModuleId;
        private Integer isCMDB;

        private Builder() {
        }

        public Builder withId(Integer id) {
            this.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withTemplate(String template) {
            this.template = template;
            return this;
        }

        public Builder withType(TemplateType type) {
            this.type = type;
            return this;
        }

        public Builder withProjectId(Integer projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder withProjectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public Builder withAttachmentName(String attachmentName) {
            this.attachmentName = attachmentName;
            return this;
        }

        public Builder withAssetModuleId(Integer assetModuleId) {
            this.assetModuleId = assetModuleId;
            return this;
        }

        public Builder withIsCMDB(Integer isCMDB) {
            this.isCMDB = isCMDB;
            return this;
        }

        public SdTemplateDTO build() {
            return new SdTemplateDTO(this);
        }
    }
}

