/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dto;

import com.google.common.base.MoreObjects;
import com.sapphireims.dto.BaseDTO;
import com.sapphireims.itsm.dto.SdUipDetailsDTO;
import com.sapphireims.itsm.model.SdUipDetails;
import com.sapphireims.itsm.model.SdUipMaster;
import com.sapphireims.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SdUipMasterDTO
extends BaseDTO {
    private static final long serialVersionUID = -6390841827490992060L;
    private Integer uipMasterid;
    private int projectId;
    private String name;
    private String description;
    private int type;
    private int displayOrder;
    private int status;
    private List<SdUipDetailsDTO> uipDetails;

    private SdUipMasterDTO(Builder builder) {
        this.id = builder.id;
        this.updated = builder.updated;
        this.tenanatId = builder.tenanatId;
        this.history = builder.history;
        this.uipMasterid = builder.uipMasterid;
        this.projectId = builder.projectId;
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.displayOrder = builder.displayOrder;
        this.status = builder.status;
        this.uipDetails = builder.uipDetails;
    }

    public SdUipMasterDTO() {
    }

    public SdUipMasterDTO(Integer uipMasterid) {
        super(uipMasterid);
        this.id = uipMasterid;
    }

    public SdUipMasterDTO(Integer uipMasterid, int projectId, String name, String description, int type, int displayOrder, int status, Collection<SdUipDetails> details) {
        this.uipMasterid = uipMasterid;
        this.id = uipMasterid;
        this.projectId = projectId;
        this.name = name;
        this.description = description;
        this.type = type;
        this.displayOrder = displayOrder;
        this.status = status;
        if (CollectionUtil.isNotEmpty(details)) {
            this.uipDetails = new ArrayList<SdUipDetailsDTO>(details.size());
            for (SdUipDetails d : details) {
                this.uipDetails.add(new SdUipDetailsDTO(d.getDetailsId(), uipMasterid, name, d.getParameterId(), d.getParameterValue()));
            }
        }
    }

    public SdUipMasterDTO(SdUipMaster master) {
        this.uipMasterid = master.getId();
        this.name = master.getName();
        this.description = master.getDescription();
        this.type = master.getType();
        this.displayOrder = master.getDisplayOrder();
        this.status = master.getStatus();
    }

    public Integer getUipMasterid() {
        return this.uipMasterid;
    }

    public void setUipMasterid(Integer uipMasterid) {
        this.uipMasterid = uipMasterid;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getDisplayOrder() {
        return this.displayOrder;
    }

    public void setDisplayOrder(int displayOrder) {
        this.displayOrder = displayOrder;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public List<SdUipDetailsDTO> getUipDetails() {
        return this.uipDetails;
    }

    public void setUipDetails(List<SdUipDetailsDTO> uipDetails) {
        this.uipDetails = uipDetails;
    }

    public Integer getId() {
        return this.getUipMasterid();
    }

    public void setId(Integer id) {
        this.setUipMasterid(id);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("super", (Object)super.toString()).add("serialVersionUID", -6390841827490992060L).add("uipMasterid", (Object)this.uipMasterid).add("projectId", this.projectId).add("name", (Object)this.name).add("description", (Object)this.description).add("type", this.type).add("displayOrder", this.displayOrder).add("status", this.status).add("uipDetails", this.uipDetails).toString();
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.uipMasterid, this.projectId, this.name, this.description, this.type, this.displayOrder, this.status, this.uipDetails);
    }

    public boolean equals(Object object) {
        if (object instanceof SdUipMasterDTO) {
            if (!super.equals(object)) {
                return false;
            }
            SdUipMasterDTO that = (SdUipMasterDTO)((Object)object);
            return Objects.equals(this.uipMasterid, that.uipMasterid) && this.projectId == that.projectId && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && this.type == that.type && this.displayOrder == that.displayOrder && this.status == that.status && Objects.equals(this.uipDetails, that.uipDetails);
        }
        return false;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer id;
        private boolean updated;
        private String tenanatId;
        private Object history;
        private Integer uipMasterid;
        private int projectId;
        private String name;
        private String description;
        private int type;
        private int displayOrder;
        private int status;
        private List<SdUipDetailsDTO> uipDetails = Collections.emptyList();

        private Builder() {
        }

        public Builder withId(Integer id) {
            this.id = id;
            return this;
        }

        public Builder withUpdated(boolean updated) {
            this.updated = updated;
            return this;
        }

        public Builder withTenanatId(String tenanatId) {
            this.tenanatId = tenanatId;
            return this;
        }

        public Builder withHistory(Object history) {
            this.history = history;
            return this;
        }

        public Builder withUipMasterid(Integer uipMasterid) {
            this.uipMasterid = uipMasterid;
            return this;
        }

        public Builder withProjectId(int projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withType(int type) {
            this.type = type;
            return this;
        }

        public Builder withDisplayOrder(int displayOrder) {
            this.displayOrder = displayOrder;
            return this;
        }

        public Builder withStatus(int status) {
            this.status = status;
            return this;
        }

        public Builder withUipDetails(List<SdUipDetailsDTO> uipDetails) {
            this.uipDetails = uipDetails;
            return this;
        }

        public SdUipMasterDTO build() {
            return new SdUipMasterDTO(this);
        }
    }
}

