/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphire.itsm.mailrouting.model.SdProjectRoles;
import com.sapphireims.dto.BaseDTO;
import com.sapphireims.itsm.dto.projectcopy.ProjectCopyExportResponce;
import com.sapphireims.itsm.dto.projectcopy.ProjectCopyType;
import com.sapphireims.itsm.dto.projectcopy.ProjectExportRequestDTO;
import com.sapphireims.itsm.model.Departmentmaster;
import com.sapphireims.itsm.model.SdCategorymaster;
import com.sapphireims.itsm.model.SdDependentMaster;
import com.sapphireims.itsm.model.SdService;
import com.sapphireims.itsm.model.SdSubcategorymaster;
import com.sapphireims.itsm.model.SdViewaccessDetails;
import com.sapphireims.itsm.model.SdViewaccessMaster;
import com.sapphireims.itsm.model.Servicedesklocationmaster;
import com.sapphireims.itsm.model.enummodel.ViewAcessType;

public class SdViewaccessDetailsDTO
extends BaseDTO {
    private static final long serialVersionUID = -4004505505736100440L;
    private Integer viewAccessDetailsId;
    private Integer viewAccessId;
    private String viewAccessName;
    private int projectId;
    private int moduleType;
    private int accessType;
    private String accessValue;
    private ViewAcessType type;

    public SdViewaccessDetailsDTO() {
    }

    public SdViewaccessDetailsDTO(SdViewaccessDetails d, SdViewaccessMaster m, SdProjectMaster sdProjectMaster) {
        this.viewAccessDetailsId = d.getViewAccessDetailsId();
        this.viewAccessId = m.getViewAccessId();
        this.viewAccessName = m.getViewAccessName();
        this.projectId = sdProjectMaster.getProjectId();
        this.moduleType = d.getModuleType();
        this.accessType = d.getAccessType();
        this.accessValue = d.getAccessValue();
        this.type = ViewAcessType.getViewAcessTypeEnum(this.accessType);
    }

    @JsonIgnore
    public SdViewaccessDetails getSdViewaccessDetails(SdViewaccessMaster sdViewaccessMaster, ProjectExportRequestDTO req, ProjectCopyExportResponce request, SdProjectMaster sdProjectMaster) {
        String accessValue = this.accessValue;
        if (!accessValue.equalsIgnoreCase("0") && !accessValue.equalsIgnoreCase("All")) {
            switch (this.type) {
                case CATEGORY: {
                    SdCategorymaster m = req.getOldIdCategoryMap().get(Integer.parseInt(accessValue));
                    accessValue = m != null ? Integer.toString(m.getCategoryId()) : null;
                    break;
                }
                case DEPARTMENT: {
                    if (request.getType() != ProjectCopyType.UAT_TO_PRODUCTION) break;
                    Departmentmaster d = req.getTenant().getMapDepartments().get(Integer.parseInt(accessValue));
                    accessValue = d != null ? Integer.toString(d.getDepartmentId()) : null;
                    break;
                }
                case DerivedField1: 
                case DerivedField2: 
                case DerivedField3: {
                    SdDependentMaster dep = req.getOldIdSdDependentMaster().get(Integer.parseInt(accessValue));
                    accessValue = dep != null ? Integer.toString(dep.getDependentFieldId()) : null;
                    break;
                }
                case LOCATION: {
                    if (request.getType() != ProjectCopyType.UAT_TO_PRODUCTION) break;
                    Servicedesklocationmaster l = req.getTenant().getMapLocations().get(Integer.parseInt(accessValue));
                    accessValue = l != null ? Integer.toString(l.getLocationId()) : null;
                    break;
                }
                case ROLE: {
                    SdProjectRoles role = req.getOldIdSdProjectRoles().get(Integer.parseInt(accessValue));
                    accessValue = role != null ? Integer.toString(role.getProjectRoleId()) : null;
                    break;
                }
                case SERVICE: {
                    SdService service = req.getOldIdServiceMap().get(Integer.parseInt(accessValue));
                    accessValue = service != null ? Integer.toString(service.getServiceId()) : null;
                    break;
                }
                case SUBCATEGORY: {
                    SdSubcategorymaster subCategory = req.getOldIdsubCategoryMap().get(Integer.parseInt(accessValue));
                    accessValue = subCategory != null ? Integer.toString(subCategory.getSubCategoryId()) : null;
                    break;
                }
                case USER: {
                    accessValue = null;
                    break;
                }
            }
        }
        if (accessValue != null) {
            return new SdViewaccessDetails(sdViewaccessMaster, sdProjectMaster.getProjectId(), this.moduleType, this.accessType, accessValue);
        }
        return null;
    }

    public Integer getViewAccessDetailsId() {
        return this.viewAccessDetailsId;
    }

    public void setViewAccessDetailsId(Integer viewAccessDetailsId) {
        this.viewAccessDetailsId = viewAccessDetailsId;
    }

    public Integer getViewAccessId() {
        return this.viewAccessId;
    }

    public void setViewAccessId(Integer viewAccessId) {
        this.viewAccessId = viewAccessId;
    }

    public String getViewAccessName() {
        return this.viewAccessName;
    }

    public void setViewAccessName(String viewAccessName) {
        this.viewAccessName = viewAccessName;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public int getModuleType() {
        return this.moduleType;
    }

    public void setModuleType(int moduleType) {
        this.moduleType = moduleType;
    }

    public int getAccessType() {
        return this.accessType;
    }

    public void setAccessType(int accessType) {
        this.accessType = accessType;
    }

    public String getAccessValue() {
        return this.accessValue;
    }

    public void setAccessValue(String accessValue) {
        this.accessValue = accessValue;
    }

    public Integer getId() {
        return this.viewAccessDetailsId;
    }

    public void setId(Integer id) {
        this.setViewAccessDetailsId(id);
    }

    public ViewAcessType getType() {
        return this.type;
    }

    public void setType(ViewAcessType type) {
        this.type = type;
    }
}

