/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphireims.dto.BaseDTO;
import com.sapphireims.itsm.dto.SdViewaccessDetailsDTO;
import com.sapphireims.itsm.dto.projectcopy.ProjectCopyExportResponce;
import com.sapphireims.itsm.dto.projectcopy.ProjectExportRequestDTO;
import com.sapphireims.itsm.model.SdViewaccessDetails;
import com.sapphireims.itsm.model.SdViewaccessMaster;
import com.sapphireims.util.CollectionUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class SdViewaccessMasterDTO
extends BaseDTO {
    private static final long serialVersionUID = 7536309590912836484L;
    private Integer viewAccessId;
    private Integer projectId;
    private String projectName;
    private String viewAccessName;
    private String viewAccessDescription;
    private List<SdViewaccessDetailsDTO> sdViewaccessDetailses;

    public SdViewaccessMasterDTO(SdViewaccessMaster m, SdProjectMaster sdProjectMaster) {
        this.viewAccessId = m.getViewAccessId();
        this.projectId = sdProjectMaster.getProjectId();
        this.projectName = sdProjectMaster.getProjectName();
        this.viewAccessName = m.getViewAccessName();
        this.viewAccessDescription = m.getViewAccessDescription();
        if (CollectionUtil.isNotEmpty(m.getSdViewaccessDetailses())) {
            this.sdViewaccessDetailses = new ArrayList<SdViewaccessDetailsDTO>(m.getSdViewaccessDetailses().size());
            for (SdViewaccessDetails d : m.getSdViewaccessDetailses()) {
                this.sdViewaccessDetailses.add(new SdViewaccessDetailsDTO(d, m, sdProjectMaster));
            }
        }
    }

    public SdViewaccessMasterDTO() {
    }

    public SdViewaccessMasterDTO(Integer viewAccessId, Integer projectId, String projectName, String viewAccessName, String viewAccessDescription, List<SdViewaccessDetailsDTO> sdViewaccessDetailses) {
        this.viewAccessId = viewAccessId;
        this.projectId = projectId;
        this.projectName = projectName;
        this.viewAccessName = viewAccessName;
        this.viewAccessDescription = viewAccessDescription;
        this.sdViewaccessDetailses = sdViewaccessDetailses;
    }

    @JsonIgnore
    public SdViewaccessMaster getSdViewaccessMaster(SdProjectMaster sdProjectMaster, ProjectExportRequestDTO projectExportRequestDTO, ProjectCopyExportResponce request) {
        SdViewaccessMaster m = new SdViewaccessMaster(sdProjectMaster, this.viewAccessName, this.viewAccessDescription);
        if (CollectionUtil.isNotEmpty(this.sdViewaccessDetailses)) {
            ArrayList<SdViewaccessDetails> sdViewaccessDetailses = new ArrayList<SdViewaccessDetails>(this.sdViewaccessDetailses.size());
            for (SdViewaccessDetailsDTO d : this.sdViewaccessDetailses) {
                SdViewaccessDetails details = d.getSdViewaccessDetails(m, projectExportRequestDTO, request, sdProjectMaster);
                if (details == null) continue;
                sdViewaccessDetailses.add(details);
            }
            m.setSdViewaccessDetailses(new HashSet<SdViewaccessDetails>(sdViewaccessDetailses));
        }
        return m;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Integer getViewAccessId() {
        return this.viewAccessId;
    }

    public void setViewAccessId(Integer viewAccessId) {
        this.viewAccessId = viewAccessId;
    }

    public String getViewAccessName() {
        return this.viewAccessName;
    }

    public void setViewAccessName(String viewAccessName) {
        this.viewAccessName = viewAccessName;
    }

    public String getViewAccessDescription() {
        return this.viewAccessDescription;
    }

    public void setViewAccessDescription(String viewAccessDescription) {
        this.viewAccessDescription = viewAccessDescription;
    }

    public List<SdViewaccessDetailsDTO> getSdViewaccessDetailses() {
        return this.sdViewaccessDetailses;
    }

    public void setSdViewaccessDetailses(List<SdViewaccessDetailsDTO> sdViewaccessDetailses) {
        this.sdViewaccessDetailses = sdViewaccessDetailses;
    }

    public Integer getId() {
        return this.viewAccessId;
    }

    public void setId(Integer id) {
        this.setViewAccessId(id);
    }
}

