/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.sapphireims.dto.BaseDTO;
import com.sapphireims.itsm.dto.SdWorkgroupDetailsDTO;
import com.sapphireims.itsm.model.SdWorkgroupdetails;
import com.sapphireims.itsm.model.SdWorkgroupmaster;
import com.sapphireims.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class SdWorkgroupMasterDTO
extends BaseDTO {
    private static final long serialVersionUID = 9007453301207610576L;
    private Integer workGroupId;
    private String workGroupName;
    private String workGroupDescription;
    private int projectId;
    private int workGroupStatus;
    private List<SdWorkgroupDetailsDTO> workgroupDetails;
    boolean removeUser;

    public SdWorkgroupMasterDTO() {
    }

    public SdWorkgroupMasterDTO(SdWorkgroupmaster m) {
        this(m.getWorkGroupId(), m.getWorkGroupName(), m.getWorkGroupDescription(), m.getProjectId(), m.getWorkGroupStatus(), null);
        if (CollectionUtil.isNotEmpty(m.getSdWorkgroupdetailses())) {
            this.workgroupDetails = new LinkedList<SdWorkgroupDetailsDTO>();
            LinkedList<SdWorkgroupDetailsDTO> list = new LinkedList<SdWorkgroupDetailsDTO>();
            for (SdWorkgroupdetails pd : m.getSdWorkgroupdetailses()) {
                list.add(new SdWorkgroupDetailsDTO(pd, m));
            }
            if (CollectionUtil.isNotEmpty(list)) {
                Collections.sort(list, (o1, o2) -> o1.getWorkGroupId().compareTo(o2.getWorkGroupId()));
            }
            for (SdWorkgroupdetails d : m.getSdWorkgroupdetailses()) {
                this.workgroupDetails = list;
            }
        }
    }

    public SdWorkgroupMasterDTO(Integer workGroupId, String workGroupName, String workGroupDescription, int projectId, int workGroupStatus, List<SdWorkgroupDetailsDTO> workgroupDetails) {
        this.workGroupId = workGroupId;
        this.workGroupName = workGroupName;
        this.workGroupDescription = workGroupDescription;
        this.projectId = projectId;
        this.workGroupStatus = workGroupStatus;
        this.workgroupDetails = workgroupDetails;
    }

    @JsonIgnore
    public SdWorkgroupmaster getSdWorkgroupmaster(Integer projectId) {
        return new SdWorkgroupmaster(this.workGroupName, this.workGroupDescription, projectId, this.workGroupStatus);
    }

    @JsonIgnore
    public List<SdWorkgroupdetails> getSdWorkGroupDetails(SdWorkgroupmaster master) {
        ArrayList<SdWorkgroupdetails> lst = null;
        if (CollectionUtil.isNotEmpty(this.workgroupDetails)) {
            lst = new ArrayList<SdWorkgroupdetails>(this.workgroupDetails.size());
            for (SdWorkgroupDetailsDTO sd : this.workgroupDetails) {
                lst.add(sd.getWorkgroupdetails(master));
            }
        }
        return lst;
    }

    public Integer getWorkGroupId() {
        return this.workGroupId;
    }

    public void setWorkGroupId(Integer workGroupId) {
        this.workGroupId = workGroupId;
    }

    public String getWorkGroupName() {
        return this.workGroupName;
    }

    public void setWorkGroupName(String workGroupName) {
        this.workGroupName = workGroupName;
    }

    public String getWorkGroupDescription() {
        return this.workGroupDescription;
    }

    public void setWorkGroupDescription(String workGroupDescription) {
        this.workGroupDescription = workGroupDescription;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public int getWorkGroupStatus() {
        return this.workGroupStatus;
    }

    public void setWorkGroupStatus(int workGroupStatus) {
        this.workGroupStatus = workGroupStatus;
    }

    public List<SdWorkgroupDetailsDTO> getWorkgroupDetails() {
        return this.workgroupDetails;
    }

    public void setWorkgroupDetails(List<SdWorkgroupDetailsDTO> workgroupDetails) {
        this.workgroupDetails = workgroupDetails;
    }

    public boolean isRemoveUser() {
        return this.removeUser;
    }

    public void setRemoveUser(boolean removeUser) {
        this.removeUser = removeUser;
    }

    public Integer getId() {
        return this.getWorkGroupId();
    }

    public void setId(Integer id) {
        this.setWorkGroupId(id);
    }
}

