/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.sapphireims.dto.BaseDTO;
import com.sapphireims.itsm.dto.EscalationDetailsDTO;
import com.sapphireims.itsm.dto.projectcopy.ProjectCopyExportResponce;
import com.sapphireims.itsm.dto.projectcopy.ProjectCopyType;
import com.sapphireims.itsm.dto.projectcopy.ProjectExportRequestDTO;
import com.sapphireims.itsm.model.ServicedeskslaRuledetails;
import com.sapphireims.itsm.model.enummodel.ServiceDeskSlaRuleMasterEnum;
import com.sapphireims.itsm.service.ISLAService;

public class ServicedeskslaRuledetailsDTO
extends BaseDTO {
    private Integer sno;
    private Integer slaId;
    private Integer ruleId;
    private Integer criteriaId;
    private String criteriaValue;
    private String fieldValue;

    public ServicedeskslaRuledetailsDTO() {
    }

    public ServicedeskslaRuledetailsDTO(Integer sno, Integer slaId, Integer ruleId, Integer criteriaId, String criteriaValue, String fieldValue) {
        this.sno = sno;
        this.slaId = slaId;
        this.ruleId = ruleId;
        this.criteriaId = criteriaId;
        this.criteriaValue = criteriaValue;
        this.fieldValue = fieldValue;
    }

    public ServicedeskslaRuledetailsDTO(ServicedeskslaRuledetails sdrd) {
        this.sno = sdrd.getSno();
        this.slaId = sdrd.getSlaId();
        this.ruleId = sdrd.getRuleId();
        this.criteriaId = sdrd.getCriteriaId();
        this.criteriaValue = sdrd.getCriteriaValue();
        this.fieldValue = sdrd.getFieldValue();
    }

    @JsonIgnore
    public ServicedeskslaRuledetails getModelObject(Integer slaId, ProjectExportRequestDTO req, ProjectCopyExportResponce request, EscalationDetailsDTO sla, ISLAService slaService) {
        ServiceDeskSlaRuleMasterEnum sdsrme = ServiceDeskSlaRuleMasterEnum.getServiceDeskSlaRuleMasterEnum(this.criteriaId);
        String criteriaValue = "";
        String fieldValue = null;
        String rule = sla.getRule().trim();
        switch (sdsrme) {
            case DEFAULTVALUE: {
                criteriaValue = this.criteriaValue;
                break;
            }
            case SUBCATEGORY: {
                criteriaValue = String.valueOf(req.getOldIdsubCategoryMap().containsKey(Integer.parseInt(this.criteriaValue)) ? req.getOldIdsubCategoryMap().get(Integer.parseInt(this.criteriaValue)).getSubCategoryId() : null);
                break;
            }
            case URGENCY: 
            case IMPACT: 
            case PRIORITY: {
                criteriaValue = String.valueOf(req.getOldsdUipMasters().containsKey(Integer.parseInt(this.criteriaValue)) ? req.getOldsdUipMasters().get(Integer.parseInt(this.criteriaValue)).getId() : null);
                break;
            }
            case LOCATIONID: {
                if (request.getType() == ProjectCopyType.UAT_TO_PRODUCTION) {
                    criteriaValue = String.valueOf(req.getTenant().getMapLocations().containsKey(Integer.parseInt(this.criteriaValue)) ? Integer.toString(req.getTenant().getMapLocations().get(Integer.parseInt(this.criteriaValue)).getLocationId()) : null);
                    break;
                }
                criteriaValue = null;
                break;
            }
            case DEPARTMENTID: {
                if (request.getType() == ProjectCopyType.UAT_TO_PRODUCTION) {
                    criteriaValue = String.valueOf(req.getTenant().getMapDepartments().containsKey(Integer.parseInt(this.criteriaValue)) ? Integer.toString(req.getTenant().getMapDepartments().get(Integer.parseInt(this.criteriaValue)).getDepartmentId()) : null);
                    break;
                }
                criteriaValue = null;
                break;
            }
            case USERS: {
                criteriaValue = "1";
                break;
            }
            case ROLES: {
                criteriaValue = String.valueOf(req.getOldIdSdProjectRoles().containsKey(Integer.parseInt(this.criteriaValue)) ? req.getOldIdSdProjectRoles().get(Integer.parseInt(this.criteriaValue)).getProjectRoleId() : null);
                break;
            }
            case CONTEXTSENSITIVEFIELDS: {
                if (req.getOldIdAdditionalparamsMap().containsKey(Integer.parseInt(this.criteriaValue))) {
                    criteriaValue = String.valueOf(req.getOldIdAdditionalparamsMap().get(Integer.parseInt(this.criteriaValue)).getFieldid());
                    fieldValue = this.fieldValue;
                    break;
                }
                criteriaValue = null;
                fieldValue = null;
                break;
            }
            case CATEGORY: {
                criteriaValue = String.valueOf(req.getOldIdCategoryMap().containsKey(Integer.parseInt(this.criteriaValue)) ? req.getOldIdCategoryMap().get(Integer.parseInt(this.criteriaValue)).getCategoryId() : null);
                break;
            }
            case DF1: 
            case DF2: 
            case DF3: {
                criteriaValue = String.valueOf(req.getOldIdSdDependentMaster().containsKey(Integer.parseInt(this.criteriaValue)) ? req.getOldIdSdDependentMaster().get(Integer.parseInt(this.criteriaValue)).getDependentFieldId() : null);
                break;
            }
            case SERVICE: {
                criteriaValue = String.valueOf(req.getOldIdServiceMap().containsKey(Integer.parseInt(this.criteriaValue)) ? req.getOldIdServiceMap().get(Integer.parseInt(this.criteriaValue)).getServiceId() : null);
                break;
            }
            case ASSETLIFECYCLECONTEXTSENSITIVEFIELDS: {
                break;
            }
            case ASSETCONTEXTSENSITIVEFIELDS: {
                break;
            }
            case ASSETLOCATIONID: {
                break;
            }
            case ASSETDEPARTMENTID: {
                break;
            }
            case ASSETPROJECT: {
                break;
            }
            case ASSETSYSTEMNAME: {
                break;
            }
            case ASSETSITENAME: {
                break;
            }
        }
        if (criteriaValue != null && sdsrme.getValue() != 0 && sdsrme.getValue() != 10) {
            rule = slaService.replaceRule(sdsrme.getName().trim(), rule, this.criteriaValue, criteriaValue, "!=");
            rule = slaService.replaceRule(sdsrme.getName().trim(), rule, this.criteriaValue, criteriaValue, "=");
            sla.setRule(rule);
        }
        return new ServicedeskslaRuledetails(slaId, this.ruleId, this.criteriaId, criteriaValue, fieldValue);
    }

    public Integer getSno() {
        return this.sno;
    }

    public void setSno(Integer sno) {
        this.sno = sno;
    }

    public Integer getSlaId() {
        return this.slaId;
    }

    public void setSlaId(Integer slaId) {
        this.slaId = slaId;
    }

    public Integer getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(Integer ruleId) {
        this.ruleId = ruleId;
    }

    public Integer getCriteriaId() {
        return this.criteriaId;
    }

    public void setCriteriaId(Integer criteriaId) {
        this.criteriaId = criteriaId;
    }

    public String getCriteriaValue() {
        return this.criteriaValue;
    }

    public void setCriteriaValue(String criteriaValue) {
        this.criteriaValue = criteriaValue;
    }

    public String getFieldValue() {
        return this.fieldValue;
    }

    public void setFieldValue(String fieldValue) {
        this.fieldValue = fieldValue;
    }

    public Integer getId() {
        return this.getSno();
    }

    public void setId(Integer id) {
        this.setSno(id);
    }
}

