/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dto.cache;

import com.sapphireims.dto.BaseMinDTO;
import com.sapphireims.exception.DomainException;
import com.sapphireims.itsm.dto.SdAdditionalparamsDTO;
import com.sapphireims.itsm.dto.SdCategoryMasterDTO;
import com.sapphireims.itsm.dto.SdDependentMasterDTO;
import com.sapphireims.itsm.dto.SdFixedfiledsPermissionsDTO;
import com.sapphireims.itsm.dto.SdProjectRolesDTO;
import com.sapphireims.itsm.dto.SdServiceDTO;
import com.sapphireims.itsm.dto.SdSourcefilterDTO;
import com.sapphireims.itsm.dto.SdStatecategoryMasterDTO;
import com.sapphireims.itsm.dto.SdStatesMasterDTO;
import com.sapphireims.itsm.dto.SdTemplateDTO;
import com.sapphireims.itsm.dto.SdUipMasterDTO;
import com.sapphireims.itsm.dto.SdWorkgroupMasterDTO;
import com.sapphireims.itsm.dto.cache.RpaProcessMinDTO;
import com.sapphireims.itsm.dto.cache.SdTemplateMinDTO;
import com.sapphireims.itsm.dto.projectcopy.ProjectDTO;
import com.sapphireims.itsm.mindto.AdditionalParamsMinDTO;
import com.sapphireims.itsm.mindto.CategoryMinDTO;
import com.sapphireims.itsm.mindto.DerivedFieldMinDTO;
import com.sapphireims.itsm.mindto.FixedFiledsMinDTO;
import com.sapphireims.itsm.mindto.ProjectRolesMinDTO;
import com.sapphireims.itsm.mindto.ServiceMinDTO;
import com.sapphireims.itsm.mindto.SourceMinDTO;
import com.sapphireims.itsm.mindto.StateCategoryMinDTO;
import com.sapphireims.itsm.mindto.StatesMinDTO;
import com.sapphireims.itsm.mindto.UipMinDTO;
import com.sapphireims.itsm.mindto.WorkGroupMinDTO;
import com.sapphireims.model.rpa.RpaProcess;
import com.sapphireims.util.CollectionUtil;
import com.sapphireims.util.Validate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ClientProjectCache
extends BaseMinDTO {
    private static final long serialVersionUID = -3718859917305555580L;
    private List<ProjectRolesMinDTO> roles;
    private List<WorkGroupMinDTO> workGroups;
    private List<CategoryMinDTO> categories;
    private List<DerivedFieldMinDTO> derivedFields;
    private List<ServiceMinDTO> services;
    private List<StatesMinDTO> states;
    private List<StateCategoryMinDTO> stateCategory;
    private List<FixedFiledsMinDTO> fixedFields;
    private List<AdditionalParamsMinDTO> additionalparams;
    private List<SdTemplateMinDTO> templates;
    private List<RpaProcessMinDTO> rpaProcess;
    private List<SourceMinDTO> sources;
    private List<UipMinDTO> uipMaster;

    private ClientProjectCache(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.updated = builder.updated;
        this.history = builder.history;
        this.roles = builder.roles;
        this.workGroups = builder.workGroups;
        this.categories = builder.categories;
        this.derivedFields = builder.derivedFields;
        this.services = builder.services;
        this.states = builder.states;
        this.stateCategory = builder.stateCategory;
        this.additionalparams = builder.additionalparams;
        this.templates = builder.templates;
        this.rpaProcess = builder.rpaProcess;
        this.fixedFields = builder.fixedFields;
        this.uipMaster = builder.uipMaster;
    }

    public ClientProjectCache() {
    }

    public ClientProjectCache(ProjectDTO p, List<RpaProcess> process) throws DomainException {
        Validate.notNull((Object)((Object)p), (String)"Project can't be empty ", (Object[])new Object[0]);
        this.id = p.getProjectId();
        this.name = p.getProjectName();
        if (CollectionUtil.isNotEmpty(p.getRoles())) {
            this.roles = new ArrayList<ProjectRolesMinDTO>(p.getRoles().size());
            for (SdProjectRolesDTO sdProjectRolesDTO : p.getRoles()) {
                this.roles.add(new ProjectRolesMinDTO(sdProjectRolesDTO));
            }
        }
        if (CollectionUtil.isNotEmpty(p.getWorkgroupMasters())) {
            this.workGroups = new ArrayList<WorkGroupMinDTO>(p.getWorkgroupMasters().size());
            for (SdWorkgroupMasterDTO sdWorkgroupMasterDTO : p.getWorkgroupMasters()) {
                this.workGroups.add(new WorkGroupMinDTO(sdWorkgroupMasterDTO));
            }
        }
        if (CollectionUtil.isNotEmpty(p.getSdUipMasteres())) {
            this.uipMaster = new ArrayList<UipMinDTO>(p.getSdUipMasteres().size());
            for (SdUipMasterDTO sdUipMasterDTO : p.getSdUipMasteres()) {
                if (sdUipMasterDTO.getStatus() != 0) continue;
                this.uipMaster.add(new UipMinDTO(sdUipMasterDTO));
            }
        }
        if (CollectionUtil.isNotEmpty(p.getSdCategoryMasters())) {
            this.categories = new ArrayList<CategoryMinDTO>(p.getSdCategoryMasters().size());
            for (SdCategoryMasterDTO sdCategoryMasterDTO : p.getSdCategoryMasters()) {
                if (sdCategoryMasterDTO.getStatus() != 0) continue;
                this.categories.add(new CategoryMinDTO(sdCategoryMasterDTO));
            }
        }
        if (CollectionUtil.isNotEmpty(p.getDepedentMasters())) {
            this.derivedFields = new ArrayList<DerivedFieldMinDTO>(p.getDepedentMasters().size());
            for (SdDependentMasterDTO sdDependentMasterDTO : p.getDepedentMasters()) {
                if (sdDependentMasterDTO.getStatus() != 0) continue;
                this.derivedFields.add(new DerivedFieldMinDTO(sdDependentMasterDTO));
            }
        }
        if (CollectionUtil.isNotEmpty(p.getServices())) {
            this.services = new ArrayList<ServiceMinDTO>(p.getServices().size());
            for (SdServiceDTO sdServiceDTO : p.getServices()) {
                if (sdServiceDTO.getStatus() != 0) continue;
                this.services.add(new ServiceMinDTO(sdServiceDTO));
            }
        }
        if (CollectionUtil.isNotEmpty(p.getSdStatesMasters())) {
            this.states = new ArrayList<StatesMinDTO>(p.getSdStatesMasters().size());
            for (SdStatesMasterDTO sdStatesMasterDTO : p.getSdStatesMasters()) {
                if (sdStatesMasterDTO.getStatus() != 0) continue;
                this.states.add(new StatesMinDTO(sdStatesMasterDTO));
            }
        }
        if (CollectionUtil.isNotEmpty(p.getStatecategoryMasters())) {
            this.stateCategory = new ArrayList<StateCategoryMinDTO>(p.getStatecategoryMasters().size());
            for (SdStatecategoryMasterDTO sdStatecategoryMasterDTO : p.getStatecategoryMasters()) {
                this.stateCategory.add(new StateCategoryMinDTO(sdStatecategoryMasterDTO));
            }
        }
        if (CollectionUtil.isNotEmpty(p.getFixedfiledsPermissions())) {
            this.fixedFields = new ArrayList<FixedFiledsMinDTO>(p.getFixedfiledsPermissions().size());
            for (SdFixedfiledsPermissionsDTO sdFixedfiledsPermissionsDTO : p.getFixedfiledsPermissions()) {
                this.fixedFields.add(new FixedFiledsMinDTO(sdFixedfiledsPermissionsDTO));
            }
        }
        if (CollectionUtil.isNotEmpty(p.getTemplates())) {
            this.templates = new ArrayList<SdTemplateMinDTO>(p.getTemplates().size());
            for (SdTemplateDTO sdTemplateDTO : p.getTemplates()) {
                this.templates.add(new SdTemplateMinDTO(sdTemplateDTO));
            }
        }
        if (CollectionUtil.isNotEmpty(process)) {
            this.rpaProcess = new ArrayList<RpaProcessMinDTO>(process.size());
            for (RpaProcess rpaProcess : process) {
                this.rpaProcess.add(new RpaProcessMinDTO(rpaProcess));
            }
        }
        if (CollectionUtil.isNotEmpty(p.getAdditionalparams())) {
            this.additionalparams = new ArrayList<AdditionalParamsMinDTO>(p.getAdditionalparams().size());
            for (SdAdditionalparamsDTO sdAdditionalparamsDTO : p.getAdditionalparams()) {
                this.additionalparams.add(new AdditionalParamsMinDTO(sdAdditionalparamsDTO));
            }
        }
        if (CollectionUtil.isNotEmpty(p.getSdSourcefilters())) {
            this.sources = new ArrayList<SourceMinDTO>(p.getSdSourcefilters().size());
            for (SdSourcefilterDTO sdSourcefilterDTO : p.getSdSourcefilters()) {
                this.sources.add(new SourceMinDTO(sdSourcefilterDTO));
            }
        }
    }

    public List<SourceMinDTO> getSources() {
        return this.sources;
    }

    public void setSources(List<SourceMinDTO> sources) {
        this.sources = sources;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<ProjectRolesMinDTO> getRoles() {
        return this.roles;
    }

    public void setRoles(List<ProjectRolesMinDTO> roles) {
        this.roles = roles;
    }

    public List<WorkGroupMinDTO> getWorkGroups() {
        return this.workGroups;
    }

    public void setWorkGroups(List<WorkGroupMinDTO> workGroups) {
        this.workGroups = workGroups;
    }

    public List<CategoryMinDTO> getCategories() {
        return this.categories;
    }

    public void setCategories(List<CategoryMinDTO> categories) {
        this.categories = categories;
    }

    public List<DerivedFieldMinDTO> getDerivedFields() {
        return this.derivedFields;
    }

    public void setDerivedFields(List<DerivedFieldMinDTO> derivedFields) {
        this.derivedFields = derivedFields;
    }

    public List<ServiceMinDTO> getServices() {
        return this.services;
    }

    public void setServices(List<ServiceMinDTO> services) {
        this.services = services;
    }

    public List<StatesMinDTO> getStates() {
        return this.states;
    }

    public void setStates(List<StatesMinDTO> states) {
        this.states = states;
    }

    public List<StateCategoryMinDTO> getStateCategory() {
        return this.stateCategory;
    }

    public void setStateCategory(List<StateCategoryMinDTO> stateCategory) {
        this.stateCategory = stateCategory;
    }

    public List<AdditionalParamsMinDTO> getAdditionalparams() {
        return this.additionalparams;
    }

    public void setAdditionalparams(List<AdditionalParamsMinDTO> additionalparams) {
        this.additionalparams = additionalparams;
    }

    public List<SdTemplateMinDTO> getTemplates() {
        return this.templates;
    }

    public void setTemplates(List<SdTemplateMinDTO> templates) {
        this.templates = templates;
    }

    public List<RpaProcessMinDTO> getRpaProcess() {
        return this.rpaProcess;
    }

    public void setRpaProcess(List<RpaProcessMinDTO> rpaProcess) {
        this.rpaProcess = rpaProcess;
    }

    public static long getSerialversionuid() {
        return -3718859917305555580L;
    }

    public List<FixedFiledsMinDTO> getFixedFields() {
        return this.fixedFields;
    }

    public void setFixedFields(List<FixedFiledsMinDTO> fixedFields) {
        this.fixedFields = fixedFields;
    }

    public List<UipMinDTO> getUipMaster() {
        return this.uipMaster;
    }

    public void setUipMaster(List<UipMinDTO> uipMaster) {
        this.uipMaster = uipMaster;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer id;
        private String name;
        private boolean updated;
        private Object history;
        private List<ProjectRolesMinDTO> roles = Collections.emptyList();
        private List<WorkGroupMinDTO> workGroups = Collections.emptyList();
        private List<CategoryMinDTO> categories = Collections.emptyList();
        private List<DerivedFieldMinDTO> derivedFields = Collections.emptyList();
        private List<ServiceMinDTO> services = Collections.emptyList();
        private List<StatesMinDTO> states = Collections.emptyList();
        private List<StateCategoryMinDTO> stateCategory = Collections.emptyList();
        private List<AdditionalParamsMinDTO> additionalparams = Collections.emptyList();
        private List<SdTemplateMinDTO> templates = Collections.emptyList();
        private List<RpaProcessMinDTO> rpaProcess = Collections.emptyList();
        private List<FixedFiledsMinDTO> fixedFields = Collections.emptyList();
        private List<UipMinDTO> uipMaster = Collections.emptyList();

        private Builder() {
        }

        public Builder withId(Integer id) {
            this.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withUpdated(boolean updated) {
            this.updated = updated;
            return this;
        }

        public Builder withHistory(Object history) {
            this.history = history;
            return this;
        }

        public Builder withRoles(List<ProjectRolesMinDTO> roles) {
            this.roles = roles;
            return this;
        }

        public Builder withWorkGroups(List<WorkGroupMinDTO> workGroups) {
            this.workGroups = workGroups;
            return this;
        }

        public Builder withCategories(List<CategoryMinDTO> categories) {
            this.categories = categories;
            return this;
        }

        public Builder withDerivedFields(List<DerivedFieldMinDTO> derivedFields) {
            this.derivedFields = derivedFields;
            return this;
        }

        public Builder withServices(List<ServiceMinDTO> services) {
            this.services = services;
            return this;
        }

        public Builder withStates(List<StatesMinDTO> states) {
            this.states = states;
            return this;
        }

        public Builder withStateCategory(List<StateCategoryMinDTO> stateCategory) {
            this.stateCategory = stateCategory;
            return this;
        }

        public Builder withAdditionalparams(List<AdditionalParamsMinDTO> additionalparams) {
            this.additionalparams = additionalparams;
            return this;
        }

        public Builder withUipMaster(List<UipMinDTO> uipMaster) {
            this.uipMaster = uipMaster;
            return this;
        }

        public Builder withTemplates(List<SdTemplateMinDTO> templates) {
            this.templates = templates;
            return this;
        }

        public Builder withRpaProcess(List<RpaProcessMinDTO> rpaProcess) {
            this.rpaProcess = rpaProcess;
            return this;
        }

        public Builder withFixedFields(List<FixedFiledsMinDTO> fixedFields) {
            this.fixedFields = fixedFields;
            return this;
        }

        public ClientProjectCache build() {
            return new ClientProjectCache(this);
        }
    }
}

