/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dto.cache;

import com.sapphireims.dto.BaseMinDTO;
import com.sapphireims.dto.rpa.RpaProcessDTO;
import com.sapphireims.model.rpa.ProcessType;
import com.sapphireims.model.rpa.RpaProcess;

public class RpaProcessMinDTO
extends BaseMinDTO {
    private static final long serialVersionUID = -8812186221740271281L;
    private ProcessType type;
    private String processId;

    private RpaProcessMinDTO(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.updated = builder.updated;
        this.history = builder.history;
        this.type = builder.type;
        this.processId = builder.processId;
    }

    public RpaProcessMinDTO() {
    }

    public RpaProcessMinDTO(Integer id, String name, ProcessType type) {
        super(id, name);
        this.type = type;
    }

    public RpaProcessMinDTO(RpaProcessDTO r) {
        super(r.getId(), r.getName());
        this.type = r.getType();
        this.processId = r.getProcessId();
    }

    public RpaProcessMinDTO(RpaProcess r) {
        super(r.getId(), r.getName());
        this.type = r.getType();
        this.processId = r.getProcessId();
    }

    public ProcessType getType() {
        return this.type;
    }

    public void setType(ProcessType type) {
        this.type = type;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer id;
        private String name;
        private boolean updated;
        private Object history;
        private ProcessType type;
        private String processId;

        private Builder() {
        }

        public Builder withId(Integer id) {
            this.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withUpdated(boolean updated) {
            this.updated = updated;
            return this;
        }

        public Builder withHistory(Object history) {
            this.history = history;
            return this;
        }

        public Builder withType(ProcessType type) {
            this.type = type;
            return this;
        }

        public Builder withProcessId(String processId) {
            this.processId = processId;
            return this;
        }

        public RpaProcessMinDTO build() {
            return new RpaProcessMinDTO(this);
        }
    }
}

