/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dto.cache;

import com.google.common.base.MoreObjects;
import com.sapphireims.dto.BaseMinDTO;
import com.sapphireims.itsm.dto.SdTemplateDTO;
import com.sapphireims.itsm.model.enummodel.TemplateType;
import java.util.Objects;

public class SdTemplateMinDTO
extends BaseMinDTO {
    private static final long serialVersionUID = 6552274819749173593L;
    private TemplateType type;

    private SdTemplateMinDTO(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.updated = builder.updated;
        this.history = builder.history;
        this.type = builder.type;
    }

    public SdTemplateMinDTO() {
    }

    public SdTemplateMinDTO(Integer id, String name, TemplateType type) {
        super(id, name);
        this.type = type;
    }

    public SdTemplateMinDTO(SdTemplateDTO t) {
        super(t.getId(), t.getName());
        this.type = t.getType();
    }

    public TemplateType getType() {
        return this.type;
    }

    public void setType(TemplateType type) {
        this.type = type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.type});
    }

    public boolean equals(Object object) {
        if (object instanceof SdTemplateMinDTO) {
            if (!super.equals(object)) {
                return false;
            }
            SdTemplateMinDTO that = (SdTemplateMinDTO)((Object)object);
            return Objects.equals((Object)this.type, (Object)that.type);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("super", (Object)super.toString()).add("serialVersionUID", 6552274819749173593L).add("type", (Object)this.type).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer id;
        private String name;
        private boolean updated;
        private Object history;
        private TemplateType type;

        private Builder() {
        }

        public Builder withId(Integer id) {
            this.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withUpdated(boolean updated) {
            this.updated = updated;
            return this;
        }

        public Builder withHistory(Object history) {
            this.history = history;
            return this;
        }

        public Builder withType(TemplateType type) {
            this.type = type;
            return this;
        }

        public SdTemplateMinDTO build() {
            return new SdTemplateMinDTO(this);
        }
    }
}

