/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dto.integration;

import com.sapphireims.dto.BaseDTO;
import com.sapphireims.itsm.dto.SdTemplateDTO;
import com.sapphireims.itsm.model.SdIntegrationConfig;
import com.sapphireims.itsm.model.enummodel.HttpMethod;
import com.sapphireims.itsm.model.enummodel.IntegrationType;
import com.sapphireims.itsm.model.enummodel.OutBoundIntigrationBodyType;

public class SdIntegrationConfigDTO
extends BaseDTO {
    private static final long serialVersionUID = 5586236338199937162L;
    private Integer id;
    private String body;
    private SdTemplateDTO template;
    private String integrationName;
    private String integrationDescription;
    private String url;
    private String header;
    private String authHandler;
    private String responseHandler;
    private String requestHandler;
    private String errorHandler;
    private String authKey;
    private String authValue;
    private int projectId;
    private HttpMethod httpMethod;
    private OutBoundIntigrationBodyType bodyType;
    private IntegrationType integrationType;
    private String authType;
    private int assetModuleId;
    private int isCMDB;

    private SdIntegrationConfigDTO(Builder builder) {
        this.id = builder.id;
        this.updated = builder.updated;
        this.tenanatId = builder.tenanatId;
        this.history = builder.history;
        this.id = builder.id;
        this.body = builder.body;
        this.template = builder.template;
        this.integrationName = builder.integrationName;
        this.integrationDescription = builder.integrationDescription;
        this.url = builder.url;
        this.header = builder.header;
        this.authHandler = builder.authHandler;
        this.responseHandler = builder.responseHandler;
        this.requestHandler = builder.requestHandler;
        this.errorHandler = builder.errorHandler;
        this.authKey = builder.authKey;
        this.authValue = builder.authValue;
        this.projectId = builder.projectId;
        this.httpMethod = builder.httpMethod;
        this.bodyType = builder.bodyType;
        this.integrationType = builder.integrationType;
        this.authType = builder.authType;
    }

    public SdIntegrationConfigDTO(Integer id) {
        super(id);
    }

    public SdIntegrationConfigDTO() {
    }

    public SdIntegrationConfigDTO(SdIntegrationConfig config) {
        this.id = config.getId();
        this.template = new SdTemplateDTO(config.getSdTemplate());
        this.integrationName = config.getIntegrationName();
        this.integrationDescription = config.getIntegrationDescription();
        this.url = config.getUrl();
        this.header = config.getHeader();
        this.authHandler = config.getAuthHandler();
        this.responseHandler = config.getResponseHandler();
        this.requestHandler = config.getRequestHandler();
        this.errorHandler = config.getErrorHandler();
        this.authKey = config.getAuthKey();
        this.authValue = config.getAuthValue();
        this.projectId = config.getProjectId();
        this.httpMethod = config.getHttpMethod();
        this.bodyType = config.getBodyType();
        this.integrationType = config.getIntegrationType();
        this.authType = config.getAuthType();
    }

    public SdIntegrationConfigDTO(Integer id, SdTemplateDTO template, String integrationName, String integrationDescription, String url, String header, String authHandler, String responseHandler, String requestHandler, String authKey, String authValue, int projectId, String authType, HttpMethod httpMethod, OutBoundIntigrationBodyType bodyType, IntegrationType integrationType) {
        this.id = id;
        this.template = template;
        this.integrationName = integrationName;
        this.integrationDescription = integrationDescription;
        this.url = url;
        this.header = header;
        this.authHandler = authHandler;
        this.responseHandler = responseHandler;
        this.requestHandler = requestHandler;
        this.authKey = authKey;
        this.authValue = authValue;
        this.projectId = projectId;
        this.httpMethod = httpMethod;
        this.bodyType = bodyType;
        this.integrationType = integrationType;
        this.authType = authType;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public SdTemplateDTO getTemplate() {
        return this.template;
    }

    public void setTemplate(SdTemplateDTO template) {
        this.template = template;
    }

    public String getIntegrationName() {
        return this.integrationName;
    }

    public void setIntegrationName(String integrationName) {
        this.integrationName = integrationName;
    }

    public String getIntegrationDescription() {
        return this.integrationDescription;
    }

    public void setIntegrationDescription(String integrationDescription) {
        this.integrationDescription = integrationDescription;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getAuthHandler() {
        return this.authHandler;
    }

    public void setAuthHandler(String authHandler) {
        this.authHandler = authHandler;
    }

    public String getResponseHandler() {
        return this.responseHandler;
    }

    public void setResponseHandler(String responseHandler) {
        this.responseHandler = responseHandler;
    }

    public String getRequestHandler() {
        return this.requestHandler;
    }

    public void setRequestHandler(String requestHandler) {
        this.requestHandler = requestHandler;
    }

    public String getAuthKey() {
        return this.authKey;
    }

    public void setAuthKey(String authKey) {
        this.authKey = authKey;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getAuthValue() {
        return this.authValue;
    }

    public void setAuthValue(String authValue) {
        this.authValue = authValue;
    }

    public OutBoundIntigrationBodyType getBodyType() {
        return this.bodyType;
    }

    public void setBodyType(OutBoundIntigrationBodyType bodyType) {
        this.bodyType = bodyType;
    }

    public IntegrationType getIntegrationType() {
        return this.integrationType;
    }

    public void setIntegrationType(IntegrationType integrationType) {
        this.integrationType = integrationType;
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(String errorHandler) {
        this.errorHandler = errorHandler;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public int getAssetModuleId() {
        return this.assetModuleId;
    }

    public void setAssetModuleId(int assetModuleId) {
        this.assetModuleId = assetModuleId;
    }

    public int getIsCMDB() {
        return this.isCMDB;
    }

    public void setIsCMDB(int isCMDB) {
        this.isCMDB = isCMDB;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private boolean updated;
        private String tenanatId;
        private Object history;
        private Integer id;
        private String body;
        private SdTemplateDTO template;
        private String integrationName;
        private String integrationDescription;
        private String url;
        private String header;
        private String authHandler;
        private String responseHandler;
        private String requestHandler;
        private String errorHandler;
        private String authKey;
        private String authValue;
        private int projectId;
        private HttpMethod httpMethod;
        private OutBoundIntigrationBodyType bodyType;
        private IntegrationType integrationType;
        private String authType;

        private Builder() {
        }

        public Builder withUpdated(boolean updated) {
            this.updated = updated;
            return this;
        }

        public Builder withTenanatId(String tenanatId) {
            this.tenanatId = tenanatId;
            return this;
        }

        public Builder withHistory(Object history) {
            this.history = history;
            return this;
        }

        public Builder withId(Integer id) {
            this.id = id;
            return this;
        }

        public Builder withBody(String body) {
            this.body = body;
            return this;
        }

        public Builder withTemplate(SdTemplateDTO template) {
            this.template = template;
            return this;
        }

        public Builder withIntegrationName(String integrationName) {
            this.integrationName = integrationName;
            return this;
        }

        public Builder withIntegrationDescription(String integrationDescription) {
            this.integrationDescription = integrationDescription;
            return this;
        }

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder withHeader(String header) {
            this.header = header;
            return this;
        }

        public Builder withAuthHandler(String authHandler) {
            this.authHandler = authHandler;
            return this;
        }

        public Builder withResponseHandler(String responseHandler) {
            this.responseHandler = responseHandler;
            return this;
        }

        public Builder withRequestHandler(String requestHandler) {
            this.requestHandler = requestHandler;
            return this;
        }

        public Builder withErrorHandler(String errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public Builder withAuthKey(String authKey) {
            this.authKey = authKey;
            return this;
        }

        public Builder withAuthValue(String authValue) {
            this.authValue = authValue;
            return this;
        }

        public Builder withProjectId(int projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder withHttpMethod(HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public Builder withBodyType(OutBoundIntigrationBodyType bodyType) {
            this.bodyType = bodyType;
            return this;
        }

        public Builder withIntegrationType(IntegrationType integrationType) {
            this.integrationType = integrationType;
            return this;
        }

        public Builder withAuthType(String authType) {
            this.authType = authType;
            return this;
        }

        public SdIntegrationConfigDTO build() {
            return new SdIntegrationConfigDTO(this);
        }
    }
}

