/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dto.projectcopy;

import com.fasterxml.jackson.annotation.JsonRootName;
import com.sapphireims.itsm.dto.ProjectMinDetailsDTO;
import com.sapphireims.itsm.dto.TenantDTO;
import com.sapphireims.itsm.dto.projectcopy.ProjectCopyRequestDTO;
import com.sapphireims.itsm.dto.projectcopy.ProjectCopyType;
import com.sapphireims.modulecopy.dto.ModuleCopyAttachmentsDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@JsonRootName(value="projectCopy")
public class ProjectCopyExportResponce {
    private String id;
    private Integer tenantId;
    private String name;
    private String description;
    private ProjectCopyType type;
    private List<ProjectMinDetailsDTO> projectList = new ArrayList<ProjectMinDetailsDTO>();
    private TenantDTO tenant;
    private ModuleCopyAttachmentsDTO mcaDTO;
    private boolean importRpaProcess;
    private boolean importDashboard;
    private Integer userId;

    private ProjectCopyExportResponce(Builder builder) {
        this.id = builder.id;
        this.tenantId = builder.tenantId;
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.projectList = builder.projectList;
        this.tenant = builder.tenant;
        this.importRpaProcess = builder.importRpaProcess;
    }

    public ProjectCopyExportResponce() {
    }

    public ProjectCopyExportResponce(ProjectCopyRequestDTO req) {
        this(0, req.getTemplateName(), req.getTemplateDescription(), req.getType(), new TenantDTO());
    }

    public ProjectCopyExportResponce(Integer tenantId, String name, String description, ProjectCopyType type, TenantDTO tenant) {
        this.tenantId = tenantId;
        this.name = name;
        this.description = description;
        this.type = type;
        this.tenant = tenant;
    }

    public void addProjectDetails(ProjectMinDetailsDTO details) {
        this.projectList.add(details);
    }

    public ProjectCopyExportResponce prepareTenant() {
        this.tenant = this.tenant.prepareTenant();
        return this;
    }

    public ProjectCopyType getType() {
        return this.type;
    }

    public void setType(ProjectCopyType type) {
        this.type = type;
    }

    public TenantDTO getTenant() {
        return this.tenant;
    }

    public void setTenant(TenantDTO tenant) {
        this.tenant = tenant;
    }

    public Integer getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(Integer tenantId) {
        this.tenantId = tenantId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<ProjectMinDetailsDTO> getProjectList() {
        return this.projectList;
    }

    public void setProjectList(List<ProjectMinDetailsDTO> projectList) {
        this.projectList = projectList;
    }

    public ModuleCopyAttachmentsDTO getMcaDTO() {
        return this.mcaDTO;
    }

    public void setMcaDTO(ModuleCopyAttachmentsDTO mcaDTO) {
        this.mcaDTO = mcaDTO;
    }

    public boolean isImportDashboard() {
        return this.importDashboard;
    }

    public void setImportDashboard(boolean importDashboard) {
        this.importDashboard = importDashboard;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isImportRpaProcess() {
        return this.importRpaProcess;
    }

    public void setImportRpaProcess(boolean importRpaProcess) {
        this.importRpaProcess = importRpaProcess;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer tenantId;
        private String name;
        private String description;
        private ProjectCopyType type;
        private List<ProjectMinDetailsDTO> projectList = Collections.emptyList();
        private TenantDTO tenant;
        private boolean importRpaProcess;

        private Builder() {
        }

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder withTenantId(Integer tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withType(ProjectCopyType type) {
            this.type = type;
            return this;
        }

        public Builder withProjectList(List<ProjectMinDetailsDTO> projectList) {
            this.projectList = projectList;
            return this;
        }

        public Builder withTenant(TenantDTO tenant) {
            this.tenant = tenant;
            return this;
        }

        public Builder withImportRpaProcess(boolean importRpaProcess) {
            this.importRpaProcess = importRpaProcess;
            return this;
        }

        public ProjectCopyExportResponce build() {
            return new ProjectCopyExportResponce(this);
        }
    }
}

