/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dto.ticket;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.MoreObjects;
import com.sapphireims.dto.BaseDTO;
import com.sapphireims.itsm.dto.SdAdditionalparamsDTO;
import com.sapphireims.itsm.dto.ticket.GridData;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Attribute
extends BaseDTO {
    private static final long serialVersionUID = 988955148823413622L;
    private Integer fieldid;
    private SdAdditionalparamsDTO additionalAttribute;
    private String data;
    private GridData grid;
    private String fieldDisplayName;

    private Attribute(Builder builder) {
        this.id = builder.id;
        this.updated = builder.updated;
        this.tenanatId = builder.tenanatId;
        this.history = builder.history;
        this.fieldid = builder.fieldid;
        this.additionalAttribute = builder.additionalAttribute;
        this.data = builder.data;
        this.grid = builder.grid;
        this.fieldDisplayName = builder.fieldDisplayName;
    }

    public Attribute(Integer fieldid, SdAdditionalparamsDTO additionalAttribute, String data, GridData grid) {
        this.fieldid = fieldid;
        this.additionalAttribute = additionalAttribute;
        this.data = data;
        this.grid = grid;
        this.fieldDisplayName = additionalAttribute.getFieldDisplayname();
    }

    public Attribute(Integer fieldid, SdAdditionalparamsDTO additionalAttribute, String data, GridData grid, boolean updated) {
        this.fieldid = fieldid;
        this.additionalAttribute = additionalAttribute;
        this.fieldDisplayName = additionalAttribute != null ? additionalAttribute.getFieldDisplayname() : "";
        this.data = data;
        this.grid = grid;
        this.updated = updated;
    }

    public Attribute(SdAdditionalparamsDTO additionalAttribute, String data) {
        this.additionalAttribute = additionalAttribute;
        this.data = data;
    }

    public Attribute() {
    }

    public Attribute(Integer id) {
        super(id);
    }

    public void addFirstColumnFieldId(int firstColumnFieldId) {
        if (this.grid == null) {
            this.grid = new GridData();
        }
        this.grid.setFirstColumnFieldId(firstColumnFieldId);
    }

    public void addRow() {
        if (this.grid == null) {
            this.grid = new GridData();
        }
        this.grid.addRow();
    }

    public void addGridData(Integer fieldId, Attribute data) {
        if (this.grid == null) {
            this.grid = new GridData();
        }
        this.grid.addGridData(fieldId, data);
    }

    public Integer getFieldid() {
        return this.fieldid;
    }

    public void setFieldid(Integer fieldid) {
        this.fieldid = fieldid;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getFieldDisplayName() {
        return this.fieldDisplayName;
    }

    public void setFieldDisplayName(String fieldDisplayName) {
        this.fieldDisplayName = fieldDisplayName;
    }

    public Integer getId() {
        return this.getFieldid();
    }

    public void setId(Integer id) {
        this.setFieldid(id);
    }

    @JsonIgnore
    public SdAdditionalparamsDTO getAdditionalAttribute() {
        return this.additionalAttribute;
    }

    public void setAdditionalAttribute(SdAdditionalparamsDTO additionalAttribute) {
        this.additionalAttribute = additionalAttribute;
    }

    public GridData getGrid() {
        return this.grid;
    }

    public void setGrid(GridData grid) {
        this.grid = grid;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public void setUpdated(boolean updated) {
        this.updated = updated;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.fieldid, this.additionalAttribute, this.data, this.grid});
    }

    public boolean equals(Object object) {
        if (object instanceof Attribute) {
            if (!super.equals(object)) {
                return false;
            }
            Attribute that = (Attribute)((Object)object);
            return Objects.equals(this.fieldid, that.fieldid) && Objects.equals((Object)this.additionalAttribute, (Object)that.additionalAttribute) && Objects.equals(this.data, that.data) && Objects.equals(this.grid, that.grid);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("super", (Object)super.toString()).add("serialVersionUID", 988955148823413622L).add("fieldid", (Object)this.fieldid).add("additionalAttribute", (Object)this.additionalAttribute).add("data", (Object)this.data).add("grid", (Object)this.grid).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer id;
        private boolean updated;
        private String tenanatId;
        private Object history;
        private Integer fieldid;
        private SdAdditionalparamsDTO additionalAttribute;
        private String data;
        private GridData grid;
        private String fieldDisplayName;

        private Builder() {
        }

        public Builder withId(Integer id) {
            this.id = id;
            return this;
        }

        public Builder withUpdated(boolean updated) {
            this.updated = updated;
            return this;
        }

        public Builder withTenanatId(String tenanatId) {
            this.tenanatId = tenanatId;
            return this;
        }

        public Builder withHistory(Object history) {
            this.history = history;
            return this;
        }

        public Builder withFieldid(Integer fieldid) {
            this.fieldid = fieldid;
            return this;
        }

        public Builder withAdditionalAttribute(SdAdditionalparamsDTO additionalAttribute) {
            this.additionalAttribute = additionalAttribute;
            return this;
        }

        public Builder withData(String data) {
            this.data = data;
            return this;
        }

        public Builder withGrid(GridData grid) {
            this.grid = grid;
            return this;
        }

        public Builder withFieldDisplayName(String fieldDisplayName) {
            this.fieldDisplayName = fieldDisplayName;
            return this;
        }

        public Attribute build() {
            return new Attribute(this);
        }
    }
}

