/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dto.ticket;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.MoreObjects;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.sapphireims.itsm.dto.ticket.Attribute;
import com.sapphireims.itsm.dto.ticket.GridRow;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class GridData
implements Serializable {
    private static final long serialVersionUID = -8858901539550580398L;
    @JsonIgnore
    private Table<Integer, Integer, Attribute> gridData;
    private int noOfRow = 0;
    private int firstColumnFieldId;
    private List<GridRow> rows;

    private GridData(Builder builder) {
        this.gridData = builder.gridData;
        this.noOfRow = builder.noOfRow;
        this.firstColumnFieldId = builder.firstColumnFieldId;
        this.rows = builder.rows;
    }

    public GridData() {
    }

    public GridData(int noOfRow, List<GridRow> rows) {
        this.noOfRow = noOfRow;
        this.rows = rows;
    }

    public GridData(Table<Integer, Integer, Attribute> gridData) {
        this.gridData = gridData;
    }

    public Table<Integer, Integer, Attribute> getGridData() {
        return this.gridData;
    }

    public void setGridData(Table<Integer, Integer, Attribute> gridData) {
        this.gridData = gridData;
    }

    public int getNoOfRow() {
        return this.noOfRow;
    }

    public void setNoOfRow(int noOfRow) {
        this.noOfRow = noOfRow;
    }

    public List<GridRow> getRows() {
        return this.rows;
    }

    public void setRows(List<GridRow> rows) {
        this.rows = rows;
    }

    public int getFirstColumnFieldId() {
        return this.firstColumnFieldId;
    }

    public void setFirstColumnFieldId(int firstColumnFieldId) {
        this.firstColumnFieldId = firstColumnFieldId;
    }

    public void addRow() {
        ++this.noOfRow;
    }

    public void addGridData(Integer fieldId, Attribute data) {
        if (this.gridData == null) {
            this.gridData = HashBasedTable.create();
        }
        this.gridData.put((Object)this.getNoOfRow(), (Object)fieldId, (Object)data);
    }

    public int hashCode() {
        return Objects.hash(this.gridData, this.noOfRow, this.firstColumnFieldId, this.rows);
    }

    public boolean equals(Object object) {
        if (object instanceof GridData) {
            GridData that = (GridData)object;
            return Objects.equals(this.gridData, that.gridData) && this.noOfRow == that.noOfRow && this.firstColumnFieldId == that.firstColumnFieldId && Objects.equals(this.rows, that.rows);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("serialVersionUID", -8858901539550580398L).add("gridData", this.gridData).add("noOfRow", this.noOfRow).add("firstColumnFieldId", this.firstColumnFieldId).add("rows", this.rows).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Table<Integer, Integer, Attribute> gridData;
        private int noOfRow;
        private int firstColumnFieldId;
        private List<GridRow> rows = Collections.emptyList();

        private Builder() {
        }

        public Builder withGridData(Table<Integer, Integer, Attribute> gridData) {
            this.gridData = gridData;
            return this;
        }

        public Builder withNoOfRow(int noOfRow) {
            this.noOfRow = noOfRow;
            return this;
        }

        public Builder withFirstColumnFieldId(int firstColumnFieldId) {
            this.firstColumnFieldId = firstColumnFieldId;
            return this;
        }

        public Builder withRows(List<GridRow> rows) {
            this.rows = rows;
            return this;
        }

        public GridData build() {
            return new GridData(this);
        }
    }
}

