/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dto.ticket;

import com.google.common.base.MoreObjects;
import com.sapphireims.itsm.dto.VelocityTemplate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TickectTemplate {
    private Integer projectId;
    private List<VelocityTemplate> templates;

    public TickectTemplate() {
    }

    public TickectTemplate(Integer projectId) {
        this.projectId = projectId;
        this.templates = new ArrayList<VelocityTemplate>();
    }

    public TickectTemplate(Integer projectId, List<VelocityTemplate> templates) {
        this.projectId = projectId;
        this.templates = templates;
    }

    public void addTemplate(VelocityTemplate v) {
        if (this.templates == null) {
            this.templates = new ArrayList<VelocityTemplate>();
        }
        this.templates.add(v);
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public List<VelocityTemplate> getTemplates() {
        return this.templates;
    }

    public void setTemplates(List<VelocityTemplate> templates) {
        this.templates = templates;
    }

    public void addDefaultTemplates() {
        this.addTemplate(new VelocityTemplate("Curent state", "${tickect.currentState.stateName}"));
        this.addTemplate(new VelocityTemplate("Curent state Id", "${tickect.currentState.stateId}"));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("projectId", (Object)this.projectId).add("templates", this.templates).toString();
    }

    public int hashCode() {
        return Objects.hash(this.projectId, this.templates);
    }

    public boolean equals(Object object) {
        if (object instanceof TickectTemplate) {
            TickectTemplate that = (TickectTemplate)object;
            return Objects.equals(this.projectId, that.projectId) && Objects.equals(this.templates, that.templates);
        }
        return false;
    }
}

