/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.dto.ticket;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.MoreObjects;
import com.sapphireims.cmdb.dto.AssetDTO;
import com.sapphireims.dto.BaseDTO;
import com.sapphireims.itsm.dto.EscalationLookupDTO;
import com.sapphireims.itsm.dto.FeedbackSubmissionDTO;
import com.sapphireims.itsm.dto.SdServicerequestHistoryDTO;
import com.sapphireims.itsm.dto.SdServicerequestHistoryMinDTO;
import com.sapphireims.itsm.dto.SdStatesMasterDTO;
import com.sapphireims.itsm.dto.SdUserFeedBackQuestionAndOptionsDTO;
import com.sapphireims.itsm.dto.ticket.AdditionalParams;
import com.sapphireims.itsm.dto.ticket.TicketAttachmentDTO;
import com.sapphireims.itsm.dto.ticket.TicketStateDTO;
import com.sapphireims.itsm.dto.user.UserDTO;
import com.sapphireims.itsm.dto.user.UserDetailsDTO;
import com.sapphireims.itsm.mindto.CategoryMinDTO;
import com.sapphireims.itsm.mindto.DepartmentMinDTO;
import com.sapphireims.itsm.mindto.DerivedFieldMinDTO;
import com.sapphireims.itsm.mindto.LocationMinDTO;
import com.sapphireims.itsm.mindto.ProjectMinDTO;
import com.sapphireims.itsm.mindto.ServiceMinDTO;
import com.sapphireims.itsm.mindto.SourceMinDTO;
import com.sapphireims.itsm.mindto.SubCategoryMinDTO;
import com.sapphireims.itsm.mindto.UipMinDTO;
import com.sapphireims.itsm.mindto.WorkGroupMinDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TicketDTO
extends BaseDTO {
    private static final long serialVersionUID = 1789878767486384586L;
    private Integer templateId;
    private String refId;
    private Integer problemId;
    private ProjectMinDTO project;
    private ServiceMinDTO service;
    private String title;
    private UserDetailsDTO submittedBy;
    private UserDTO approvalManager;
    private UserDTO owner;
    private UserDTO proxySubmittedBy;
    private UserDTO delegatedFromOwner;
    private UserDTO delegatedFromApprovalManager;
    private SdStatesMasterDTO currentState;
    private CategoryMinDTO category;
    private SubCategoryMinDTO subCategory;
    private LocationMinDTO location;
    private DepartmentMinDTO department;
    private UipMinDTO priority;
    private UipMinDTO urgency;
    private UipMinDTO impact;
    private DerivedFieldMinDTO derivedField1;
    private DerivedFieldMinDTO derivedField2;
    private DerivedFieldMinDTO derivedField3;
    private Date creationTime;
    private String probDescription;
    private String ccMailId;
    private String alternativeEmail;
    private String contactNumber;
    private int submittedThrough;
    private SourceMinDTO source;
    private int alertId;
    private int groupId;
    private WorkGroupMinDTO workGroup;
    private int repeatCall;
    private String resolutionComment;
    private String slaviolationComment;
    private byte conversionType;
    private String requestId;
    private int requestType;
    private int isTransferred;
    private String referenceId;
    private byte levelOneStatus;
    private byte levelTwoStatus;
    private int isLinked = 0;
    private int csi = 0;
    private int incidentType;
    private Date lastOperatedTime;
    private String expectedClosureTime;
    private String projectTransferComments;
    private int resolutionCauseId = 0;
    private String resolutionDays = "0";
    private String resolutionHours = "0";
    private String resolutionMinutes = "0";
    private String enclosure = "0";
    private AdditionalParams additionalParams;
    private List<TicketAttachmentDTO> attachments;
    private TicketStateDTO ticketStateDTO;
    private AssetDTO asset;
    private List<TicketDTO> childs;
    private TicketDTO parent;
    private List<TicketDTO> linkedTickets;
    private TicketDTO linkedParent;
    private int version;
    private int iteration = 0;
    private List<EscalationLookupDTO> escalations;
    private List<SdServicerequestHistoryDTO> servicerequestHistory;
    private boolean rpaEvent = false;
    private String latitude;
    private String longitude;
    private SdServicerequestHistoryDTO stateChangeHistory;
    private List<SdServicerequestHistoryMinDTO> enclosures;
    private int isFeedbackConfigured;
    private List<SdUserFeedBackQuestionAndOptionsDTO> feedback;
    private List<FeedbackSubmissionDTO> submitFeedBack;

    private TicketDTO(Builder builder) {
        this.id = builder.id;
        this.updated = builder.updated;
        this.tenanatId = builder.tenanatId;
        this.history = builder.history;
        this.templateId = builder.templateId;
        this.refId = builder.refId;
        this.problemId = builder.problemId;
        this.project = builder.project;
        this.service = builder.service;
        this.title = builder.title;
        this.submittedBy = builder.submittedBy;
        this.approvalManager = builder.approvalManager;
        this.owner = builder.owner;
        this.proxySubmittedBy = builder.proxySubmittedBy;
        this.delegatedFromOwner = builder.delegatedFromOwner;
        this.delegatedFromApprovalManager = builder.delegatedFromApprovalManager;
        this.currentState = builder.currentState;
        this.category = builder.category;
        this.subCategory = builder.subCategory;
        this.location = builder.location;
        this.department = builder.department;
        this.priority = builder.priority;
        this.urgency = builder.urgency;
        this.impact = builder.impact;
        this.derivedField1 = builder.derivedField1;
        this.derivedField2 = builder.derivedField2;
        this.derivedField3 = builder.derivedField3;
        this.creationTime = builder.creationTime;
        this.probDescription = builder.probDescription;
        this.ccMailId = builder.ccMailId;
        this.alternativeEmail = builder.alternativeEmail;
        this.contactNumber = builder.contactNumber;
        this.submittedThrough = builder.submittedThrough;
        this.source = builder.source;
        this.alertId = builder.alertId;
        this.groupId = builder.groupId;
        this.workGroup = builder.workGroup;
        this.repeatCall = builder.repeatCall;
        this.resolutionComment = builder.resolutionComment;
        this.slaviolationComment = builder.slaviolationComment;
        this.conversionType = builder.conversionType;
        this.requestId = builder.requestId;
        this.requestType = builder.requestType;
        this.isTransferred = builder.isTransferred;
        this.referenceId = builder.referenceId;
        this.levelOneStatus = builder.levelOneStatus;
        this.levelTwoStatus = builder.levelTwoStatus;
        this.isLinked = builder.isLinked;
        this.csi = builder.csi;
        this.incidentType = builder.incidentType;
        this.lastOperatedTime = builder.lastOperatedTime;
        this.expectedClosureTime = builder.expectedClosureTime;
        this.projectTransferComments = builder.projectTransferComments;
        this.resolutionCauseId = builder.resolutionCauseId;
        this.resolutionDays = builder.resolutionDays;
        this.resolutionHours = builder.resolutionHours;
        this.resolutionMinutes = builder.resolutionMinutes;
        this.enclosure = builder.enclosure;
        this.additionalParams = builder.additionalParams;
        this.attachments = builder.attachments;
        this.ticketStateDTO = builder.ticketStateDTO;
        this.asset = builder.asset;
        this.childs = builder.childs;
        this.parent = builder.parent;
        this.linkedTickets = builder.linkedTickets;
        this.linkedParent = builder.linkedParent;
        this.version = builder.version;
        this.iteration = builder.iteration;
        this.escalations = builder.escalations;
        this.servicerequestHistory = builder.servicerequestHistory;
        this.rpaEvent = builder.rpaEvent;
        this.stateChangeHistory = builder.stateChangeHistory;
        this.enclosures = builder.enclosures;
        this.isFeedbackConfigured = builder.isFeedbackConfigured;
        this.feedback = builder.feedback;
        this.submitFeedBack = builder.submitFeedBack;
    }

    public TicketDTO() {
        this.project = new ProjectMinDTO();
        this.service = new ServiceMinDTO();
        this.additionalParams = new AdditionalParams();
        this.ticketStateDTO = new TicketStateDTO();
        this.title = "";
        this.creationTime = new Date();
        this.probDescription = "";
        this.alternativeEmail = "";
        this.contactNumber = "";
        this.resolutionCauseId = 0;
        this.resolutionDays = "0";
        this.resolutionHours = "0";
        this.resolutionMinutes = "0";
        this.repeatCall = 0;
        this.resolutionComment = "";
        this.slaviolationComment = "";
        this.requestId = "0";
        this.referenceId = "0";
        this.levelOneStatus = 0;
        this.levelTwoStatus = 0;
        this.isLinked = 0;
        this.csi = 0;
        this.expectedClosureTime = "";
        this.rpaEvent = false;
        this.isFeedbackConfigured = 0;
        this.feedback = new ArrayList<SdUserFeedBackQuestionAndOptionsDTO>();
        this.submitFeedBack = new ArrayList<FeedbackSubmissionDTO>();
    }

    public TicketDTO(Integer id) {
        super(id);
        this.problemId = id;
        this.project = new ProjectMinDTO();
        this.service = new ServiceMinDTO();
        this.additionalParams = new AdditionalParams();
        this.ticketStateDTO = new TicketStateDTO();
        this.title = "";
        this.creationTime = new Date();
        this.probDescription = "";
        this.alternativeEmail = "";
        this.contactNumber = "";
        this.resolutionCauseId = 0;
        this.resolutionDays = "0";
        this.resolutionHours = "0";
        this.resolutionMinutes = "0";
        this.repeatCall = 0;
        this.resolutionComment = "";
        this.slaviolationComment = "";
        this.requestId = "0";
        this.referenceId = "0";
        this.levelOneStatus = 0;
        this.levelTwoStatus = 0;
        this.delegatedFromOwner = new UserDTO(Integer.valueOf(0));
        this.delegatedFromApprovalManager = new UserDTO(Integer.valueOf(0));
        this.isLinked = 0;
        this.csi = 0;
        this.expectedClosureTime = "";
        this.rpaEvent = false;
    }

    @JsonIgnore
    public void addHistory(SdServicerequestHistoryDTO h) {
        if (this.stateChangeHistory != null) {
            this.stateChangeHistory.addChild(h);
        } else {
            if (this.servicerequestHistory == null) {
                this.servicerequestHistory = new ArrayList<SdServicerequestHistoryDTO>();
            }
            this.servicerequestHistory.add(h);
        }
    }

    @JsonIgnore
    public SdServicerequestHistoryDTO getStateChangeHistory() {
        return this.stateChangeHistory;
    }

    @JsonIgnore
    public void setStateChangeHistory(SdServicerequestHistoryDTO stateChangeHistory) {
        this.stateChangeHistory = stateChangeHistory;
    }

    public boolean isRpaEvent() {
        return this.rpaEvent;
    }

    public void setRpaEvent(boolean rpaEvent) {
        this.rpaEvent = rpaEvent;
    }

    public List<SdServicerequestHistoryDTO> getServicerequestHistory() {
        return this.servicerequestHistory;
    }

    public void setServicerequestHistory(List<SdServicerequestHistoryDTO> servicerequestHistory) {
        this.servicerequestHistory = servicerequestHistory;
    }

    public List<EscalationLookupDTO> getEscalations() {
        return this.escalations;
    }

    public void setEscalations(List<EscalationLookupDTO> escalations) {
        this.escalations = escalations;
    }

    public SourceMinDTO getSource() {
        return this.source;
    }

    public void setSource(SourceMinDTO source) {
        this.source = source;
    }

    public List<TicketDTO> getLinkedTickets() {
        return this.linkedTickets;
    }

    public void setLinkedTickets(List<TicketDTO> linkedTickets) {
        this.linkedTickets = linkedTickets;
    }

    public TicketDTO getLinkedParent() {
        return this.linkedParent;
    }

    public void setLinkedParent(TicketDTO linkedParent) {
        this.linkedParent = linkedParent;
    }

    public int getIteration() {
        return this.iteration;
    }

    public void setIteration(int iteration) {
        this.iteration = iteration;
    }

    public String getEnclosure() {
        return this.enclosure;
    }

    public void setEnclosure(String enclosure) {
        this.enclosure = enclosure;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getRefId() {
        return this.refId;
    }

    public void setRefId(String refId) {
        this.refId = refId;
    }

    public String getContactNumber() {
        return this.contactNumber;
    }

    public void setContactNumber(String contactNumber) {
        this.contactNumber = contactNumber;
    }

    public TicketDTO getParent() {
        return this.parent;
    }

    public void setParent(TicketDTO parent) {
        this.parent = parent;
    }

    public AdditionalParams getAdditionalParams() {
        return this.additionalParams;
    }

    public void setAdditionalParams(AdditionalParams additionalParams) {
        this.additionalParams = additionalParams;
    }

    public ProjectMinDTO getProject() {
        return this.project;
    }

    public void setProject(ProjectMinDTO project) {
        this.project = project;
    }

    public ServiceMinDTO getService() {
        return this.service;
    }

    public void setService(ServiceMinDTO service) {
        this.service = service;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public UserDetailsDTO getSubmittedBy() {
        return this.submittedBy;
    }

    public void setSubmittedBy(UserDetailsDTO submittedBy) {
        this.submittedBy = submittedBy;
    }

    public UserDTO getApprovalManager() {
        return this.approvalManager;
    }

    public void setApprovalManager(UserDTO approvalManager) {
        this.approvalManager = approvalManager;
    }

    public UserDTO getOwner() {
        return this.owner;
    }

    public void setOwner(UserDTO owner) {
        this.owner = owner;
    }

    public UserDTO getProxySubmittedBy() {
        return this.proxySubmittedBy;
    }

    public void setProxySubmittedBy(UserDTO proxySubmittedBy) {
        this.proxySubmittedBy = proxySubmittedBy;
    }

    public UserDTO getDelegatedFromOwner() {
        return this.delegatedFromOwner;
    }

    public void setDelegatedFromOwner(UserDTO delegatedFromOwner) {
        this.delegatedFromOwner = delegatedFromOwner;
    }

    public UserDTO getDelegatedFromApprovalManager() {
        return this.delegatedFromApprovalManager;
    }

    public void setDelegatedFromApprovalManager(UserDTO delegatedFromApprovalManager) {
        this.delegatedFromApprovalManager = delegatedFromApprovalManager;
    }

    public SdStatesMasterDTO getCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(SdStatesMasterDTO currentState) {
        this.currentState = currentState;
    }

    public CategoryMinDTO getCategory() {
        return this.category;
    }

    public void setCategory(CategoryMinDTO category) {
        this.category = category;
    }

    public SubCategoryMinDTO getSubCategory() {
        return this.subCategory;
    }

    public void setSubCategory(SubCategoryMinDTO subCategory) {
        this.subCategory = subCategory;
    }

    public LocationMinDTO getLocation() {
        return this.location;
    }

    public void setLocation(LocationMinDTO location) {
        this.location = location;
    }

    public DepartmentMinDTO getDepartment() {
        return this.department;
    }

    public void setDepartment(DepartmentMinDTO department) {
        this.department = department;
    }

    public DerivedFieldMinDTO getDerivedField1() {
        return this.derivedField1;
    }

    public void setDerivedField1(DerivedFieldMinDTO derivedField1) {
        this.derivedField1 = derivedField1;
    }

    public DerivedFieldMinDTO getDerivedField2() {
        return this.derivedField2;
    }

    public void setDerivedField2(DerivedFieldMinDTO derivedField2) {
        this.derivedField2 = derivedField2;
    }

    public DerivedFieldMinDTO getDerivedField3() {
        return this.derivedField3;
    }

    public void setDerivedField3(DerivedFieldMinDTO derivedField3) {
        this.derivedField3 = derivedField3;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public String getProbDescription() {
        return this.probDescription;
    }

    public void setProbDescription(String probDescription) {
        this.probDescription = probDescription;
    }

    public String getCcMailId() {
        return this.ccMailId;
    }

    public void setCcMailId(String ccMailId) {
        this.ccMailId = ccMailId;
    }

    public String getAlternativeEmail() {
        return this.alternativeEmail;
    }

    public void setAlternativeEmail(String alternativeEmail) {
        this.alternativeEmail = alternativeEmail;
    }

    public int getSubmittedThrough() {
        return this.submittedThrough;
    }

    public void setSubmittedThrough(int submittedThrough) {
        this.submittedThrough = submittedThrough;
    }

    public int getAlertId() {
        return this.alertId;
    }

    public void setAlertId(int alertId) {
        this.alertId = alertId;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public int getRepeatCall() {
        return this.repeatCall;
    }

    public void setRepeatCall(int repeatCall) {
        this.repeatCall = repeatCall;
    }

    public String getResolutionComment() {
        return this.resolutionComment;
    }

    public void setResolutionComment(String resolutionComment) {
        this.resolutionComment = resolutionComment;
    }

    public String getSlaviolationComment() {
        return this.slaviolationComment;
    }

    public void setSlaviolationComment(String slaviolationComment) {
        this.slaviolationComment = slaviolationComment;
    }

    public byte getConversionType() {
        return this.conversionType;
    }

    public void setConversionType(byte conversionType) {
        this.conversionType = conversionType;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public int getIsTransferred() {
        return this.isTransferred;
    }

    public void setIsTransferred(int isTransferred) {
        this.isTransferred = isTransferred;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public byte getLevelOneStatus() {
        return this.levelOneStatus;
    }

    public void setLevelOneStatus(byte levelOneStatus) {
        this.levelOneStatus = levelOneStatus;
    }

    public byte getLevelTwoStatus() {
        return this.levelTwoStatus;
    }

    public void setLevelTwoStatus(byte levelTwoStatus) {
        this.levelTwoStatus = levelTwoStatus;
    }

    public int getIsLinked() {
        return this.isLinked;
    }

    public void setIsLinked(int isLinked) {
        this.isLinked = isLinked;
    }

    public int getCsi() {
        return this.csi;
    }

    public void setCsi(int csi) {
        this.csi = csi;
    }

    public int getIncidentType() {
        return this.incidentType;
    }

    public void setIncidentType(int incidentType) {
        this.incidentType = incidentType;
    }

    public Date getLastOperatedTime() {
        return this.lastOperatedTime;
    }

    public void setLastOperatedTime(Date lastOperatedTime) {
        this.lastOperatedTime = lastOperatedTime;
    }

    public String getExpectedClosureTime() {
        return this.expectedClosureTime;
    }

    public void setExpectedClosureTime(String expectedClosureTime) {
        this.expectedClosureTime = expectedClosureTime;
    }

    public String getProjectTransferComments() {
        return this.projectTransferComments;
    }

    public void setProjectTransferComments(String projectTransferComments) {
        this.projectTransferComments = projectTransferComments;
    }

    public int getResolutionCauseId() {
        return this.resolutionCauseId;
    }

    public void setResolutionCauseId(int resolutionCauseId) {
        this.resolutionCauseId = resolutionCauseId;
    }

    public String getResolutionDays() {
        return this.resolutionDays;
    }

    public void setResolutionDays(String resolutionDays) {
        this.resolutionDays = resolutionDays;
    }

    public String getResolutionHours() {
        return this.resolutionHours;
    }

    public void setResolutionHours(String resolutionHours) {
        this.resolutionHours = resolutionHours;
    }

    public String getResolutionMinutes() {
        return this.resolutionMinutes;
    }

    public void setResolutionMinutes(String resolutionMinutes) {
        this.resolutionMinutes = resolutionMinutes;
    }

    public List<TicketAttachmentDTO> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<TicketAttachmentDTO> attachments) {
        this.attachments = attachments;
    }

    public Integer getProblemId() {
        return this.problemId;
    }

    public void setProblemId(Integer problemId) {
        this.problemId = problemId;
        this.id = problemId;
    }

    public Integer getId() {
        return this.getProblemId();
    }

    public void setId(Integer id) {
        this.setProblemId(id);
    }

    public UipMinDTO getPriority() {
        return this.priority;
    }

    public void setPriority(UipMinDTO priority) {
        this.priority = priority;
    }

    public UipMinDTO getUrgency() {
        return this.urgency;
    }

    public void setUrgency(UipMinDTO urgency) {
        this.urgency = urgency;
    }

    public UipMinDTO getImpact() {
        return this.impact;
    }

    public void setImpact(UipMinDTO impact) {
        this.impact = impact;
    }

    public List<TicketDTO> getChilds() {
        return this.childs;
    }

    public void setChilds(List<TicketDTO> childs) {
        this.childs = childs;
    }

    public int getRequestType() {
        return this.requestType;
    }

    public void setRequestType(int requestType) {
        this.requestType = requestType;
    }

    public TicketStateDTO getTicketStateDTO() {
        return this.ticketStateDTO;
    }

    public void setTicketStateDTO(TicketStateDTO ticketStateDTO) {
        this.ticketStateDTO = ticketStateDTO;
    }

    public AssetDTO getAsset() {
        return this.asset;
    }

    public void setAsset(AssetDTO asset) {
        this.asset = asset;
    }

    public WorkGroupMinDTO getWorkGroup() {
        return this.workGroup;
    }

    public void setWorkGroup(WorkGroupMinDTO workGroup) {
        this.workGroup = workGroup;
    }

    public List<SdServicerequestHistoryMinDTO> getEnclosures() {
        return this.enclosures;
    }

    public Integer getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(Integer templateId) {
        this.templateId = templateId;
    }

    public void setEnclosures(List<SdServicerequestHistoryMinDTO> enclosures) {
        this.enclosures = enclosures;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public int isFeedbackConfigured() {
        return this.isFeedbackConfigured;
    }

    public void setIsFeedbackConfigured(int isFeedbackConfigured) {
        this.isFeedbackConfigured = isFeedbackConfigured;
    }

    public List<SdUserFeedBackQuestionAndOptionsDTO> getFeedback() {
        return this.feedback;
    }

    public void setFeedback(List<SdUserFeedBackQuestionAndOptionsDTO> feedback) {
        this.feedback = feedback;
    }

    public List<FeedbackSubmissionDTO> getSubmitFeedBack() {
        return this.submitFeedBack;
    }

    public void setSubmitFeedBack(List<FeedbackSubmissionDTO> submitFeedBack) {
        this.submitFeedBack = submitFeedBack;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.refId, this.problemId, this.project, this.service, this.title, this.submittedBy, this.approvalManager, this.owner, this.proxySubmittedBy, this.delegatedFromOwner, this.delegatedFromApprovalManager, this.currentState, this.category, this.subCategory, this.location, this.department, this.priority, this.urgency, this.impact, this.derivedField1, this.derivedField2, this.derivedField3, this.creationTime, this.probDescription, this.ccMailId, this.alternativeEmail, this.contactNumber, this.submittedThrough, this.source, this.alertId, this.groupId, this.workGroup, this.repeatCall, this.resolutionComment, this.slaviolationComment, this.conversionType, this.requestId, this.requestType, this.isTransferred, this.referenceId, this.levelOneStatus, this.levelTwoStatus, this.isLinked, this.csi, this.incidentType, this.lastOperatedTime, this.expectedClosureTime, this.projectTransferComments, this.resolutionCauseId, this.resolutionDays, this.resolutionHours, this.resolutionMinutes, this.enclosure, this.additionalParams, this.attachments, this.ticketStateDTO, this.asset, this.childs, this.parent, this.linkedTickets, this.linkedParent, this.version, this.iteration, this.escalations, this.servicerequestHistory, this.rpaEvent, this.latitude, this.longitude, this.isFeedbackConfigured, this.feedback, this.submitFeedBack});
    }

    public boolean equals(Object object) {
        if (object instanceof TicketDTO) {
            TicketDTO that = (TicketDTO)((Object)object);
            if (!super.equals(object)) {
                return false;
            }
            return Objects.equals(this.refId, that.refId) && Objects.equals(this.problemId, that.problemId) && Objects.equals((Object)this.project, (Object)that.project) && Objects.equals((Object)this.service, (Object)that.service) && Objects.equals(this.title, that.title) && Objects.equals((Object)this.submittedBy, (Object)that.submittedBy) && Objects.equals(this.approvalManager, that.approvalManager) && Objects.equals(this.owner, that.owner) && Objects.equals(this.proxySubmittedBy, that.proxySubmittedBy) && Objects.equals(this.delegatedFromOwner, that.delegatedFromOwner) && Objects.equals(this.delegatedFromApprovalManager, that.delegatedFromApprovalManager) && Objects.equals((Object)this.currentState, (Object)that.currentState) && Objects.equals((Object)this.category, (Object)that.category) && Objects.equals((Object)this.subCategory, (Object)that.subCategory) && Objects.equals(this.location, that.location) && Objects.equals(this.department, that.department) && Objects.equals((Object)this.priority, (Object)that.priority) && Objects.equals((Object)this.urgency, (Object)that.urgency) && Objects.equals((Object)this.impact, (Object)that.impact) && Objects.equals((Object)this.derivedField1, (Object)that.derivedField1) && Objects.equals((Object)this.derivedField2, (Object)that.derivedField2) && Objects.equals((Object)this.derivedField3, (Object)that.derivedField3) && Objects.equals(this.creationTime, that.creationTime) && Objects.equals(this.probDescription, that.probDescription) && Objects.equals(this.ccMailId, that.ccMailId) && Objects.equals(this.alternativeEmail, that.alternativeEmail) && Objects.equals(this.contactNumber, that.contactNumber) && this.submittedThrough == that.submittedThrough && Objects.equals((Object)this.source, (Object)that.source) && this.alertId == that.alertId && this.groupId == that.groupId && Objects.equals((Object)this.workGroup, (Object)that.workGroup) && this.repeatCall == that.repeatCall && Objects.equals(this.resolutionComment, that.resolutionComment) && Objects.equals(this.slaviolationComment, that.slaviolationComment) && this.conversionType == that.conversionType && Objects.equals(this.requestId, that.requestId) && this.requestType == that.requestType && this.isTransferred == that.isTransferred && Objects.equals(this.referenceId, that.referenceId) && this.levelOneStatus == that.levelOneStatus && this.levelTwoStatus == that.levelTwoStatus && this.isLinked == that.isLinked && this.csi == that.csi && this.incidentType == that.incidentType && Objects.equals(this.lastOperatedTime, that.lastOperatedTime) && Objects.equals(this.expectedClosureTime, that.expectedClosureTime) && Objects.equals(this.projectTransferComments, that.projectTransferComments) && this.resolutionCauseId == that.resolutionCauseId && Objects.equals(this.resolutionDays, that.resolutionDays) && Objects.equals(this.resolutionHours, that.resolutionHours) && Objects.equals(this.resolutionMinutes, that.resolutionMinutes) && Objects.equals(this.enclosure, that.enclosure) && Objects.equals((Object)this.additionalParams, (Object)that.additionalParams) && Objects.equals(this.attachments, that.attachments) && Objects.equals((Object)this.ticketStateDTO, (Object)that.ticketStateDTO) && Objects.equals((Object)this.asset, (Object)that.asset) && Objects.equals(this.childs, that.childs) && Objects.equals((Object)this.parent, (Object)that.parent) && Objects.equals(this.linkedTickets, that.linkedTickets) && Objects.equals((Object)this.linkedParent, (Object)that.linkedParent) && this.version == that.version && this.iteration == that.iteration && Objects.equals(this.escalations, that.escalations) && Objects.equals(this.servicerequestHistory, that.servicerequestHistory) && this.rpaEvent == that.rpaEvent && this.latitude == that.latitude && this.longitude == that.longitude && this.isFeedbackConfigured == that.isFeedbackConfigured && Objects.equals(this.feedback, that.feedback) && Objects.equals(this.submitFeedBack, that.submitFeedBack);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("super", (Object)super.toString()).add("serialVersionUID", 1789878767486384586L).add("refId", (Object)this.refId).add("problemId", (Object)this.problemId).add("project", (Object)this.project).add("service", (Object)this.service).add("title", (Object)this.title).add("submittedBy", (Object)this.submittedBy).add("approvalManager", (Object)this.approvalManager).add("owner", (Object)this.owner).add("proxySubmittedBy", (Object)this.proxySubmittedBy).add("delegatedFromOwner", (Object)this.delegatedFromOwner).add("delegatedFromApprovalManager", (Object)this.delegatedFromApprovalManager).add("currentState", (Object)this.currentState).add("category", (Object)this.category).add("subCategory", (Object)this.subCategory).add("location", (Object)this.location).add("department", (Object)this.department).add("priority", (Object)this.priority).add("urgency", (Object)this.urgency).add("impact", (Object)this.impact).add("derivedField1", (Object)this.derivedField1).add("derivedField2", (Object)this.derivedField2).add("derivedField3", (Object)this.derivedField3).add("creationTime", (Object)this.creationTime).add("probDescription", (Object)this.probDescription).add("ccMailId", (Object)this.ccMailId).add("alternativeEmail", (Object)this.alternativeEmail).add("contactNumber", (Object)this.contactNumber).add("submittedThrough", this.submittedThrough).add("source", (Object)this.source).add("alertId", this.alertId).add("groupId", this.groupId).add("workGroup", (Object)this.workGroup).add("repeatCall", this.repeatCall).add("resolutionComment", (Object)this.resolutionComment).add("slaviolationComment", (Object)this.slaviolationComment).add("conversionType", (int)this.conversionType).add("requestId", (Object)this.requestId).add("requestType", this.requestType).add("isTransferred", this.isTransferred).add("referenceId", (Object)this.referenceId).add("levelOneStatus", (int)this.levelOneStatus).add("levelTwoStatus", (int)this.levelTwoStatus).add("isLinked", this.isLinked).add("csi", this.csi).add("incidentType", this.incidentType).add("lastOperatedTime", (Object)this.lastOperatedTime).add("expectedClosureTime", (Object)this.expectedClosureTime).add("projectTransferComments", (Object)this.projectTransferComments).add("resolutionCauseId", this.resolutionCauseId).add("resolutionDays", (Object)this.resolutionDays).add("resolutionHours", (Object)this.resolutionHours).add("resolutionMinutes", (Object)this.resolutionMinutes).add("enclosure", (Object)this.enclosure).add("additionalParams", (Object)this.additionalParams).add("attachments", this.attachments).add("ticketStateDTO", (Object)this.ticketStateDTO).add("asset", (Object)this.asset).add("childs", this.childs).add("parent", (Object)this.parent).add("linkedTickets", this.linkedTickets).add("linkedParent", (Object)this.linkedParent).add("version", this.version).add("iteration", this.iteration).add("escalations", this.escalations).add("servicerequestHistory", this.servicerequestHistory).add("rpaEvent", this.rpaEvent).add("latitude", (Object)this.latitude).add("longitude", (Object)this.longitude).add("isFeedbackConfigured", this.isFeedbackConfigured).add("feedBack", this.feedback).add("submitFeedback", this.submitFeedBack).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer id;
        private boolean updated;
        private String tenanatId;
        private Object history;
        private Integer templateId;
        private String refId;
        private Integer problemId;
        private ProjectMinDTO project;
        private ServiceMinDTO service;
        private String title;
        private UserDetailsDTO submittedBy;
        private UserDTO approvalManager;
        private UserDTO owner;
        private UserDTO proxySubmittedBy;
        private UserDTO delegatedFromOwner;
        private UserDTO delegatedFromApprovalManager;
        private SdStatesMasterDTO currentState;
        private CategoryMinDTO category;
        private SubCategoryMinDTO subCategory;
        private LocationMinDTO location;
        private DepartmentMinDTO department;
        private UipMinDTO priority;
        private UipMinDTO urgency;
        private UipMinDTO impact;
        private DerivedFieldMinDTO derivedField1;
        private DerivedFieldMinDTO derivedField2;
        private DerivedFieldMinDTO derivedField3;
        private Date creationTime;
        private String probDescription;
        private String ccMailId;
        private String alternativeEmail;
        private String contactNumber;
        private int submittedThrough;
        private SourceMinDTO source;
        private int alertId;
        private int groupId;
        private WorkGroupMinDTO workGroup;
        private int repeatCall;
        private String resolutionComment;
        private String slaviolationComment;
        private byte conversionType;
        private String requestId;
        private int requestType;
        private int isTransferred;
        private String referenceId;
        private byte levelOneStatus;
        private byte levelTwoStatus;
        private int isLinked;
        private int csi;
        private int incidentType;
        private Date lastOperatedTime;
        private String expectedClosureTime;
        private String projectTransferComments;
        private int resolutionCauseId;
        private String resolutionDays;
        private String resolutionHours;
        private String resolutionMinutes;
        private String enclosure;
        private AdditionalParams additionalParams;
        private List<TicketAttachmentDTO> attachments = Collections.emptyList();
        private TicketStateDTO ticketStateDTO;
        private AssetDTO asset;
        private List<TicketDTO> childs = Collections.emptyList();
        private TicketDTO parent;
        private List<TicketDTO> linkedTickets = Collections.emptyList();
        private TicketDTO linkedParent;
        private int version;
        private int iteration;
        private List<EscalationLookupDTO> escalations = Collections.emptyList();
        private List<SdServicerequestHistoryDTO> servicerequestHistory = Collections.emptyList();
        private boolean rpaEvent;
        private SdServicerequestHistoryDTO stateChangeHistory;
        private List<SdServicerequestHistoryMinDTO> enclosures;
        private String latitude;
        private String longitude;
        private int isFeedbackConfigured;
        private List<SdUserFeedBackQuestionAndOptionsDTO> feedback;
        private List<FeedbackSubmissionDTO> submitFeedBack;

        private Builder() {
        }

        public Builder withId(Integer id) {
            this.id = id;
            return this;
        }

        public Builder withUpdated(boolean updated) {
            this.updated = updated;
            return this;
        }

        public Builder withTenanatId(String tenanatId) {
            this.tenanatId = tenanatId;
            return this;
        }

        public Builder withHistory(Object history) {
            this.history = history;
            return this;
        }

        public Builder withTemplateId(Integer templateId) {
            this.templateId = templateId;
            return this;
        }

        public Builder withRefId(String refId) {
            this.refId = refId;
            return this;
        }

        public Builder withProblemId(Integer problemId) {
            this.problemId = problemId;
            return this;
        }

        public Builder withProject(ProjectMinDTO project) {
            this.project = project;
            return this;
        }

        public Builder withService(ServiceMinDTO service) {
            this.service = service;
            return this;
        }

        public Builder withTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder withSubmittedBy(UserDetailsDTO submittedBy) {
            this.submittedBy = submittedBy;
            return this;
        }

        public Builder withApprovalManager(UserDTO approvalManager) {
            this.approvalManager = approvalManager;
            return this;
        }

        public Builder withOwner(UserDTO owner) {
            this.owner = owner;
            return this;
        }

        public Builder withProxySubmittedBy(UserDTO proxySubmittedBy) {
            this.proxySubmittedBy = proxySubmittedBy;
            return this;
        }

        public Builder withDelegatedFromOwner(UserDTO delegatedFromOwner) {
            this.delegatedFromOwner = delegatedFromOwner;
            return this;
        }

        public Builder withDelegatedFromApprovalManager(UserDTO delegatedFromApprovalManager) {
            this.delegatedFromApprovalManager = delegatedFromApprovalManager;
            return this;
        }

        public Builder withCurrentState(SdStatesMasterDTO currentState) {
            this.currentState = currentState;
            return this;
        }

        public Builder withCategory(CategoryMinDTO category) {
            this.category = category;
            return this;
        }

        public Builder withSubCategory(SubCategoryMinDTO subCategory) {
            this.subCategory = subCategory;
            return this;
        }

        public Builder withLocation(LocationMinDTO location) {
            this.location = location;
            return this;
        }

        public Builder withDepartment(DepartmentMinDTO department) {
            this.department = department;
            return this;
        }

        public Builder withPriority(UipMinDTO priority) {
            this.priority = priority;
            return this;
        }

        public Builder withUrgency(UipMinDTO urgency) {
            this.urgency = urgency;
            return this;
        }

        public Builder withImpact(UipMinDTO impact) {
            this.impact = impact;
            return this;
        }

        public Builder withDerivedField1(DerivedFieldMinDTO derivedField1) {
            this.derivedField1 = derivedField1;
            return this;
        }

        public Builder withDerivedField2(DerivedFieldMinDTO derivedField2) {
            this.derivedField2 = derivedField2;
            return this;
        }

        public Builder withDerivedField3(DerivedFieldMinDTO derivedField3) {
            this.derivedField3 = derivedField3;
            return this;
        }

        public Builder withCreationTime(Date creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public Builder withProbDescription(String probDescription) {
            this.probDescription = probDescription;
            return this;
        }

        public Builder withCcMailId(String ccMailId) {
            this.ccMailId = ccMailId;
            return this;
        }

        public Builder withAlternativeEmail(String alternativeEmail) {
            this.alternativeEmail = alternativeEmail;
            return this;
        }

        public Builder withContactNumber(String contactNumber) {
            this.contactNumber = contactNumber;
            return this;
        }

        public Builder withSubmittedThrough(int submittedThrough) {
            this.submittedThrough = submittedThrough;
            return this;
        }

        public Builder withSource(SourceMinDTO source) {
            this.source = source;
            return this;
        }

        public Builder withAlertId(int alertId) {
            this.alertId = alertId;
            return this;
        }

        public Builder withGroupId(int groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder withWorkGroup(WorkGroupMinDTO workGroup) {
            this.workGroup = workGroup;
            return this;
        }

        public Builder withRepeatCall(int repeatCall) {
            this.repeatCall = repeatCall;
            return this;
        }

        public Builder withResolutionComment(String resolutionComment) {
            this.resolutionComment = resolutionComment;
            return this;
        }

        public Builder withSlaviolationComment(String slaviolationComment) {
            this.slaviolationComment = slaviolationComment;
            return this;
        }

        public Builder withConversionType(byte conversionType) {
            this.conversionType = conversionType;
            return this;
        }

        public Builder withRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public Builder withRequestType(int requestType) {
            this.requestType = requestType;
            return this;
        }

        public Builder withIsTransferred(int isTransferred) {
            this.isTransferred = isTransferred;
            return this;
        }

        public Builder withReferenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public Builder withLevelOneStatus(byte levelOneStatus) {
            this.levelOneStatus = levelOneStatus;
            return this;
        }

        public Builder withLevelTwoStatus(byte levelTwoStatus) {
            this.levelTwoStatus = levelTwoStatus;
            return this;
        }

        public Builder withIsLinked(int isLinked) {
            this.isLinked = isLinked;
            return this;
        }

        public Builder withCsi(int csi) {
            this.csi = csi;
            return this;
        }

        public Builder withIncidentType(int incidentType) {
            this.incidentType = incidentType;
            return this;
        }

        public Builder withLastOperatedTime(Date lastOperatedTime) {
            this.lastOperatedTime = lastOperatedTime;
            return this;
        }

        public Builder withExpectedClosureTime(String expectedClosureTime) {
            this.expectedClosureTime = expectedClosureTime;
            return this;
        }

        public Builder withProjectTransferComments(String projectTransferComments) {
            this.projectTransferComments = projectTransferComments;
            return this;
        }

        public Builder withResolutionCauseId(int resolutionCauseId) {
            this.resolutionCauseId = resolutionCauseId;
            return this;
        }

        public Builder withResolutionDays(String resolutionDays) {
            this.resolutionDays = resolutionDays;
            return this;
        }

        public Builder withResolutionHours(String resolutionHours) {
            this.resolutionHours = resolutionHours;
            return this;
        }

        public Builder withResolutionMinutes(String resolutionMinutes) {
            this.resolutionMinutes = resolutionMinutes;
            return this;
        }

        public Builder withEnclosure(String enclosure) {
            this.enclosure = enclosure;
            return this;
        }

        public Builder withAdditionalParams(AdditionalParams additionalParams) {
            this.additionalParams = additionalParams;
            return this;
        }

        public Builder withAttachments(List<TicketAttachmentDTO> attachments) {
            this.attachments = attachments;
            return this;
        }

        public Builder withTicketStateDTO(TicketStateDTO ticketStateDTO) {
            this.ticketStateDTO = ticketStateDTO;
            return this;
        }

        public Builder withAsset(AssetDTO asset) {
            this.asset = asset;
            return this;
        }

        public Builder withChilds(List<TicketDTO> childs) {
            this.childs = childs;
            return this;
        }

        public Builder withParent(TicketDTO parent) {
            this.parent = parent;
            return this;
        }

        public Builder withLinkedTickets(List<TicketDTO> linkedTickets) {
            this.linkedTickets = linkedTickets;
            return this;
        }

        public Builder withLinkedParent(TicketDTO linkedParent) {
            this.linkedParent = linkedParent;
            return this;
        }

        public Builder withVersion(int version) {
            this.version = version;
            return this;
        }

        public Builder withIteration(int iteration) {
            this.iteration = iteration;
            return this;
        }

        public Builder withEscalations(List<EscalationLookupDTO> escalations) {
            this.escalations = escalations;
            return this;
        }

        public Builder withServicerequestHistory(List<SdServicerequestHistoryDTO> servicerequestHistory) {
            this.servicerequestHistory = servicerequestHistory;
            return this;
        }

        public Builder withRpaEvent(boolean rpaEvent) {
            this.rpaEvent = rpaEvent;
            return this;
        }

        public Builder withStateChangeHistory(SdServicerequestHistoryDTO stateChangeHistory) {
            this.stateChangeHistory = stateChangeHistory;
            return this;
        }

        public Builder withEnclosures(List<SdServicerequestHistoryMinDTO> enclosure) {
            this.enclosures = enclosure;
            return this;
        }

        public Builder withLatitude(String latitude) {
            this.latitude = latitude;
            return this;
        }

        public Builder withLongitude(String longitude) {
            this.longitude = longitude;
            return this;
        }

        public Builder withIsFeedbackConfigured(int isFeedbackConfigured) {
            this.isFeedbackConfigured = isFeedbackConfigured;
            return this;
        }

        public Builder withFeedBack(List<SdUserFeedBackQuestionAndOptionsDTO> feedback) {
            this.feedback = feedback;
            return this;
        }

        public Builder withSubmitFeedBack(List<FeedbackSubmissionDTO> submitFeedBack) {
            this.submitFeedBack = submitFeedBack;
            return this;
        }

        public TicketDTO build() {
            return new TicketDTO(this);
        }
    }
}

