/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.mindto;

import com.google.common.base.MoreObjects;
import com.sapphire.itsm.mailrouting.dto.MacrodetailsDTO;
import com.sapphireims.dto.BaseMinDTO;
import com.sapphireims.itsm.dto.SdAdditionalparamsDTO;
import com.sapphireims.itsm.mindto.Data;
import com.sapphireims.itsm.model.enummodel.FieldType;
import com.sapphireims.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class AdditionalParamsMinDTO
extends BaseMinDTO {
    private static final long serialVersionUID = 6166498106117101669L;
    private FieldType fieldType;
    private Integer macroid;
    private String macroName;
    private String macroQuery;
    private int fieldTypeId;
    private String fieldName;
    private List<Data> data;
    private String displayName;
    private boolean isGridField;
    private boolean isGridColumn;

    private AdditionalParamsMinDTO(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.updated = builder.updated;
        this.history = builder.history;
        this.fieldType = builder.fieldType;
        this.macroid = builder.macroid;
        this.macroName = builder.macroName;
        this.macroQuery = builder.macroQuery;
        this.fieldTypeId = builder.fieldTypeId;
        this.data = builder.data;
        this.displayName = builder.displayName;
        this.isGridField = builder.isGridField;
        this.isGridColumn = builder.isGridColumn;
    }

    public AdditionalParamsMinDTO() {
    }

    public AdditionalParamsMinDTO(Integer id, String displayName) {
        super(id, displayName);
    }

    public AdditionalParamsMinDTO(Integer id, String name, FieldType fieldType, Integer macroid, String macroName, String macroQuery) {
        super(id, name);
        this.fieldType = fieldType;
        this.macroid = macroid;
        this.macroName = macroName;
        this.macroQuery = macroQuery;
    }

    public AdditionalParamsMinDTO(SdAdditionalparamsDTO a) {
        super(a.getFieldid(), a.getFieldDisplayname());
        this.fieldName = a.getFieldName();
        this.fieldType = a.getMacro() != null ? a.getMacro().getFieldType() : null;
        this.macroid = a.getMacro() != null ? a.getMacro().getMacroid() : null;
        this.macroName = a.getMacro() != null ? a.getMacro().getMacroName() : null;
        this.macroQuery = a.getMacro() != null ? a.getMacro().getMacroQuery() : null;
        int n = this.fieldTypeId = a.getMacro() != null ? a.getMacro().getFieldType().getValue() : 0;
        if (a.getMacro() != null && CollectionUtil.isNotEmpty(a.getMacro().getMacrodetailses())) {
            this.data = new ArrayList<Data>(a.getMacro().getMacrodetailses().size());
            for (MacrodetailsDTO m : a.getMacro().getMacrodetailses()) {
                this.data.add(new Data(m));
            }
        }
        this.isGridField = a.isGrid();
        this.isGridColumn = a.isGridColumn();
        this.displayName = a.getFieldDisplayname();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.fieldType, this.macroid, this.macroName, this.macroQuery, this.fieldTypeId, this.data});
    }

    public boolean equals(Object object) {
        if (object instanceof AdditionalParamsMinDTO) {
            if (!super.equals(object)) {
                return false;
            }
            AdditionalParamsMinDTO that = (AdditionalParamsMinDTO)((Object)object);
            return Objects.equals((Object)this.fieldType, (Object)that.fieldType) && Objects.equals(this.macroid, that.macroid) && Objects.equals(this.macroName, that.macroName) && Objects.equals(this.macroQuery, that.macroQuery) && this.fieldTypeId == that.fieldTypeId && Objects.equals(this.data, that.data);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("super", (Object)super.toString()).add("serialVersionUID", 6166498106117101669L).add("fieldType", (Object)this.fieldType).add("macroid", (Object)this.macroid).add("macroName", (Object)this.macroName).add("macroQuery", (Object)this.macroQuery).add("fieldTypeId", this.fieldTypeId).add("data", this.data).toString();
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(FieldType fieldType) {
        this.fieldType = fieldType;
    }

    public Integer getMacroid() {
        return this.macroid;
    }

    public void setMacroid(Integer macroid) {
        this.macroid = macroid;
    }

    public String getMacroName() {
        return this.macroName;
    }

    public void setMacroName(String macroName) {
        this.macroName = macroName;
    }

    public String getMacroQuery() {
        return this.macroQuery;
    }

    public void setMacroQuery(String macroQuery) {
        this.macroQuery = macroQuery;
    }

    public int getFieldTypeId() {
        return this.fieldTypeId;
    }

    public void setFieldTypeId(int fieldTypeId) {
        this.fieldTypeId = fieldTypeId;
        this.fieldType = FieldType.getFieldType(fieldTypeId);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public List<Data> getData() {
        return this.data;
    }

    public void setData(List<Data> data) {
        this.data = data;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean getIsGridField() {
        return this.isGridField;
    }

    public void setIsGridField(boolean isGridField) {
        this.isGridField = isGridField;
    }

    public boolean getIsGridColumn() {
        return this.isGridColumn;
    }

    public void setIsGridColumn(boolean isGridColumn) {
        this.isGridColumn = isGridColumn;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer id;
        private String name;
        private boolean updated;
        private Object history;
        private FieldType fieldType;
        private Integer macroid;
        private String macroName;
        private String macroQuery;
        private int fieldTypeId;
        private String displayName;
        private List<Data> data = Collections.emptyList();
        private boolean isGridField;
        private boolean isGridColumn;

        private Builder() {
        }

        public Builder withDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder withId(Integer id) {
            this.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withUpdated(boolean updated) {
            this.updated = updated;
            return this;
        }

        public Builder withHistory(Object history) {
            this.history = history;
            return this;
        }

        public Builder withFieldType(FieldType fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        public Builder withMacroid(Integer macroid) {
            this.macroid = macroid;
            return this;
        }

        public Builder withMacroName(String macroName) {
            this.macroName = macroName;
            return this;
        }

        public Builder withMacroQuery(String macroQuery) {
            this.macroQuery = macroQuery;
            return this;
        }

        public Builder withFieldTypeId(int fieldTypeId) {
            this.fieldTypeId = fieldTypeId;
            return this;
        }

        public Builder withData(List<Data> data) {
            this.data = data;
            return this;
        }

        public Builder withIsGridField(boolean isGridField) {
            this.isGridField = isGridField;
            return this;
        }

        public Builder withIsGridColumn(boolean isGridColumn) {
            this.isGridColumn = isGridColumn;
            return this;
        }

        public AdditionalParamsMinDTO build() {
            return new AdditionalParamsMinDTO(this);
        }
    }
}

