/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.mindto;

import com.google.common.base.MoreObjects;
import com.sapphireims.dto.BaseMinDTO;
import com.sapphireims.itsm.dto.SdCategoryMasterDTO;
import com.sapphireims.itsm.dto.SdSubCategoryMasterDTO;
import com.sapphireims.itsm.mindto.SubCategoryMinDTO;
import com.sapphireims.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class CategoryMinDTO
extends BaseMinDTO {
    private static final long serialVersionUID = 6019778717140315790L;
    private Integer categoryId;
    private String categoryName;
    private String categoryshortName;
    private List<SubCategoryMinDTO> subcategoryList;

    private CategoryMinDTO(Builder builder) {
        this.categoryId = builder.categoryId;
        this.categoryName = builder.categoryName;
        this.subcategoryList = builder.subcategoryList;
    }

    public CategoryMinDTO() {
    }

    public CategoryMinDTO(Integer categoryId, String categoryName) {
        this.categoryId = categoryId;
        this.setId(categoryId);
        this.setName(categoryName);
        this.categoryName = categoryName;
    }

    public CategoryMinDTO(Integer categoryId, String categoryName, String shortName) {
        this.categoryId = categoryId;
        this.setId(categoryId);
        this.setName(categoryName);
        this.categoryName = categoryName;
        this.categoryshortName = shortName;
    }

    public CategoryMinDTO(String categoryName) {
        this.categoryName = categoryName;
        this.name = categoryName;
    }

    public CategoryMinDTO(SdCategoryMasterDTO category) {
        this.categoryId = category.getCategoryId();
        this.setId(this.categoryId);
        this.setName(category.getCategoryName());
        this.categoryName = category.getCategoryName();
        this.updated = category.isUpdated();
        if (CollectionUtil.isNotEmpty(category.getSdSubcategorymasters())) {
            this.subcategoryList = new ArrayList<SubCategoryMinDTO>(category.getSdSubcategorymasters().size());
            for (SdSubCategoryMasterDTO s : category.getSdSubcategorymasters()) {
                if (s.getStatus() != 0) continue;
                this.subcategoryList.add(new SubCategoryMinDTO(s));
            }
        }
    }

    public CategoryMinDTO(SdCategoryMasterDTO category, boolean updated) {
        this(category);
        this.categoryshortName = category.getShortname();
        this.updated = updated;
    }

    public CategoryMinDTO(int category) {
        super(Integer.valueOf(category), null);
        this.categoryId = category;
    }

    public Integer getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(Integer categoryId) {
        this.categoryId = categoryId;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getCategoryshortName() {
        return this.categoryshortName;
    }

    public void setCategoryshortName(String categoryshortName) {
        this.categoryshortName = categoryshortName;
    }

    public List<SubCategoryMinDTO> getSubcategoryList() {
        return this.subcategoryList;
    }

    public void setSubcategoryList(List<SubCategoryMinDTO> subcategoryList) {
        this.subcategoryList = subcategoryList;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("super", (Object)super.toString()).add("serialVersionUID", 6019778717140315790L).add("categoryId", (Object)this.categoryId).add("categoryName", (Object)this.categoryName).add("subcategoryList", this.subcategoryList).toString();
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.categoryId, this.categoryName, this.subcategoryList);
    }

    public boolean equals(Object object) {
        if (object instanceof CategoryMinDTO) {
            if (!super.equals(object)) {
                return false;
            }
            CategoryMinDTO that = (CategoryMinDTO)((Object)object);
            return Objects.equals(this.categoryId, that.categoryId) && Objects.equals(this.categoryName, that.categoryName) && Objects.equals(this.subcategoryList, that.subcategoryList);
        }
        return false;
    }

    public static final class Builder {
        private Integer categoryId;
        private String categoryName;
        private List<SubCategoryMinDTO> subcategoryList = Collections.emptyList();

        private Builder() {
        }

        public Builder withCategoryId(Integer categoryId) {
            this.categoryId = categoryId;
            return this;
        }

        public Builder withCategoryName(String categoryName) {
            this.categoryName = categoryName;
            return this;
        }

        public Builder withSubcategoryList(List<SubCategoryMinDTO> subcategoryList) {
            this.subcategoryList = subcategoryList;
            return this;
        }

        public CategoryMinDTO build() {
            return new CategoryMinDTO(this);
        }
    }
}

