/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.mindto;

import com.google.common.base.MoreObjects;
import com.sapphireims.dto.BaseMinDTO;
import com.sapphireims.itsm.dto.SdDependentMasterDTO;
import com.sapphireims.itsm.model.enummodel.DerivedFieldType;
import java.util.Objects;

public class DerivedFieldMinDTO
extends BaseMinDTO {
    private static final long serialVersionUID = 688688885021023035L;
    private Integer derivedFieldId;
    private String derivedFieldName;
    private DerivedFieldType type;
    private String shortName;

    public DerivedFieldMinDTO() {
    }

    public DerivedFieldMinDTO(Integer id, String name) {
        super(id, name);
    }

    public DerivedFieldMinDTO(SdDependentMasterDTO dependentMaster) {
        super(dependentMaster.getDependentFieldId(), dependentMaster.getDependentFieldName());
        this.derivedFieldId = dependentMaster.getDependentFieldId();
        this.derivedFieldName = dependentMaster.getDependentFieldName();
        this.type = dependentMaster.getType();
        this.id = dependentMaster.getDependentFieldId();
        this.name = dependentMaster.getDependentFieldName();
        this.shortName = dependentMaster.getShortname();
    }

    public DerivedFieldMinDTO(Integer dependentFieldId, String dependentFieldName, boolean updated) {
        super(dependentFieldId, dependentFieldName);
        this.updated = updated;
    }

    public DerivedFieldMinDTO(Integer dependentFieldId, String dependentFieldName, String shortName, boolean updated) {
        super(dependentFieldId, dependentFieldName);
        this.shortName = shortName;
        this.updated = updated;
    }

    public DerivedFieldMinDTO(int derivedField) {
        super(Integer.valueOf(derivedField), null);
        this.derivedFieldId = derivedField;
    }

    public DerivedFieldMinDTO(String derivedFieldName) {
        this.derivedFieldName = derivedFieldName;
        this.name = derivedFieldName;
    }

    public Integer getDerivedFieldId() {
        return this.derivedFieldId;
    }

    public void setDerivedFieldId(Integer derivedFieldId) {
        this.derivedFieldId = derivedFieldId;
    }

    public String getDerivedFieldName() {
        return this.derivedFieldName;
    }

    public void setDerivedFieldName(String derivedFieldName) {
        this.derivedFieldName = derivedFieldName;
    }

    public DerivedFieldType getType() {
        return this.type;
    }

    public void setType(DerivedFieldType type) {
        this.type = type;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.derivedFieldId, this.derivedFieldName, this.type});
    }

    public boolean equals(Object object) {
        if (object instanceof DerivedFieldMinDTO) {
            if (!super.equals(object)) {
                return false;
            }
            DerivedFieldMinDTO that = (DerivedFieldMinDTO)((Object)object);
            return Objects.equals(this.derivedFieldId, that.derivedFieldId) && Objects.equals(this.derivedFieldName, that.derivedFieldName) && Objects.equals((Object)this.type, (Object)that.type);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("super", (Object)super.toString()).add("serialVersionUID", 688688885021023035L).add("derivedFieldId", (Object)this.derivedFieldId).add("derivedFieldName", (Object)this.derivedFieldName).add("type", (Object)this.type).toString();
    }

    public static final class Builder {
        private Integer derivedFieldId;
        private String derivedFieldName;

        public Builder withDerivedFieldId(Integer derivedFieldId) {
            this.derivedFieldId = derivedFieldId;
            return this;
        }

        public Builder withDerivedFieldName(String derivedFieldName) {
            this.derivedFieldName = derivedFieldName;
            return this;
        }

        public DerivedFieldMinDTO build() {
            DerivedFieldMinDTO result = new DerivedFieldMinDTO();
            result.derivedFieldId = this.derivedFieldId;
            result.derivedFieldName = this.derivedFieldName;
            return result;
        }

        public Builder mergeFrom(DerivedFieldMinDTO src) {
            this.derivedFieldId = src.derivedFieldId;
            this.derivedFieldName = src.derivedFieldName;
            return this;
        }
    }
}

