/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.mindto;

import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphireims.dto.BaseMinDTO;

public class ProjectMinDTO
extends BaseMinDTO {
    private static final long serialVersionUID = -1241014129547275065L;
    private Integer projectId;
    private String projectName;
    private String projectDescription;
    private String shortname;
    private String image;
    private String color;
    private int version;
    private boolean isNlp;
    private byte displayOrder;
    private int isDefaultProject;
    private int defaultPage = 0;
    private String projectType;

    private ProjectMinDTO(Builder builder) {
        this.projectId = builder.projectId;
        this.projectName = builder.projectName;
        this.projectDescription = builder.projectDescription;
        this.shortname = builder.shortname;
        this.image = builder.image;
        this.color = builder.color;
        this.version = builder.version;
    }

    public ProjectMinDTO() {
    }

    public ProjectMinDTO(Integer projectId) {
        super(projectId, null);
        this.projectId = projectId;
    }

    public ProjectMinDTO(String projectName) {
        this.projectName = projectName;
        this.name = projectName;
    }

    public ProjectMinDTO(SdProjectMaster m) {
        this.projectId = m.getProjectId();
        this.projectName = m.getProjectName();
        this.projectDescription = m.getProjectDescription();
        this.shortname = m.getShortname();
        this.image = m.getImage();
        this.color = m.getColor();
        this.displayOrder = m.getDisplayOrder();
    }

    public ProjectMinDTO(Integer projectId, String projectName, String projectDescription, byte status, String shortname, String image, String color, byte displayOrder) {
        this.projectId = projectId;
        this.projectName = projectName;
        this.projectDescription = projectDescription;
        this.shortname = shortname;
        this.image = image;
        this.color = color;
        this.displayOrder = displayOrder;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
        this.id = projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
        this.name = projectName;
    }

    public String getProjectDescription() {
        return this.projectDescription;
    }

    public void setProjectDescription(String projectDescription) {
        this.projectDescription = projectDescription;
    }

    public String getShortname() {
        return this.shortname;
    }

    public void setShortname(String shortname) {
        this.shortname = shortname;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public byte getDisplayOrder() {
        return this.displayOrder;
    }

    public void setDisplayOrder(byte displayOrder) {
        this.displayOrder = displayOrder;
    }

    public boolean isNlp() {
        return this.isNlp;
    }

    public void setNlp(boolean isNlp) {
        this.isNlp = isNlp;
    }

    public int getIsDefaultProject() {
        return this.isDefaultProject;
    }

    public void setIsDefaultProject(int isDefaultProject) {
        this.isDefaultProject = isDefaultProject;
    }

    public int getDefaultPage() {
        return this.defaultPage;
    }

    public void setDefaultPage(int defaultPage) {
        this.defaultPage = defaultPage;
    }

    public String getProjectType() {
        return this.projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    public Integer getId() {
        return this.getProjectId();
    }

    public void setId(Integer id) {
        this.setProjectId(id);
    }

    public String toString() {
        return "ProjectMinDTO [projectId=" + this.projectId + ", projectName=" + this.projectName + ", projectDescription=" + this.projectDescription + ", shortname=" + this.shortname + ", image=" + this.image + ", color=" + this.color + ", version=" + this.version + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer projectId;
        private String projectName;
        private String projectDescription;
        private String shortname;
        private String image;
        private String color;
        private int version;

        private Builder() {
        }

        public Builder withProjectId(Integer projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder withProjectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public Builder withProjectDescription(String projectDescription) {
            this.projectDescription = projectDescription;
            return this;
        }

        public Builder withShortname(String shortname) {
            this.shortname = shortname;
            return this;
        }

        public Builder withImage(String image) {
            this.image = image;
            return this;
        }

        public Builder withColor(String color) {
            this.color = color;
            return this;
        }

        public Builder withVersion(int version) {
            this.version = version;
            return this;
        }

        public ProjectMinDTO build() {
            return new ProjectMinDTO(this);
        }
    }
}

