/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.mindto;

import com.google.common.base.MoreObjects;
import com.sapphireims.dto.BaseMinDTO;
import com.sapphireims.itsm.dto.SdProjectRolesDTO;
import java.util.Objects;

public class ProjectRolesMinDTO
extends BaseMinDTO {
    private static final long serialVersionUID = 4023370083842397788L;
    private String roleDisplayName;
    private Integer projectRoleId;
    private String roleDescription;

    public ProjectRolesMinDTO() {
    }

    public ProjectRolesMinDTO(SdProjectRolesDTO r) {
        super(r.getProjectRoleId(), r.getRoleName());
        this.roleDisplayName = r.getRoleDisplayName();
        this.projectRoleId = r.getProjectRoleId();
    }

    public ProjectRolesMinDTO(Integer id, String name, String roleDisplayName) {
        super(id, name);
        this.roleDisplayName = roleDisplayName;
    }

    public ProjectRolesMinDTO(Integer id, String name) {
        super(id, name);
    }

    public String getRoleDisplayName() {
        return this.roleDisplayName;
    }

    public void setRoleDisplayName(String roleDisplayName) {
        this.roleDisplayName = roleDisplayName;
    }

    public Integer getProjectRoleId() {
        return this.projectRoleId;
    }

    public void setProjectRoleId(Integer projectRoleId) {
        this.projectRoleId = projectRoleId;
    }

    public String getRoleDescription() {
        return this.roleDescription;
    }

    public void setRoleDescription(String roleDescription) {
        this.roleDescription = roleDescription;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("super", (Object)super.toString()).add("serialVersionUID", 4023370083842397788L).add("roleDisplayName", (Object)this.roleDisplayName).add("projectRoleId", (Object)this.projectRoleId).add("roleDescription", (Object)this.roleDescription).toString();
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.roleDisplayName, this.projectRoleId, this.roleDescription);
    }

    public boolean equals(Object object) {
        if (object instanceof ProjectRolesMinDTO) {
            if (!super.equals(object)) {
                return false;
            }
            ProjectRolesMinDTO that = (ProjectRolesMinDTO)((Object)object);
            return Objects.equals(this.roleDisplayName, that.roleDisplayName) && Objects.equals(this.projectRoleId, that.projectRoleId) && Objects.equals(this.roleDescription, that.roleDescription);
        }
        return false;
    }

    public static final class Builder {
        private String roleDisplayName;
        private Integer projectRoleId;

        public Builder withRoleDisplayName(String roleDisplayName) {
            this.roleDisplayName = roleDisplayName;
            return this;
        }

        public Builder withProjectRoleId(Integer projectRoleId) {
            this.projectRoleId = projectRoleId;
            return this;
        }

        public ProjectRolesMinDTO build() {
            ProjectRolesMinDTO result = new ProjectRolesMinDTO();
            result.roleDisplayName = this.roleDisplayName;
            result.projectRoleId = this.projectRoleId;
            return result;
        }

        public Builder mergeFrom(ProjectRolesMinDTO src) {
            this.roleDisplayName = src.roleDisplayName;
            this.projectRoleId = src.projectRoleId;
            return this;
        }
    }
}

