/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.mindto;

import com.google.common.base.MoreObjects;
import com.sapphireims.dto.BaseMinDTO;
import com.sapphireims.itsm.dto.SdServiceDTO;
import com.sapphireims.itsm.model.SdService;
import java.util.Objects;

public class ServiceMinDTO
extends BaseMinDTO {
    private static final long serialVersionUID = -7187987839759482640L;
    private Integer serviceId;
    private String serviceName;
    private String serviceChangeReason;
    private String serviceShortName;

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.serviceId, this.serviceName);
    }

    public boolean equals(Object object) {
        if (object instanceof ServiceMinDTO) {
            if (!super.equals(object)) {
                return false;
            }
            ServiceMinDTO that = (ServiceMinDTO)((Object)object);
            return Objects.equals(this.serviceId, that.serviceId) && Objects.equals(this.serviceName, that.serviceName);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("super", (Object)super.toString()).add("serialVersionUID", -7187987839759482640L).add("serviceId", (Object)this.serviceId).add("serviceName", (Object)this.serviceName).add("serviceShortName", (Object)this.serviceShortName).toString();
    }

    public ServiceMinDTO() {
    }

    public ServiceMinDTO(Integer serviceId) {
        super(serviceId, null);
        this.serviceId = serviceId;
    }

    public ServiceMinDTO(Integer id, String name) {
        super(id, name);
        this.serviceId = id;
        this.serviceName = name;
    }

    public ServiceMinDTO(Integer id, String name, String shortName) {
        super(id, name);
        this.serviceId = id;
        this.serviceName = name;
        this.serviceShortName = shortName;
    }

    public ServiceMinDTO(SdService sdService) {
        this(sdService.getServiceId(), sdService.getServiceName(), sdService.getShortName());
    }

    public ServiceMinDTO(SdServiceDTO sdService) {
        this(sdService.getServiceId(), sdService.getServiceName(), sdService.getShortName());
    }

    public ServiceMinDTO(SdServiceDTO sdService, boolean updated) {
        this(sdService.getServiceId(), sdService.getServiceName());
        this.serviceShortName = sdService.getShortName();
        this.updated = updated;
    }

    public ServiceMinDTO(String serviceName) {
        this.serviceName = serviceName;
        this.name = serviceName;
    }

    public Integer getId() {
        return this.getServiceId();
    }

    public void setId(Integer id) {
        this.setServiceId(id);
    }

    public Integer getServiceId() {
        return this.serviceId;
    }

    public String getName() {
        return this.getServiceName();
    }

    public void setName(String name) {
        this.setServiceName(name);
    }

    public String getServiceChangeReason() {
        return this.serviceChangeReason;
    }

    public void setServiceChangeReason(String reason) {
        this.serviceChangeReason = reason;
    }

    public void setServiceId(Integer serviceId) {
        this.serviceId = serviceId;
        this.id = serviceId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
        this.name = serviceName;
    }

    public String getServiceShortName() {
        return this.serviceShortName;
    }

    public void setServiceShortName(String serviceShortName) {
        this.serviceShortName = serviceShortName;
    }

    public static final class Builder {
        private Integer serviceId;
        private String serviceName;

        public Builder withServiceId(Integer serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public Builder withServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public ServiceMinDTO build() {
            ServiceMinDTO result = new ServiceMinDTO();
            result.serviceId = this.serviceId;
            result.serviceName = this.serviceName;
            return result;
        }

        public Builder mergeFrom(ServiceMinDTO src) {
            this.serviceId = src.serviceId;
            this.serviceName = src.serviceName;
            return this;
        }
    }
}

