/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.mindto;

import com.google.common.base.MoreObjects;
import com.sapphireims.dto.BaseMinDTO;
import com.sapphireims.itsm.dto.SdStatesMasterDTO;
import java.util.Objects;

public class StatesMinDTO
extends BaseMinDTO {
    private static final long serialVersionUID = -5224462380129303009L;
    private String shortName;
    private Integer stateId;
    private String stateName;

    public StatesMinDTO() {
    }

    public StatesMinDTO(Integer id, String name) {
        super(id, name);
    }

    public StatesMinDTO(Integer id, String name, String shortName) {
        super(id, name);
        this.shortName = shortName;
        this.stateId = id;
        this.stateName = name;
    }

    public StatesMinDTO(SdStatesMasterDTO st) {
        super(st.getStateId(), st.getStateName());
        this.shortName = st.getShortName();
        this.stateId = st.getStateId();
        this.stateName = st.getStateName();
    }

    public StatesMinDTO(String stateName) {
        this.stateName = stateName;
        this.name = stateName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public Integer getStateId() {
        return this.stateId;
    }

    public void setStateId(Integer stateId) {
        this.stateId = stateId;
    }

    public String getStateName() {
        return this.stateName;
    }

    public void setStateName(String stateName) {
        this.stateName = stateName;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.shortName, this.stateId, this.stateName);
    }

    public boolean equals(Object object) {
        if (object instanceof StatesMinDTO) {
            if (!super.equals(object)) {
                return false;
            }
            StatesMinDTO that = (StatesMinDTO)((Object)object);
            return Objects.equals(this.shortName, that.shortName) && Objects.equals(this.stateId, that.stateId) && Objects.equals(this.stateName, that.stateName);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("super", (Object)super.toString()).add("serialVersionUID", -5224462380129303009L).add("shortName", (Object)this.shortName).add("stateId", (Object)this.stateId).add("stateName", (Object)this.stateName).toString();
    }

    public static final class Builder {
        private String shortName;
        private Integer stateId;
        private String stateName;

        public Builder withShortName(String shortName) {
            this.shortName = shortName;
            return this;
        }

        public Builder withStateId(Integer stateId) {
            this.stateId = stateId;
            return this;
        }

        public Builder withStateName(String stateName) {
            this.stateName = stateName;
            return this;
        }

        public StatesMinDTO build() {
            StatesMinDTO result = new StatesMinDTO();
            result.shortName = this.shortName;
            result.stateId = this.stateId;
            result.stateName = this.stateName;
            return result;
        }

        public Builder mergeFrom(StatesMinDTO src) {
            this.shortName = src.shortName;
            this.stateId = src.stateId;
            this.stateName = src.stateName;
            return this;
        }
    }
}

