/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.mindto;

import com.google.common.base.MoreObjects;
import com.sapphireims.dto.BaseMinDTO;
import com.sapphireims.itsm.dto.SdSubCategoryMasterDTO;
import java.util.Objects;

public class SubCategoryMinDTO
extends BaseMinDTO {
    private static final long serialVersionUID = 3884837399784755788L;
    private Integer categoryId;
    private String categoryName;
    private Integer subcategoryId;
    private String subcategoryName;
    private String subcategoryShortName;

    private SubCategoryMinDTO(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.updated = builder.updated;
        this.history = builder.history;
        this.categoryId = builder.categoryId;
        this.categoryName = builder.categoryName;
        this.subcategoryId = builder.subcategoryId;
        this.subcategoryName = builder.subcategoryName;
        this.subcategoryShortName = builder.subcategoryShortName;
    }

    public SubCategoryMinDTO() {
    }

    public SubCategoryMinDTO(Integer id, String name) {
        super(id, name);
    }

    public SubCategoryMinDTO(Integer id, String name, Integer categoryId, String categoryName) {
        super(id, name);
        this.categoryId = categoryId;
        this.categoryName = categoryName;
    }

    public SubCategoryMinDTO(SdSubCategoryMasterDTO sdSubCategory) {
        super(sdSubCategory.getSubCategoryId(), sdSubCategory.getSubCategoryName());
        this.categoryId = sdSubCategory.getCategoryId();
        this.categoryName = sdSubCategory.getCategoryName();
        this.subcategoryShortName = sdSubCategory.getShortname();
        this.subcategoryId = sdSubCategory.getSubCategoryId();
        this.subcategoryName = sdSubCategory.getSubCategoryName();
    }

    public SubCategoryMinDTO(SdSubCategoryMasterDTO sdSubCategory, boolean u) {
        super(sdSubCategory.getSubCategoryId(), sdSubCategory.getSubCategoryName());
        this.categoryId = sdSubCategory.getCategoryId();
        this.categoryName = sdSubCategory.getCategoryName();
        this.subcategoryShortName = sdSubCategory.getShortname();
        this.subcategoryName = sdSubCategory.getSubCategoryName();
        this.updated = u;
    }

    public SubCategoryMinDTO(int subCategory) {
        super(Integer.valueOf(subCategory), null);
        this.subcategoryId = subCategory;
    }

    public SubCategoryMinDTO(String subcategoryName) {
        this.subcategoryName = subcategoryName;
        this.name = subcategoryName;
    }

    public Integer getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(Integer categoryId) {
        this.categoryId = categoryId;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public Integer getSubcategoryId() {
        return this.subcategoryId;
    }

    public void setSubcategoryId(Integer subcategoryId) {
        this.subcategoryId = subcategoryId;
    }

    public String getSubcategoryName() {
        return this.subcategoryName;
    }

    public void setSubcategoryName(String subcategoryName) {
        this.subcategoryName = subcategoryName;
    }

    public String getSubcategoryShortName() {
        return this.subcategoryShortName;
    }

    public void setSubcategoryShortName(String subcategoryShortName) {
        this.subcategoryShortName = subcategoryShortName;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("super", (Object)super.toString()).add("serialVersionUID", 3884837399784755788L).add("categoryId", (Object)this.categoryId).add("categoryName", (Object)this.categoryName).add("subcategoryId", (Object)this.subcategoryId).add("subcategoryName", (Object)this.subcategoryName).add("subcategoryShortName", (Object)this.subcategoryShortName).toString();
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.categoryId, this.categoryName, this.subcategoryId, this.subcategoryName);
    }

    public boolean equals(Object object) {
        if (object instanceof SubCategoryMinDTO) {
            if (!super.equals(object)) {
                return false;
            }
            SubCategoryMinDTO that = (SubCategoryMinDTO)((Object)object);
            return Objects.equals(this.categoryId, that.categoryId) && Objects.equals(this.categoryName, that.categoryName) && Objects.equals(this.subcategoryId, that.subcategoryId) && Objects.equals(this.subcategoryName, that.subcategoryName);
        }
        return false;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer id;
        private String name;
        private boolean updated;
        private Object history;
        private Integer categoryId;
        private String categoryName;
        private Integer subcategoryId;
        private String subcategoryName;
        private String subcategoryShortName;

        private Builder() {
        }

        public Builder withId(Integer id) {
            this.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withUpdated(boolean updated) {
            this.updated = updated;
            return this;
        }

        public Builder withHistory(Object history) {
            this.history = history;
            return this;
        }

        public Builder withCategoryId(Integer categoryId) {
            this.categoryId = categoryId;
            return this;
        }

        public Builder withCategoryName(String categoryName) {
            this.categoryName = categoryName;
            return this;
        }

        public Builder withSubcategoryId(Integer subcategoryId) {
            this.subcategoryId = subcategoryId;
            return this;
        }

        public Builder withSubcategoryName(String subcategoryName) {
            this.subcategoryName = subcategoryName;
            return this;
        }

        public Builder withSubcategoryShortName(String subcategoryShortName) {
            this.subcategoryShortName = subcategoryShortName;
            return this;
        }

        public SubCategoryMinDTO build() {
            return new SubCategoryMinDTO(this);
        }
    }
}

