/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.model;

import com.sapphireims.itsm.model.KnowledgeAccess;
import com.sapphireims.model.BaseModel;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

@Entity
@Table(name="knowledge_store")
public class KnowledgeStore
extends BaseModel {
    private static final long serialVersionUID = -4086212852336580867L;
    private Integer slno;
    private String title;
    private String problemDesc;
    private String resolutionDesc;
    private String submittedBy;
    private Integer approvedBy;
    private int isApproved;
    private Date time;
    private Integer knowledgeCategoryId;
    private Integer accessType;
    private String keywords;
    private int knowledgeType;
    private String rootCause;
    private String symptoms;
    private String errorCode;
    private int baseType;
    private int userViews;
    private int isKbvisible;
    private int projectId;
    private int knowledgeSubCategoryId;
    private int status;
    private Set<KnowledgeAccess> knowledgeAccesses = new HashSet<KnowledgeAccess>(0);

    public KnowledgeStore() {
    }

    public KnowledgeStore(int isApproved, int knowledgeType, int baseType, int userViews, int isKbvisible, int projectId, int knowledgeSubCategoryId, int status) {
        this.isApproved = isApproved;
        this.knowledgeType = knowledgeType;
        this.baseType = baseType;
        this.userViews = userViews;
        this.isKbvisible = isKbvisible;
        this.projectId = projectId;
        this.knowledgeSubCategoryId = knowledgeSubCategoryId;
        this.status = status;
    }

    public KnowledgeStore(String title, String problemDesc, String resolutionDesc, String submittedBy, Integer approvedBy, int isApproved, Date time, Integer knowledgeCategoryId, Integer accessType, String keywords, int knowledgeType, String rootCause, String symptoms, String errorCode, int baseType, int userViews, int isKbvisible, int projectId, int knowledgeSubCategoryId, int status, Set<KnowledgeAccess> knowledgeAccesses) {
        this.title = title;
        this.problemDesc = problemDesc;
        this.resolutionDesc = resolutionDesc;
        this.submittedBy = submittedBy;
        this.approvedBy = approvedBy;
        this.isApproved = isApproved;
        this.time = time;
        this.knowledgeCategoryId = knowledgeCategoryId;
        this.accessType = accessType;
        this.keywords = keywords;
        this.knowledgeType = knowledgeType;
        this.rootCause = rootCause;
        this.symptoms = symptoms;
        this.errorCode = errorCode;
        this.baseType = baseType;
        this.userViews = userViews;
        this.isKbvisible = isKbvisible;
        this.projectId = projectId;
        this.knowledgeSubCategoryId = knowledgeSubCategoryId;
        this.status = status;
        this.knowledgeAccesses = knowledgeAccesses;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="Slno", unique=true, nullable=false)
    public Integer getSlno() {
        return this.slno;
    }

    public void setSlno(Integer slno) {
        this.slno = slno;
    }

    @Column(name="Title", length=512)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Column(name="Problem_desc", length=2048)
    public String getProblemDesc() {
        return this.problemDesc;
    }

    public void setProblemDesc(String problemDesc) {
        this.problemDesc = problemDesc;
    }

    @Column(name="Resolution_desc", length=4096)
    public String getResolutionDesc() {
        return this.resolutionDesc;
    }

    public void setResolutionDesc(String resolutionDesc) {
        this.resolutionDesc = resolutionDesc;
    }

    @Column(name="SubmittedBy", length=256)
    public String getSubmittedBy() {
        return this.submittedBy;
    }

    public void setSubmittedBy(String submittedBy) {
        this.submittedBy = submittedBy;
    }

    @Column(name="ApprovedBy")
    public Integer getApprovedBy() {
        return this.approvedBy;
    }

    public void setApprovedBy(Integer approvedBy) {
        this.approvedBy = approvedBy;
    }

    @Column(name="IsApproved", nullable=false)
    public int getIsApproved() {
        return this.isApproved;
    }

    public void setIsApproved(int isApproved) {
        this.isApproved = isApproved;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="Time", length=19)
    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    @Column(name="KnowledgeCategoryID")
    public Integer getKnowledgeCategoryId() {
        return this.knowledgeCategoryId;
    }

    public void setKnowledgeCategoryId(Integer knowledgeCategoryId) {
        this.knowledgeCategoryId = knowledgeCategoryId;
    }

    @Column(name="AccessType")
    public Integer getAccessType() {
        return this.accessType;
    }

    public void setAccessType(Integer accessType) {
        this.accessType = accessType;
    }

    @Column(name="Keywords", length=250)
    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    @Column(name="KnowledgeType", nullable=false)
    public int getKnowledgeType() {
        return this.knowledgeType;
    }

    public void setKnowledgeType(int knowledgeType) {
        this.knowledgeType = knowledgeType;
    }

    @Column(name="RootCause", length=2048)
    public String getRootCause() {
        return this.rootCause;
    }

    public void setRootCause(String rootCause) {
        this.rootCause = rootCause;
    }

    @Column(name="Symptoms", length=2048)
    public String getSymptoms() {
        return this.symptoms;
    }

    public void setSymptoms(String symptoms) {
        this.symptoms = symptoms;
    }

    @Column(name="ErrorCode", length=512)
    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    @Column(name="BaseType", nullable=false)
    public int getBaseType() {
        return this.baseType;
    }

    public void setBaseType(int baseType) {
        this.baseType = baseType;
    }

    @Column(name="UserViews", nullable=false)
    public int getUserViews() {
        return this.userViews;
    }

    public void setUserViews(int userViews) {
        this.userViews = userViews;
    }

    @Column(name="isKBVisible", nullable=false)
    public int getIsKbvisible() {
        return this.isKbvisible;
    }

    public void setIsKbvisible(int isKbvisible) {
        this.isKbvisible = isKbvisible;
    }

    @Column(name="ProjectID", nullable=false)
    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    @Column(name="KnowledgeSubCategoryID", nullable=false)
    public int getKnowledgeSubCategoryId() {
        return this.knowledgeSubCategoryId;
    }

    public void setKnowledgeSubCategoryId(int knowledgeSubCategoryId) {
        this.knowledgeSubCategoryId = knowledgeSubCategoryId;
    }

    @Column(name="Status", nullable=false)
    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="knowledgeStore")
    public Set<KnowledgeAccess> getKnowledgeAccesses() {
        return this.knowledgeAccesses;
    }

    public void setKnowledgeAccesses(Set<KnowledgeAccess> knowledgeAccesses) {
        this.knowledgeAccesses = knowledgeAccesses;
    }
}

