/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.model;

import com.sapphireims.model.BaseModel;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.util.Date;

@Entity
@Table(name="sd_email_template_audit")
public class SdEmailTemplateAudit
extends BaseModel {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="Sl_no")
    private int slNo;
    @Column(name="Parameter", nullable=false, length=255)
    private String parameter;
    @Column(name="value", columnDefinition="MEDIUMTEXT")
    private String value;
    @Column(name="Ipaddress", nullable=false, length=50)
    private String ipAddress;
    @Column(name="ActionType", nullable=false, columnDefinition="INT DEFAULT 1")
    private int actionType;
    @Column(name="Actionperformedby", nullable=false, length=255)
    private String actionPerformedBy;
    @Column(name="Activitytime", nullable=false)
    private Date activityTime;

    public int getSlNo() {
        return this.slNo;
    }

    public void setSlNo(int slNo) {
        this.slNo = slNo;
    }

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public int getActionType() {
        return this.actionType;
    }

    public void setActionType(int actionType) {
        this.actionType = actionType;
    }

    public String getActionPerformedBy() {
        return this.actionPerformedBy;
    }

    public void setActionPerformedBy(String actionPerformedBy) {
        this.actionPerformedBy = actionPerformedBy;
    }

    public Date getActivityTime() {
        return this.activityTime;
    }

    public void setActivityTime(Date activityTime) {
        this.activityTime = activityTime;
    }

    public String getActionTypeString(Integer actionType) {
        switch (actionType) {
            case 1: {
                return "Added";
            }
            case 2: {
                return "Default Template";
            }
            case 3: {
                return "Deleted";
            }
        }
        return "Unknown";
    }

    public SdEmailTemplateAudit(String parameter, String value, String ipAddress, int actionType, String actionPerformedBy, Date activityTime) {
        this.parameter = parameter;
        this.value = value;
        this.ipAddress = ipAddress;
        this.actionType = actionType;
        this.actionPerformedBy = actionPerformedBy;
        this.activityTime = activityTime;
    }

    public String toString() {
        return "SdEmailTemplateAudit{slNo=" + this.slNo + ", parameter='" + this.parameter + "', value='" + this.value + "', ipAddress='" + this.ipAddress + "', actionType=" + this.actionType + ", actionPerformedBy='" + this.actionPerformedBy + "', activityTime=" + String.valueOf(this.activityTime) + "}";
    }

    public SdEmailTemplateAudit(int slNo, String parameter, String value, String ipAddress, int actionType, String actionPerformedBy, Date activityTime) {
        this.slNo = slNo;
        this.parameter = parameter;
        this.value = value;
        this.ipAddress = ipAddress;
        this.actionType = actionType;
        this.actionPerformedBy = actionPerformedBy;
        this.activityTime = activityTime;
    }

    public SdEmailTemplateAudit() {
    }
}

