/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.model;

import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphireims.itsm.dto.integration.SdIntegrationConfigDTO;
import com.sapphireims.itsm.model.SdTemplate;
import com.sapphireims.itsm.model.enummodel.HttpMethod;
import com.sapphireims.itsm.model.enummodel.IntegrationType;
import com.sapphireims.itsm.model.enummodel.OutBoundIntigrationBodyType;
import com.sapphireims.model.BaseModel;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;

@Entity
@Table(name="sd_integration_config")
public class SdIntegrationConfig
extends BaseModel {
    private static final long serialVersionUID = -8808487135499033180L;
    private Integer id;
    private SdTemplate sdTemplate;
    private String integrationName;
    private String integrationDescription;
    private String url;
    private String header;
    private String authHandler;
    private String responseHandler;
    private String requestHandler;
    private String errorHandler;
    private String authKey;
    private String authValue;
    private HttpMethod httpMethod;
    private OutBoundIntigrationBodyType bodyType;
    private IntegrationType integrationType;
    private int projectId;
    private String authType;

    private SdIntegrationConfig(Builder builder) {
        this.id = builder.id;
        this.sdTemplate = builder.sdTemplate;
        this.integrationName = builder.integrationName;
        this.integrationDescription = builder.integrationDescription;
        this.url = builder.url;
        this.header = builder.header;
        this.authHandler = builder.authHandler;
        this.responseHandler = builder.responseHandler;
        this.requestHandler = builder.requestHandler;
        this.errorHandler = builder.errorHandler;
        this.authKey = builder.authKey;
        this.authValue = builder.authValue;
        this.httpMethod = builder.httpMethod;
        this.bodyType = builder.bodyType;
        this.integrationType = builder.integrationType;
        this.projectId = builder.projectId;
        this.authType = builder.authType;
    }

    public SdIntegrationConfig() {
    }

    public SdIntegrationConfig(Integer id, SdTemplate sdTemplate, String integrationName, int projectId) {
        this.id = id;
        this.sdTemplate = sdTemplate;
        this.integrationName = integrationName;
        this.projectId = projectId;
    }

    public SdIntegrationConfig(Integer id, SdTemplate sdTemplate, String integrationName, String integrationDescription, String url, String header, String authHandler, String responseHandler, String requestHandler, String authKey, String authValue, HttpMethod httpMethod, OutBoundIntigrationBodyType bodyType, int projectId) {
        this.id = id;
        this.sdTemplate = sdTemplate;
        this.integrationName = integrationName;
        this.integrationDescription = integrationDescription;
        this.url = url;
        this.header = header;
        this.authHandler = authHandler;
        this.responseHandler = responseHandler;
        this.requestHandler = requestHandler;
        this.authKey = authKey;
        this.authValue = authValue;
        this.httpMethod = httpMethod;
        this.bodyType = bodyType;
        this.projectId = projectId;
    }

    public SdIntegrationConfig(SdIntegrationConfigDTO pr, SdTemplate sdTemplate, SdProjectMaster project) {
        this.id = pr.getId();
        this.sdTemplate = sdTemplate;
        this.integrationName = pr.getIntegrationName();
        this.integrationDescription = pr.getIntegrationDescription();
        this.url = pr.getUrl();
        this.header = pr.getHeader();
        this.authHandler = pr.getAuthHandler();
        this.responseHandler = pr.getResponseHandler();
        this.requestHandler = pr.getRequestHandler();
        this.authKey = pr.getAuthKey();
        this.authValue = pr.getAuthValue();
        this.httpMethod = pr.getHttpMethod();
        this.bodyType = pr.getBodyType();
        this.projectId = project.getProjectId();
    }

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", unique=true, nullable=false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="template_id", nullable=false)
    public SdTemplate getSdTemplate() {
        return this.sdTemplate;
    }

    public void setSdTemplate(SdTemplate sdTemplate) {
        this.sdTemplate = sdTemplate;
    }

    @Column(name="integration_name", nullable=false, length=100)
    public String getIntegrationName() {
        return this.integrationName;
    }

    public void setIntegrationName(String integrationName) {
        this.integrationName = integrationName;
    }

    @Column(name="integration_description", length=1000)
    public String getIntegrationDescription() {
        return this.integrationDescription;
    }

    public void setIntegrationDescription(String integrationDescription) {
        this.integrationDescription = integrationDescription;
    }

    @Column(name="URL", length=1000)
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Column(name="header", length=1000)
    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    @Column(name="auth_handler", length=500)
    public String getAuthHandler() {
        return this.authHandler;
    }

    public void setAuthHandler(String authHandler) {
        this.authHandler = authHandler;
    }

    @Column(name="response_handler", length=500)
    public String getResponseHandler() {
        return this.responseHandler;
    }

    public void setResponseHandler(String responseHandler) {
        this.responseHandler = responseHandler;
    }

    @Column(name="request_handler", length=500)
    public String getRequestHandler() {
        return this.requestHandler;
    }

    public void setRequestHandler(String requestHandler) {
        this.requestHandler = requestHandler;
    }

    @Column(name="auth_key", length=2000)
    public String getAuthKey() {
        return this.authKey;
    }

    public void setAuthKey(String authKey) {
        this.authKey = authKey;
    }

    @Column(name="auth_value", length=2000)
    public String getAuthValue() {
        return this.authValue;
    }

    public void setAuthValue(String authValue) {
        this.authValue = authValue;
    }

    @Column(name="project_id", nullable=false)
    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="http_method", length=10)
    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="body_type", length=10)
    public OutBoundIntigrationBodyType getBodyType() {
        return this.bodyType;
    }

    public void setBodyType(OutBoundIntigrationBodyType bodyType) {
        this.bodyType = bodyType;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="integration_type", length=10)
    public IntegrationType getIntegrationType() {
        return this.integrationType;
    }

    public void setIntegrationType(IntegrationType integrationType) {
        this.integrationType = integrationType;
    }

    @Column(name="auth_type", length=255)
    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    @Column(name="error_handler", length=2000)
    public String getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(String errorHandler) {
        this.errorHandler = errorHandler;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer id;
        private SdTemplate sdTemplate;
        private String integrationName;
        private String integrationDescription;
        private String url;
        private String header;
        private String authHandler;
        private String responseHandler;
        private String requestHandler;
        private String errorHandler;
        private String authKey;
        private String authValue;
        private HttpMethod httpMethod;
        private OutBoundIntigrationBodyType bodyType;
        private IntegrationType integrationType;
        private int projectId;
        private String authType;

        private Builder() {
        }

        public Builder withId(Integer id) {
            this.id = id;
            return this;
        }

        public Builder withSdTemplate(SdTemplate sdTemplate) {
            this.sdTemplate = sdTemplate;
            return this;
        }

        public Builder withIntegrationName(String integrationName) {
            this.integrationName = integrationName;
            return this;
        }

        public Builder withIntegrationDescription(String integrationDescription) {
            this.integrationDescription = integrationDescription;
            return this;
        }

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder withHeader(String header) {
            this.header = header;
            return this;
        }

        public Builder withAuthHandler(String authHandler) {
            this.authHandler = authHandler;
            return this;
        }

        public Builder withResponseHandler(String responseHandler) {
            this.responseHandler = responseHandler;
            return this;
        }

        public Builder withRequestHandler(String requestHandler) {
            this.requestHandler = requestHandler;
            return this;
        }

        public Builder withErrorHandler(String errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public Builder withAuthKey(String authKey) {
            this.authKey = authKey;
            return this;
        }

        public Builder withAuthValue(String authValue) {
            this.authValue = authValue;
            return this;
        }

        public Builder withHttpMethod(HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public Builder withBodyType(OutBoundIntigrationBodyType bodyType) {
            this.bodyType = bodyType;
            return this;
        }

        public Builder withIntegrationType(IntegrationType integrationType) {
            this.integrationType = integrationType;
            return this;
        }

        public Builder withProjectId(int projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder withAuthType(String authType) {
            this.authType = authType;
            return this;
        }

        public SdIntegrationConfig build() {
            return new SdIntegrationConfig(this);
        }
    }
}

