/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.model;

import com.sapphireims.itsm.model.SdIntegrationConfig;
import com.sapphireims.itsm.model.enummodel.HttpMethod;
import com.sapphireims.itsm.model.enummodel.IntegrationType;
import com.sapphireims.model.BaseModel;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;

@Entity
@Table(name="sd_integration_log")
public class SdIntegrationLog
extends BaseModel {
    private static final long serialVersionUID = 1946637235136136208L;
    private Integer id;
    private SdIntegrationConfig sdIntegrationConfig;
    private String url;
    private String request;
    private String header;
    private String response;
    private Integer problemId;
    private Integer entityId;
    private String eventName;
    private boolean success;
    private boolean retry;
    private int retryCount;
    private boolean connectionFailed;
    private HttpMethod httpMethod;
    private IntegrationType integrationType;
    private Date createTime;
    private Date updateTime;

    public SdIntegrationLog() {
    }

    public SdIntegrationLog(Integer id) {
        this.id = id;
    }

    public SdIntegrationLog(Integer id, SdIntegrationConfig sdIntegrationConfig, String url, String request, String header, String response, Integer problemId, Integer entityId, String eventName, boolean success, boolean retry, int retryCount, boolean connectionFailed, HttpMethod httpMethod, IntegrationType integrationType, Date createTime, Date updateTime) {
        this.id = id;
        this.sdIntegrationConfig = sdIntegrationConfig;
        this.url = url;
        this.request = request;
        this.header = header;
        this.response = response;
        this.problemId = problemId;
        this.entityId = entityId;
        this.eventName = eventName;
        this.success = success;
        this.retry = retry;
        this.retryCount = retryCount;
        this.connectionFailed = connectionFailed;
        this.httpMethod = httpMethod;
        this.integrationType = integrationType;
        this.createTime = createTime;
        this.updateTime = updateTime;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", unique=true, nullable=false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="integration_config_id")
    public SdIntegrationConfig getSdIntegrationConfig() {
        return this.sdIntegrationConfig;
    }

    public void setSdIntegrationConfig(SdIntegrationConfig sdIntegrationConfig) {
        this.sdIntegrationConfig = sdIntegrationConfig;
    }

    @Column(name="URL", length=1000)
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Column(name="request", length=65535)
    public String getRequest() {
        return this.request;
    }

    public void setRequest(String request) {
        this.request = request;
    }

    @Column(name="response", length=65535)
    public String getResponse() {
        return this.response;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    @Column(name="problem_id")
    public Integer getProblemId() {
        return this.problemId;
    }

    public void setProblemId(Integer problemId) {
        this.problemId = problemId;
    }

    @Column(name="success")
    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    @Column(name="is_retry")
    public boolean isRetry() {
        return this.retry;
    }

    public void setRetry(boolean retry) {
        this.retry = retry;
    }

    @Column(name="connection_failed")
    public boolean isConnectionFailed() {
        return this.connectionFailed;
    }

    public void setConnectionFailed(boolean connectionFailed) {
        this.connectionFailed = connectionFailed;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="create_time", length=19)
    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="update_time", length=19)
    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @Column(name="entity_id")
    public Integer getEntityId() {
        return this.entityId;
    }

    public void setEntityId(Integer entityId) {
        this.entityId = entityId;
    }

    @Column(name="event_name")
    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    @Column(name="retry_count")
    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    @Column(name="header")
    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="http_method", length=10)
    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="integration_type", length=10)
    public IntegrationType getIntegrationType() {
        return this.integrationType;
    }

    public void setIntegrationType(IntegrationType integrationType) {
        this.integrationType = integrationType;
    }
}

