/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.model;

import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphireims.itsm.dto.SdNotifyDetailDTO;
import com.sapphireims.model.BaseModel;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;

@Entity
@Table(name="sd_notify_detail")
public class SdNotifyDetail
extends BaseModel {
    private static final long serialVersionUID = -3175784688038011909L;
    private Integer notifyId;
    private String displayName;
    private String description;
    private String alertType;
    private String channelType;
    private String launchParams;
    private int projectId;
    private Byte isCustomized;
    private String customProcedureName;
    private int emailTemplateId;
    private Integer smstemplateId;

    public SdNotifyDetail() {
    }

    public SdNotifyDetail(String alertType, String channelType, int projectId, int emailTemplateId) {
        this.alertType = alertType;
        this.channelType = channelType;
        this.projectId = projectId;
        this.emailTemplateId = emailTemplateId;
    }

    public SdNotifyDetail(String displayName, String description, String alertType, String channelType, String launchParams, int projectId, Byte isCustomized, String customProcedureName, int emailTemplateId, Integer smstemplateId) {
        this.displayName = displayName;
        this.description = description;
        this.alertType = alertType;
        this.channelType = channelType;
        this.launchParams = launchParams;
        this.projectId = projectId;
        this.isCustomized = isCustomized;
        this.customProcedureName = customProcedureName;
        this.emailTemplateId = emailTemplateId;
        this.smstemplateId = smstemplateId;
    }

    public SdNotifyDetail(SdNotifyDetailDTO sndDTO, SdProjectMaster spm, Integer emailNotificationTemplateId, Integer smsNotificationTemplateId) {
        this.displayName = sndDTO.getDisplayName();
        this.description = sndDTO.getDescription();
        this.alertType = sndDTO.getAlertType();
        this.channelType = sndDTO.getChannelType();
        this.launchParams = sndDTO.getLaunchParams();
        this.projectId = spm.getProjectId();
        this.isCustomized = sndDTO.getIsCustomized();
        this.customProcedureName = sndDTO.getCustomProcedureName();
        this.emailTemplateId = emailNotificationTemplateId;
        this.smstemplateId = smsNotificationTemplateId;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="NotifyID", unique=true, nullable=false)
    public Integer getNotifyId() {
        return this.notifyId;
    }

    public void setNotifyId(Integer notifyId) {
        this.notifyId = notifyId;
    }

    @Column(name="DisplayName")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Column(name="Description", length=1024)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column(name="AlertType", nullable=false, length=5)
    public String getAlertType() {
        return this.alertType;
    }

    public void setAlertType(String alertType) {
        this.alertType = alertType;
    }

    @Column(name="ChannelType", nullable=false, length=5)
    public String getChannelType() {
        return this.channelType;
    }

    public void setChannelType(String channelType) {
        this.channelType = channelType;
    }

    @Column(name="LaunchParams", length=1024)
    public String getLaunchParams() {
        return this.launchParams;
    }

    public void setLaunchParams(String launchParams) {
        this.launchParams = launchParams;
    }

    @Column(name="ProjectID", nullable=false)
    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    @Column(name="IsCustomized")
    public Byte getIsCustomized() {
        return this.isCustomized;
    }

    public void setIsCustomized(Byte isCustomized) {
        this.isCustomized = isCustomized;
    }

    @Column(name="CustomProcedureName", length=128)
    public String getCustomProcedureName() {
        return this.customProcedureName;
    }

    public void setCustomProcedureName(String customProcedureName) {
        this.customProcedureName = customProcedureName;
    }

    @Column(name="EmailTemplateID", nullable=false)
    public int getEmailTemplateId() {
        return this.emailTemplateId;
    }

    public void setEmailTemplateId(int emailTemplateId) {
        this.emailTemplateId = emailTemplateId;
    }

    @Column(name="SMSTemplateID")
    public Integer getSmstemplateId() {
        return this.smstemplateId;
    }

    public void setSmstemplateId(Integer smstemplateId) {
        this.smstemplateId = smstemplateId;
    }
}

