/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.model;

import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphireims.itsm.model.SdServiceReqMaster;
import com.sapphireims.model.BaseModel;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="sd_service")
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="sdservice")
public class SdService
extends BaseModel {
    private static final long serialVersionUID = -8910211781263577842L;
    private Integer serviceId;
    private SdProjectMaster sdProjectMaster;
    private String serviceName;
    private String serviceDescription;
    private int status;
    private String defaultImageName;
    private String shortName;
    private byte isMobileVisibility;
    private Set<SdServiceReqMaster> sdServiceReqMasters = new HashSet<SdServiceReqMaster>(0);

    public SdService() {
    }

    public SdService(Integer id) {
        this.serviceId = id;
    }

    public SdService(SdProjectMaster sdProjectMaster, String serviceName, int status, String defaultImageName, String shortName, byte isMobileVisibility) {
        this.sdProjectMaster = sdProjectMaster;
        this.serviceName = serviceName;
        this.status = status;
        this.defaultImageName = defaultImageName;
        this.shortName = shortName;
        this.isMobileVisibility = isMobileVisibility;
    }

    public SdService(SdProjectMaster sdProjectMaster, String serviceName, String serviceDescription, int status, String defaultImageName, String shortName, byte isMobileVisibility, Set<SdServiceReqMaster> sdServiceReqMasters) {
        this.sdProjectMaster = sdProjectMaster;
        this.serviceName = serviceName;
        this.serviceDescription = serviceDescription;
        this.status = status;
        this.defaultImageName = defaultImageName;
        this.shortName = shortName;
        this.isMobileVisibility = isMobileVisibility;
        this.sdServiceReqMasters = sdServiceReqMasters;
    }

    public SdService(SdProjectMaster sdProjectMaster, String serviceName, String serviceDescription, int status, String defaultImageName, String shortName, byte isMobileVisibility) {
        this.sdProjectMaster = sdProjectMaster;
        this.serviceName = serviceName;
        this.serviceDescription = serviceDescription;
        this.status = status;
        this.defaultImageName = defaultImageName;
        this.shortName = shortName;
        this.isMobileVisibility = isMobileVisibility;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="ServiceID", unique=true, nullable=false)
    public Integer getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(Integer serviceId) {
        this.serviceId = serviceId;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ProjectID", nullable=false)
    public SdProjectMaster getSdProjectMaster() {
        return this.sdProjectMaster;
    }

    public void setSdProjectMaster(SdProjectMaster sdProjectMaster) {
        this.sdProjectMaster = sdProjectMaster;
    }

    @Column(name="ServiceName", nullable=false, length=256)
    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Column(name="ServiceDescription", length=5500)
    public String getServiceDescription() {
        return this.serviceDescription;
    }

    public void setServiceDescription(String serviceDescription) {
        this.serviceDescription = serviceDescription;
    }

    @Column(name="Status", nullable=false)
    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    @Column(name="DefaultImageName", nullable=false, length=1024)
    public String getDefaultImageName() {
        return this.defaultImageName;
    }

    public void setDefaultImageName(String defaultImageName) {
        this.defaultImageName = defaultImageName;
    }

    @Column(name="ShortName", nullable=false, length=256)
    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    @Column(name="IsMobileVisibility", nullable=false)
    public byte getIsMobileVisibility() {
        return this.isMobileVisibility;
    }

    public void setIsMobileVisibility(byte isMobileVisibility) {
        this.isMobileVisibility = isMobileVisibility;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="sdService")
    public Set<SdServiceReqMaster> getSdServiceReqMasters() {
        return this.sdServiceReqMasters;
    }

    public void setSdServiceReqMasters(Set<SdServiceReqMaster> sdServiceReqMasters) {
        this.sdServiceReqMasters = sdServiceReqMasters;
    }
}

