/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.model;

import com.sapphireims.itsm.dto.SdServicerequestHistoryDTO;
import com.sapphireims.itsm.model.SdServiceReqMaster;
import com.sapphireims.model.BaseModel;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;

@Entity
@Table(name="sd_servicerequest_history")
public class SdServicerequestHistory
extends BaseModel {
    private static final long serialVersionUID = -648251949988499451L;
    private Integer historyId;
    private SdServiceReqMaster sdServicereqmaster;
    private Date currentTime;
    private String natureOfChange;
    private String actionPerformedBy;
    private String oldValue;
    private String newValue;
    private String parameter;
    private int fieldid;
    private int childOf;
    private int oldStateId;
    private int newStateId;
    private Integer userid;
    private int access;
    private String latitude;
    private String longitude;

    private SdServicerequestHistory(Builder builder) {
        this.historyId = builder.historyId;
        this.sdServicereqmaster = builder.sdServicereqmaster;
        this.currentTime = builder.currentTime;
        this.natureOfChange = builder.natureOfChange;
        this.actionPerformedBy = builder.actionPerformedBy;
        this.oldValue = builder.oldValue;
        this.newValue = builder.newValue;
        this.parameter = builder.parameter;
        this.fieldid = builder.fieldid;
        this.childOf = builder.childOf;
        this.oldStateId = builder.oldStateId;
        this.newStateId = builder.newStateId;
        this.userid = builder.userid;
        this.access = builder.access;
        this.latitude = builder.latitude;
        this.longitude = builder.longitude;
    }

    public SdServicerequestHistory() {
    }

    public SdServicerequestHistory(SdServiceReqMaster sdServicereqmaster, Date currentTime, String natureOfChange, String actionPerformedBy, String oldValue, String newValue, String parameter, int fieldid, int childOf, int oldStateId, int newStateId) {
        this.sdServicereqmaster = sdServicereqmaster;
        this.currentTime = currentTime;
        this.natureOfChange = natureOfChange;
        this.actionPerformedBy = actionPerformedBy;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.parameter = parameter;
        this.fieldid = fieldid;
        this.childOf = childOf;
        this.oldStateId = oldStateId;
        this.newStateId = newStateId;
    }

    public SdServicerequestHistory(SdServiceReqMaster sdServicereqmaster, Date currentTime, String natureOfChange, String actionPerformedBy, String oldValue, String newValue, String parameter, int fieldid, int childOf, int oldStateId, int newStateId, Integer userid) {
        this.sdServicereqmaster = sdServicereqmaster;
        this.currentTime = currentTime;
        this.natureOfChange = natureOfChange;
        this.actionPerformedBy = actionPerformedBy;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.parameter = parameter;
        this.fieldid = fieldid;
        this.childOf = childOf;
        this.oldStateId = oldStateId;
        this.newStateId = newStateId;
        this.userid = userid;
    }

    public SdServicerequestHistory(SdServicerequestHistoryDTO h, SdServiceReqMaster sdServicereqmaster) {
        this.sdServicereqmaster = sdServicereqmaster;
        this.currentTime = new Date();
        this.natureOfChange = h.getNatureOfChange();
        this.actionPerformedBy = h.getActionPerformedBy();
        this.oldValue = h.getOldState() != null ? h.getOldState().getName() : h.getOldValue();
        this.newValue = h.getNewState() != null ? h.getNewState().getName() : h.getNewValue();
        this.parameter = h.getParameter();
        this.fieldid = h.getFieldid();
        this.childOf = h.getChildOf();
        this.oldStateId = h.getOldState() != null ? h.getOldState().getId() : 0;
        this.newStateId = h.getNewState() != null ? h.getNewState().getId() : 0;
        this.userid = sdServicereqmaster.getProxySubmittedBy() != 0 ? Integer.valueOf(sdServicereqmaster.getSubmittedBy()) : h.getUserid();
        this.latitude = h.getLatitude() != null ? h.getLatitude() : "";
        this.longitude = h.getLongitude() != null ? h.getLongitude() : "";
    }

    public SdServicerequestHistory(SdServicerequestHistoryDTO h, SdServiceReqMaster sdServicereqmaster, int childOf) {
        this.sdServicereqmaster = sdServicereqmaster;
        this.currentTime = new Date();
        this.natureOfChange = h.getNatureOfChange();
        this.actionPerformedBy = h.getActionPerformedBy();
        this.oldValue = h.getOldState() != null ? h.getOldState().getName() : h.getOldValue();
        this.newValue = h.getNewState() != null ? h.getNewState().getName() : h.getNewValue();
        this.parameter = h.getParameter();
        this.fieldid = h.getFieldid();
        this.childOf = 1;
        this.oldStateId = h.getOldState() != null ? h.getOldState().getId() : 0;
        this.newStateId = h.getNewState() != null ? h.getNewState().getId() : 0;
        this.userid = h.getUserid();
        this.childOf = childOf;
    }

    public SdServicerequestHistory(SdServiceReqMaster sdServicereqmaster, Date currentTime, String natureOfChange, String actionPerformedBy, String oldValue, String newValue, String parameter, int fieldid, int childOf, int oldStateId, int newStateId, Integer userid, int access, String latitude, String longitude) {
        this.sdServicereqmaster = sdServicereqmaster;
        this.currentTime = currentTime;
        this.natureOfChange = natureOfChange;
        this.actionPerformedBy = actionPerformedBy;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.parameter = parameter;
        this.fieldid = fieldid;
        this.childOf = childOf;
        this.oldStateId = oldStateId;
        this.newStateId = newStateId;
        this.userid = userid;
        this.access = access;
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public SdServicerequestHistory(SdServiceReqMaster sdServicereqmaster, Date currentTime, String natureOfChange, String actionPerformedBy, String oldValue, String newValue, String parameter, Integer userid) {
        this.sdServicereqmaster = sdServicereqmaster;
        this.currentTime = currentTime;
        this.natureOfChange = natureOfChange;
        this.actionPerformedBy = actionPerformedBy;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.parameter = parameter;
        this.userid = userid;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="HistoryID", unique=true, nullable=false)
    public Integer getHistoryId() {
        return this.historyId;
    }

    public void setHistoryId(Integer historyId) {
        this.historyId = historyId;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ProblemId", nullable=false)
    public SdServiceReqMaster getSdServicereqmaster() {
        return this.sdServicereqmaster;
    }

    public void setSdServicereqmaster(SdServiceReqMaster sdServicereqmaster) {
        this.sdServicereqmaster = sdServicereqmaster;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="CurrentTime", nullable=false, length=19)
    public Date getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(Date currentTime) {
        this.currentTime = currentTime;
    }

    @Column(name="NatureOfChange", nullable=false)
    public String getNatureOfChange() {
        return this.natureOfChange;
    }

    public void setNatureOfChange(String natureOfChange) {
        this.natureOfChange = natureOfChange;
    }

    @Column(name="ActionPerformedBy", nullable=false)
    public String getActionPerformedBy() {
        return this.actionPerformedBy;
    }

    public void setActionPerformedBy(String actionPerformedBy) {
        this.actionPerformedBy = actionPerformedBy;
    }

    @Column(name="OldValue", nullable=false, length=5120)
    public String getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(String oldValue) {
        this.oldValue = oldValue;
    }

    @Column(name="NewValue", nullable=false, length=5120)
    public String getNewValue() {
        return this.newValue;
    }

    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    @Column(name="Parameter", nullable=false)
    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    @Column(name="FIELDID", nullable=false)
    public int getFieldid() {
        return this.fieldid;
    }

    public void setFieldid(int fieldid) {
        this.fieldid = fieldid;
    }

    @Column(name="ChildOf", nullable=false)
    public int getChildOf() {
        return this.childOf;
    }

    public void setChildOf(int childOf) {
        this.childOf = childOf;
    }

    @Column(name="OldStateID", nullable=false)
    public int getOldStateId() {
        return this.oldStateId;
    }

    public void setOldStateId(int oldStateId) {
        this.oldStateId = oldStateId;
    }

    @Column(name="NewStateID", nullable=false)
    public int getNewStateId() {
        return this.newStateId;
    }

    public void setNewStateId(int newStateId) {
        this.newStateId = newStateId;
    }

    @Column(name="userid")
    public Integer getUserid() {
        return this.userid;
    }

    public void setUserid(Integer userid) {
        this.userid = userid;
    }

    @Column(name="access")
    public int getAccess() {
        return this.access;
    }

    public void setAccess(int access) {
        this.access = access;
    }

    @Column(name="latitude")
    public String getLatitude() {
        return this.latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    @Column(name="longitude")
    public String getLongitude() {
        return this.longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer historyId;
        private SdServiceReqMaster sdServicereqmaster;
        private Date currentTime;
        private String natureOfChange;
        private String actionPerformedBy;
        private String oldValue;
        private String newValue;
        private String parameter;
        private int fieldid;
        private int childOf;
        private int oldStateId;
        private int newStateId;
        private Integer userid;
        private int access;
        private String latitude;
        private String longitude;

        private Builder() {
        }

        public Builder withHistoryId(Integer historyId) {
            this.historyId = historyId;
            return this;
        }

        public Builder withSdServicereqmaster(SdServiceReqMaster sdServicereqmaster) {
            this.sdServicereqmaster = sdServicereqmaster;
            return this;
        }

        public Builder withCurrentTime(Date currentTime) {
            this.currentTime = currentTime;
            return this;
        }

        public Builder withNatureOfChange(String natureOfChange) {
            this.natureOfChange = natureOfChange;
            return this;
        }

        public Builder withActionPerformedBy(String actionPerformedBy) {
            this.actionPerformedBy = actionPerformedBy;
            return this;
        }

        public Builder withOldValue(String oldValue) {
            this.oldValue = oldValue;
            return this;
        }

        public Builder withNewValue(String newValue) {
            this.newValue = newValue;
            return this;
        }

        public Builder withParameter(String parameter) {
            this.parameter = parameter;
            return this;
        }

        public Builder withFieldid(int fieldid) {
            this.fieldid = fieldid;
            return this;
        }

        public Builder withChildOf(int childOf) {
            this.childOf = childOf;
            return this;
        }

        public Builder withOldStateId(int oldStateId) {
            this.oldStateId = oldStateId;
            return this;
        }

        public Builder withNewStateId(int newStateId) {
            this.newStateId = newStateId;
            return this;
        }

        public Builder withUserid(Integer userid) {
            this.userid = userid;
            return this;
        }

        public Builder withAccess(Integer access) {
            this.access = access;
            return this;
        }

        public Builder withLatitude(String latitude) {
            this.latitude = latitude;
            return this;
        }

        public Builder withLongitude(String longitude) {
            this.longitude = longitude;
            return this;
        }

        public SdServicerequestHistory build() {
            return new SdServicerequestHistory(this);
        }
    }
}

