/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.model;

import com.sapphire.itsm.mailrouting.model.SdProjectMaster;
import com.sapphireims.itsm.dto.SdTemplateDTO;
import com.sapphireims.itsm.model.enummodel.TemplateType;
import com.sapphireims.model.BaseModel;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;

@Entity
@Table(name="sd_template")
public class SdTemplate
extends BaseModel {
    private static final long serialVersionUID = 4635663595097657283L;
    private Integer id;
    private String name;
    private String template;
    private TemplateType type;
    private SdProjectMaster sdProjectMaster;
    private String attachmentName;
    private int assetModuleId;
    private int isCMDB;

    public SdTemplate() {
    }

    public SdTemplate(Integer id, String name, String template, TemplateType type, SdProjectMaster sdProjectMaster, String attachmentName) {
        this.id = id;
        this.name = name;
        this.template = template;
        this.type = type;
        this.sdProjectMaster = sdProjectMaster;
        this.attachmentName = attachmentName;
    }

    public void setTemplateForUpdtae(SdTemplateDTO dto, SdProjectMaster project) {
        this.id = dto.getId();
        this.name = dto.getName();
        this.template = dto.getTemplate();
        this.type = dto.getType();
        this.sdProjectMaster = project;
        this.attachmentName = dto.getAttachmentName();
    }

    public SdTemplate(String name, String template, TemplateType type, String attachmentName, SdProjectMaster sdProjectMaster) {
        this.name = name;
        this.template = template;
        this.type = type;
        this.sdProjectMaster = sdProjectMaster;
        this.attachmentName = attachmentName;
    }

    public SdTemplate(SdTemplateDTO dto, SdProjectMaster project) {
        this.id = dto.getId();
        this.name = dto.getName();
        this.template = dto.getTemplate();
        this.type = dto.getType();
        this.sdProjectMaster = project;
        this.attachmentName = dto.getAttachmentName();
    }

    public SdTemplate(String name, String template, TemplateType type, String attachmentName, SdProjectMaster sdProjectMaster, int assetModuleId, int isCMDB) {
        this.name = name;
        this.template = template;
        this.type = type;
        this.sdProjectMaster = sdProjectMaster;
        this.attachmentName = attachmentName;
        this.assetModuleId = assetModuleId;
        this.isCMDB = isCMDB;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", unique=true, nullable=false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Column(name="name", nullable=false)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="template", nullable=false)
    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    @Column(name="type", nullable=false, length=50)
    @Enumerated(value=EnumType.STRING)
    public TemplateType getType() {
        return this.type;
    }

    public void setType(TemplateType type) {
        this.type = type;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="project_id")
    public SdProjectMaster getSdProjectMaster() {
        return this.sdProjectMaster;
    }

    public void setSdProjectMaster(SdProjectMaster sdProjectMaster) {
        this.sdProjectMaster = sdProjectMaster;
    }

    @Column(name="attachment_name")
    public String getAttachmentName() {
        return this.attachmentName;
    }

    public void setAttachmentName(String attachmentName) {
        this.attachmentName = attachmentName;
    }

    @Column(name="assetModuleId", nullable=false)
    public int getAssetModuleId() {
        return this.assetModuleId;
    }

    public void setAssetModuleId(int assetModuleId) {
        this.assetModuleId = assetModuleId;
    }

    @Column(name="isCMDB", nullable=false)
    public int getIsCMDB() {
        return this.isCMDB;
    }

    public void setIsCMDB(int isCMDB) {
        this.isCMDB = isCMDB;
    }
}

