/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.service.impl;

import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.itsm.dao.ISdCategorymasterDAO;
import com.sapphireims.itsm.dto.SdCategoryDTO;
import com.sapphireims.itsm.dto.SdCategoryMasterDTO;
import com.sapphireims.itsm.dto.projectcopy.ProjectDTO;
import com.sapphireims.itsm.mindto.CategoryMinDTO;
import com.sapphireims.itsm.model.SdCategorymaster;
import com.sapphireims.itsm.service.ICategoryService;
import com.sapphireims.itsm.service.ISdProjectMasterService;
import com.sapphireims.util.CollectionUtil;
import com.sapphireims.util.Validate;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CategoryService
implements ICategoryService {
    @Value(value="${cache.metadata}")
    private boolean cache;
    @Autowired
    private ISdProjectMasterService projectMasterService;
    @Autowired
    private ISdCategorymasterDAO categorymasterDAO;

    @Override
    @Transactional(readOnly=true)
    public SdCategoryMasterDTO getCategoryById(Integer categoryId, Integer projectId) throws DomainException, ValidationException {
        if (!this.cache) {
            SdCategorymaster category = (SdCategorymaster)this.categorymasterDAO.get(categoryId);
            if (category != null) {
                return new SdCategoryMasterDTO(category);
            }
            throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "No Catagory Exist for id " + categoryId);
        }
        ProjectDTO project = this.projectMasterService.getProjectMetaData(projectId);
        Validate.notNull((Object)((Object)project), (String)"Invalid Project Id %s ", (Object[])new Object[]{projectId});
        return project.getCategoryById(categoryId);
    }

    @Override
    @Transactional(readOnly=true)
    public SdCategoryMasterDTO getCategoryByName(String categoryName, Integer projectId) throws DomainException, ValidationException {
        if (!this.cache) {
            SdCategorymaster category = this.categorymasterDAO.getCategoryByName(categoryName, projectId);
            if (category != null) {
                return new SdCategoryMasterDTO(category);
            }
            throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "No Catagory Exist for name  " + categoryName);
        }
        ProjectDTO project = this.projectMasterService.getProjectMetaData(projectId);
        Validate.notNull((Object)((Object)project), (String)"Invalid Project Id %s ", (Object[])new Object[]{projectId});
        return project.getCategoryByName(categoryName);
    }

    @Override
    @Transactional(readOnly=true)
    public CategoryMinDTO getMinCategoryById(Integer categoryId, Integer projectId) throws DomainException, ValidationException {
        if (!this.cache) {
            SdCategorymaster category = (SdCategorymaster)this.categorymasterDAO.get(categoryId);
            if (category != null) {
                SdCategoryMasterDTO dto = new SdCategoryMasterDTO(category);
                return new CategoryMinDTO(dto.getCategoryId(), dto.getCategoryName());
            }
            throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "No Category Exist for id " + categoryId);
        }
        ProjectDTO project = this.projectMasterService.getProjectMetaData(projectId);
        Validate.notNull((Object)((Object)project), (String)("Invalid Project Id " + projectId), (Object[])new Object[0]);
        SdCategoryMasterDTO dto = project.getCategoryById(categoryId);
        return new CategoryMinDTO(dto.getCategoryId(), dto.getCategoryName());
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdCategoryMasterDTO> getSdCategoryByProjectId(Integer projectId, Integer pageNo, Integer pageSize) throws DomainException, ValidationException {
        List<SdCategorymaster> category = this.categorymasterDAO.getSdCategoryMasterByProjectId(projectId, pageNo, pageSize);
        if (category != null) {
            ArrayList<SdCategoryMasterDTO> sdCategoryMasterDTOS = new ArrayList<SdCategoryMasterDTO>();
            for (SdCategorymaster sdCategorymaster : category) {
                sdCategoryMasterDTOS.add(new SdCategoryMasterDTO(sdCategorymaster));
            }
            return sdCategoryMasterDTOS;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "Project id is not valid " + projectId);
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdCategoryMasterDTO> getSdCategoryByProjectId(int projectId) throws DomainException, ValidationException {
        if (!this.cache) {
            List<SdCategorymaster> category = this.categorymasterDAO.getSdCategorymasterByProjectId(projectId);
            if (category != null) {
                ArrayList<SdCategoryMasterDTO> sdCategorymaster = new ArrayList<SdCategoryMasterDTO>();
                for (SdCategorymaster categorymaster : category) {
                    sdCategorymaster.add(new SdCategoryMasterDTO(categorymaster));
                }
                return sdCategorymaster;
            }
            throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "Project id is not valid " + projectId);
        }
        ProjectDTO project = this.projectMasterService.getProjectMetaData(projectId);
        Validate.notNull((Object)((Object)project), (String)"Invalid Project Id %s ", (Object[])new Object[]{projectId});
        List<SdCategoryMasterDTO> sdCategoryMasterDTOS = project.getSdCategoryMasters();
        if (sdCategoryMasterDTOS != null) {
            return sdCategoryMasterDTOS;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "Project id is Deactivated " + projectId);
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdCategoryMasterDTO> getCategoryNameByWorkgroupId(int workGroupID) throws DomainException, ValidationException {
        List<SdCategorymaster> category = this.categorymasterDAO.getCategoryNameByWorkgroupId(workGroupID);
        if (category != null) {
            ArrayList<SdCategoryMasterDTO> SdCategoryMasterDTOList = new ArrayList<SdCategoryMasterDTO>();
            for (SdCategorymaster sdCategory : category) {
                SdCategoryMasterDTOList.add(new SdCategoryMasterDTO(sdCategory));
            }
            return SdCategoryMasterDTOList;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "workGroup id is not valid " + workGroupID);
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdCategoryMasterDTO> getCategoryListByCategory(List<Integer> categoryIDs) throws DomainException, ValidationException {
        List<SdCategorymaster> category = this.categorymasterDAO.getCategoryListByCategory(categoryIDs);
        if (category != null) {
            ArrayList<SdCategoryMasterDTO> SdCategoryMasterDTOList = new ArrayList<SdCategoryMasterDTO>();
            for (SdCategorymaster sdCategory : category) {
                SdCategoryMasterDTOList.add(new SdCategoryMasterDTO(sdCategory));
            }
            return SdCategoryMasterDTOList;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "category id is not valid " + String.valueOf(categoryIDs));
    }

    @Override
    @Transactional(readOnly=true)
    public List<CategoryMinDTO> getSdCategorymasterByProjectIdAndService(Integer projectId, String serviceIds) throws DomainException, ValidationException {
        List<CategoryMinDTO> category = this.categorymasterDAO.getSdCategorymasterByProjectIdAndService(projectId, serviceIds);
        if (CollectionUtil.isNotEmpty(category)) {
            return category;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "service id is not valid " + serviceIds);
    }

    @Override
    @Transactional(readOnly=true)
    public SdCategorymaster getCategoryListByName(String categoryName, Integer id) throws DomainException, ValidationException {
        SdCategorymaster category = this.categorymasterDAO.getCategoryByName(categoryName, id);
        if (category != null) {
            return category;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "category Name is not valid " + categoryName);
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdCategoryMasterDTO> getCategoryByProjectId(Integer projectId) throws DomainException, ValidationException {
        List<SdCategorymaster> category = this.categorymasterDAO.getCategoryByProjectId(projectId);
        if (CollectionUtil.isNotEmpty(category)) {
            ArrayList<SdCategoryMasterDTO> SdCategoryMasterDTOList = new ArrayList<SdCategoryMasterDTO>();
            for (SdCategorymaster sdCategory : category) {
                SdCategoryMasterDTOList.add(new SdCategoryMasterDTO(sdCategory));
            }
            return SdCategoryMasterDTOList;
        }
        return null;
    }

    @Override
    @Transactional(readOnly=true)
    public List<CategoryMinDTO> getSdCategorymasterByProjectIdAndService(Integer projectId) throws DomainException, ValidationException {
        List<CategoryMinDTO> category = this.categorymasterDAO.getSdCategorymasterByProjectIdAndService(projectId);
        if (CollectionUtil.isNotEmpty(category)) {
            return category;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY);
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdCategoryDTO> getSortedCategoryByProjectId(Integer projectId, Integer pageNo, Integer pageSize, String sortColumn, String sortDir) throws DomainException, ValidationException {
        List<SdCategoryDTO> sdCategoryDTOList = this.categorymasterDAO.getSortedCategoryRecordsByProject(projectId, pageNo, pageSize, sortColumn, sortDir);
        if (sdCategoryDTOList != null) {
            return sdCategoryDTOList;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "Project id is not valid " + projectId);
    }
}

