/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.service.impl;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.sapphireims.dao.rpa.IRpaProcessRepository;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.itsm.dto.cache.ClientProjectCache;
import com.sapphireims.itsm.dto.projectcopy.ProjectDTO;
import com.sapphireims.itsm.service.IClientProjectCacheService;
import com.sapphireims.itsm.service.ISdProjectMasterService;
import com.sapphireims.model.rpa.ProcessType;
import com.sapphireims.model.rpa.RpaProcess;
import com.sapphireims.util.Validate;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ClientProjectCacheService
implements IClientProjectCacheService {
    @Autowired
    private ISdProjectMasterService projectMasterService;
    @Autowired
    private IRpaProcessRepository rpaProcessRepository;

    @Override
    @Transactional(readOnly=true)
    public ClientProjectCache getCache(Integer projectId) throws DomainException, ValidationException {
        ProjectDTO project = this.projectMasterService.getProjectMetaData(projectId);
        List<RpaProcess> process = this.rpaProcessRepository.getProessForProject(projectId, ProcessType.DMN);
        Validate.notNull((Object)((Object)project), (String)" Invalid Project Id %s ", (Object[])new Object[]{projectId});
        return new ClientProjectCache(project, process);
    }

    @Override
    public ProjectDTO getCacheProjectDTO(Integer projectId) throws DomainException, ValidationException {
        ProjectDTO project = this.projectMasterService.getProjectMetaData(projectId);
        return project;
    }

    @Override
    public ProjectDTO getCacheFilteredProjectDTO(Integer projectId, List<String> filterProperties) throws DomainException, ValidationException, IllegalAccessException {
        ProjectDTO project = this.projectMasterService.getProjectMetaData(projectId);
        Set<String> uniqueProperty = filterProperties.stream().collect(Collectors.toSet());
        return this.getFilteredProjectDTO(project, uniqueProperty);
    }

    private ProjectDTO getFilteredProjectDTO(ProjectDTO project, Set<String> userRequestedJsonProperties) throws IllegalAccessException {
        ProjectDTO filteredProjectDTO = new ProjectDTO();
        for (Field field : ((Object)((Object)project)).getClass().getDeclaredFields()) {
            JsonProperty jsonProperty;
            String jsonPropertyName;
            if (!field.isAnnotationPresent(JsonProperty.class) || !userRequestedJsonProperties.contains(jsonPropertyName = (jsonProperty = field.getAnnotation(JsonProperty.class)).value())) continue;
            field.setAccessible(true);
            Object fieldValue = field.get((Object)project);
            field.set((Object)filteredProjectDTO, fieldValue);
        }
        return filteredProjectDTO;
    }
}

