/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.service.impl;

import com.sapphireims.itsm.dto.CreateDirectoriesDTO;
import com.sapphireims.itsm.service.ICopyAndCompressFilesService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class CopyAndCompressFilesService
implements ICopyAndCompressFilesService {
    private String createdDirectoryPath;

    @Override
    public void createModuleCopyDirectories(CreateDirectoriesDTO cdDTO, String templateName) {
        File fileTo = new File(".");
        String webMgmtLocation = fileTo.getAbsolutePath().substring(0, fileTo.getAbsolutePath().length() - 5);
        StringBuilder fileLoc = new StringBuilder(webMgmtLocation);
        List<String> paths = cdDTO.getAll();
        if (!paths.isEmpty()) {
            paths.stream().filter(dirName -> dirName != null).filter(dirName -> !dirName.equals("")).forEach(dirName -> {
                fileLoc.append((String)dirName).append("\\");
                Path path = Paths.get(fileLoc.toString(), new String[0]);
                if (!Files.exists(path, new LinkOption[0])) {
                    try {
                        Files.createDirectories(path, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            if (!templateName.isEmpty()) {
                fileLoc.append(templateName);
                Path path = Paths.get(fileLoc.toString(), new String[0]);
                if (!Files.exists(path, new LinkOption[0])) {
                    try {
                        Files.createDirectories(path, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.createdDirectoryPath = fileLoc.toString();
    }

    @Override
    public String getDestinationDirectoryPath() {
        return this.createdDirectoryPath;
    }
}

