/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.service.impl;

import com.sapphire.itsm.mailrouting.model.SdSettingoperationHistory;
import com.sapphire.itsm.mailrouting.model.SdSettingsModules;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.itsm.dao.ISdDependentMasterDAO;
import com.sapphireims.itsm.dao.ISdOnactionDAO;
import com.sapphireims.itsm.dao.ISdSettingoperationHistoryDAO;
import com.sapphireims.itsm.dao.ISdSettingsModulesDAO;
import com.sapphireims.itsm.dto.SdDependentMasterDTO;
import com.sapphireims.itsm.dto.SdOnactionDTO;
import com.sapphireims.itsm.dto.SdSettingoperationHistoryDTO;
import com.sapphireims.itsm.dto.projectcopy.ProjectDTO;
import com.sapphireims.itsm.model.SdDependentMaster;
import com.sapphireims.itsm.model.SdOnaction;
import com.sapphireims.itsm.service.IDependentMasterServcie;
import com.sapphireims.itsm.service.ISdProjectMasterService;
import com.sapphireims.util.CollectionUtil;
import com.sapphireims.util.Validate;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DependentMasterServcie
implements IDependentMasterServcie {
    @Value(value="${cache.metadata}")
    private boolean cache;
    @Autowired
    private ISdProjectMasterService projectMasterService;
    @Autowired
    private ISdDependentMasterDAO sdDependentMasterDAO;
    @Autowired
    private ISdOnactionDAO sdOnactionDAO;
    @Autowired
    private ISdSettingsModulesDAO sdSettingsModulesDAO;
    @Autowired
    private ISdSettingoperationHistoryDAO sdSettingoperationHistoryDAO;

    @Override
    @Transactional(readOnly=true)
    public Integer checkDuplicateDerivedField(String derivedFieldName, Integer projectId, byte derivedFieldType, Integer derivedFieldId) throws DomainException, ValidationException {
        return this.sdDependentMasterDAO.checkDuplicateDerivedField(derivedFieldName, projectId, derivedFieldType, derivedFieldId);
    }

    @Override
    @Transactional(readOnly=true)
    public SdDependentMasterDTO getDependentMasterById(int dependentMasterId, int projectId) throws DomainException, ValidationException {
        if (!this.cache) {
            SdDependentMaster m = (SdDependentMaster)this.sdDependentMasterDAO.get(Integer.valueOf(dependentMasterId));
            if (m != null) {
                return new SdDependentMasterDTO(m);
            }
            throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "Dependent Master Not exist " + dependentMasterId);
        }
        ProjectDTO project = this.projectMasterService.getProjectMetaData(projectId);
        Validate.notNull((Object)((Object)project), (String)"Invalid Project Id %s ", (Object[])new Object[]{projectId});
        return project.getDependentMasterById(dependentMasterId);
    }

    @Override
    @Transactional(readOnly=true)
    public SdDependentMasterDTO getDependentMasterByName(String dependentMasterName, int projectId) throws DomainException, ValidationException {
        if (!this.cache) {
            SdDependentMaster m = this.sdDependentMasterDAO.getByName(dependentMasterName, projectId);
            if (m != null) {
                return new SdDependentMasterDTO(m);
            }
            throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "Dependent Master Not exist " + dependentMasterName);
        }
        ProjectDTO project = this.projectMasterService.getProjectMetaData(projectId);
        Validate.notNull((Object)((Object)project), (String)"Invalid Project Id %s", (Object[])new Object[]{projectId});
        return project.getDependentMasterByName(dependentMasterName);
    }

    @Override
    @Transactional
    public void saveSdDependentField(SdDependentMasterDTO dependentDto) throws ValidationException, DomainException {
        dependentDto.validate();
        SdDependentMaster dependentField = new SdDependentMaster(dependentDto.getModuleId(), dependentDto.getDependentFieldName(), 0, dependentDto.getShortname());
        this.sdDependentMasterDAO.save(dependentField);
        dependentDto.setDependentFieldId(dependentField.getDependentFieldId());
        if (dependentDto.getOnactionList() != null) {
            for (SdOnactionDTO onactionDto : dependentDto.getOnactionList()) {
                SdOnaction onaction = new SdOnaction(onactionDto.getModuleId(), onactionDto.getLoadOn(), dependentField.getDependentFieldId());
                this.sdOnactionDAO.save(onaction);
            }
        }
        if (dependentDto.getSdSettingoperationHistoryDTO() != null) {
            SdSettingoperationHistoryDTO historyDto = dependentDto.getSdSettingoperationHistoryDTO();
            SdSettingoperationHistory history = new SdSettingoperationHistory((SdSettingsModules)this.sdSettingsModulesDAO.get(Integer.valueOf(historyDto.getModuleId())), (int)dependentField.getDependentFieldId(), historyDto.getProjectId(), historyDto.getActivityTime(), historyDto.getActionPerformedBy(), historyDto.getIpAddress(), historyDto.getNatureOfChange(), historyDto.getParameter(), historyDto.getOldValue(), historyDto.getNewValue());
            this.sdSettingoperationHistoryDAO.save(history);
        }
        if (dependentDto.getSdSettingoperationHistoryDTOList() != null) {
            List<SdSettingoperationHistoryDTO> childHistoryList = dependentDto.getSdSettingoperationHistoryDTOList();
            for (SdSettingoperationHistoryDTO historyDto : childHistoryList) {
                SdSettingoperationHistory childHistory = new SdSettingoperationHistory((SdSettingsModules)this.sdSettingsModulesDAO.get(Integer.valueOf(historyDto.getModuleId())), (int)dependentField.getDependentFieldId(), historyDto.getProjectId(), historyDto.getActivityTime(), historyDto.getActionPerformedBy(), historyDto.getIpAddress(), historyDto.getNatureOfChange(), historyDto.getParameter(), historyDto.getOldValue(), historyDto.getNewValue());
                this.sdSettingoperationHistoryDAO.save(childHistory);
            }
        }
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdDependentMasterDTO> getDerivedFieldNameByWorkgroupId(Integer workGroupID, Integer workgroupType) throws DomainException, ValidationException {
        List<SdDependentMaster> derivedField = this.sdDependentMasterDAO.getDerivedFieldNameByWorkgroupId(workGroupID, workgroupType);
        if (derivedField != null) {
            ArrayList<SdDependentMasterDTO> SdDependentMasterDTOList = new ArrayList<SdDependentMasterDTO>();
            for (SdDependentMaster derived_Field : derivedField) {
                SdDependentMasterDTOList.add(new SdDependentMasterDTO(derived_Field));
            }
            return SdDependentMasterDTOList;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "workGroup id is not valid " + workGroupID);
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdDependentMasterDTO> getDependentListByDependentIds(List<Integer> dependentList) throws DomainException, ValidationException {
        List<SdDependentMaster> derivedFieldList = this.sdDependentMasterDAO.getDependentListByDependentIds(dependentList);
        if (derivedFieldList != null) {
            ArrayList<SdDependentMasterDTO> SdDependentMasterDTOList = new ArrayList<SdDependentMasterDTO>();
            for (SdDependentMaster derived_Field : derivedFieldList) {
                SdDependentMasterDTOList.add(new SdDependentMasterDTO(derived_Field));
            }
            return SdDependentMasterDTOList;
        }
        return null;
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdDependentMasterDTO> getDerivedFieldByProjectId(Integer projectId, Integer module1, Integer module2) throws DomainException, ValidationException {
        List<SdDependentMaster> derivedFieldList = this.sdDependentMasterDAO.getDerivedFieldByProjectId(projectId, module1, module2);
        if (derivedFieldList != null) {
            ArrayList<SdDependentMasterDTO> SdDependentMasterDTOList = new ArrayList<SdDependentMasterDTO>();
            for (SdDependentMaster derived_Field : derivedFieldList) {
                SdDependentMasterDTOList.add(new SdDependentMasterDTO(derived_Field));
            }
            return SdDependentMasterDTOList;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "project id is not valid " + projectId);
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdDependentMasterDTO> getDerivedFieldNameByDerivedFieldIds(List<Integer> derivedFieldIdList) throws DomainException, ValidationException {
        List<SdDependentMaster> derivedField = this.sdDependentMasterDAO.getDerivedFieldNameByDerivedFieldIds(derivedFieldIdList);
        if (CollectionUtil.isNotEmpty(derivedField)) {
            ArrayList<SdDependentMasterDTO> sdSubCategoryMasterDTOList = new ArrayList<SdDependentMasterDTO>();
            for (SdDependentMaster derivedFld : derivedField) {
                sdSubCategoryMasterDTOList.add(new SdDependentMasterDTO(derivedFld));
            }
            return sdSubCategoryMasterDTOList;
        }
        throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, "derivedFieldIdList id's is not valid " + String.valueOf(derivedFieldIdList));
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdDependentMasterDTO> getDependentMasters(byte moduleId) throws DomainException, ValidationException {
        List<SdDependentMaster> derivedField = this.sdDependentMasterDAO.getDependentMasters(moduleId);
        if (CollectionUtil.isNotEmpty(derivedField)) {
            ArrayList<SdDependentMasterDTO> sdSubCategoryMasterDTOList = new ArrayList<SdDependentMasterDTO>();
            for (SdDependentMaster derivedFld : derivedField) {
                sdSubCategoryMasterDTOList.add(new SdDependentMasterDTO(derivedFld));
            }
            return sdSubCategoryMasterDTOList;
        }
        return null;
    }

    @Override
    @Transactional(readOnly=true)
    public List<SdDependentMasterDTO> getDerivedFieldsByType(byte derivedFieldType, Integer pageNo, Integer pageSize, String columnSort, String sortDir) throws DomainException, ValidationException {
        List<SdDependentMaster> derivedFieldsRecords = this.sdDependentMasterDAO.getDerivedFieldsByType(derivedFieldType, pageNo, pageSize, columnSort, sortDir);
        if (CollectionUtil.isNotEmpty(derivedFieldsRecords)) {
            ArrayList<SdDependentMasterDTO> derivedFieldsRecordsList = new ArrayList<SdDependentMasterDTO>(derivedFieldsRecords.size());
            for (SdDependentMaster derivedField : derivedFieldsRecords) {
                derivedFieldsRecordsList.add(new SdDependentMasterDTO(derivedField));
            }
            return derivedFieldsRecordsList;
        }
        return null;
    }

    @Override
    @Transactional(readOnly=true)
    public SdDependentMaster getDerivedFieldById(Integer derivedFieldId) {
        return this.sdDependentMasterDAO.getDerivedFieldById(derivedFieldId);
    }
}

