/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.service.impl;

import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.itsm.dao.IGenericProcedureCallDAO;
import com.sapphireims.itsm.dto.SdProjectDetailsDTO;
import com.sapphireims.itsm.dto.projectcopy.ProjectExportRequestDTO;
import com.sapphireims.itsm.service.IGenericProcedureCallService;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GenericProcedureCallImplService
implements IGenericProcedureCallService {
    @Autowired
    private IGenericProcedureCallDAO genericProcedureCallDAO;

    @Override
    @Transactional
    public boolean importReports(ProjectExportRequestDTO req) throws DomainException, ValidationException {
        Optional<SdProjectDetailsDTO> spd = req.getpDto().getProjectDetails().stream().filter(o -> o.getParameterId() == 4).findFirst();
        if (spd != null) {
            String query = "";
            switch (Integer.parseInt(spd.get().getParameterValue())) {
                case 1: {
                    query = "CALL CreateServiceRequestReports(?)";
                    break;
                }
                case 2: 
                case 5: {
                    query = "CALL CreateIncidentManagementReports(?)";
                    break;
                }
                case 3: {
                    query = "CALL CreateProblemManagementReports(?)";
                    break;
                }
                case 4: {
                    query = "CALL CreateChangeRequestReports(?)";
                    break;
                }
            }
            if (Integer.parseInt(spd.get().getParameterValue()) != 6) {
                return this.genericProcedureCallDAO.importReports(query, req.getSdProjectMaster().getProjectId());
            }
        }
        return false;
    }

    @Override
    @Transactional
    public boolean importCustomInbuiltWidgets(ProjectExportRequestDTO req) throws DomainException, ValidationException {
        return this.genericProcedureCallDAO.importInbuiltCustomWidgets(req.getSdProjectMaster().getProjectId());
    }
}

