/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.service.impl;

import com.sapphireims.dto.SearchEntityResponce;
import com.sapphireims.dto.SearchRequestDTO;
import com.sapphireims.dto.SearchResultDTO;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.itsm.dao.ISdIntegrationConfigDAO;
import com.sapphireims.itsm.dao.ISdTemplateDAO;
import com.sapphireims.itsm.dto.integration.SdIntegrationConfigDTO;
import com.sapphireims.itsm.model.SdIntegrationConfig;
import com.sapphireims.itsm.model.SdTemplate;
import com.sapphireims.itsm.service.IIntegrationConfigService;
import com.sapphireims.model.BaseModel;
import com.sapphireims.util.CollectionUtil;
import com.sapphireims.util.Validate;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IntegrationConfigService
implements IIntegrationConfigService {
    @Autowired
    private ISdIntegrationConfigDAO integrationConfigDAO;
    @Autowired
    private ISdTemplateDAO sdTemplateDAO;

    @Override
    @Transactional
    public void saveIntegrationConfig(SdIntegrationConfigDTO config) throws DomainException, ValidationException {
        Validate.notNull((Object)((Object)config), (String)"Config Cant be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)config.getTemplate()), (String)"Templae can't be null", (Object[])new Object[0]);
        SdTemplate template = (SdTemplate)this.sdTemplateDAO.get(config.getTemplate().getId());
        Validate.notNull((Object)((Object)template), (String)"Invalid Template Id {}", (Object[])new Object[]{config.getTemplate().getId()});
        SdIntegrationConfig isExist = this.integrationConfigDAO.getConfigByProjectIdAndConfigName(config.getProjectId(), config.getIntegrationName());
        if (isExist != null) {
            throw new DomainException(DomainException.ErrorCode.DUPLICATE_ENTITY, "Intigration configa lrfedy exist  %s ", new Object[]{config.getIntegrationName()});
        }
        SdIntegrationConfig ic = SdIntegrationConfig.builder().withSdTemplate(template).withIntegrationName(config.getIntegrationName()).withIntegrationDescription(config.getIntegrationDescription()).withUrl(config.getUrl()).withHeader(config.getHeader()).withAuthHandler(config.getAuthHandler()).withResponseHandler(config.getResponseHandler()).withRequestHandler(config.getRequestHandler()).withAuthKey(config.getAuthKey()).withProjectId(config.getProjectId()).withHttpMethod(config.getHttpMethod()).withBodyType(config.getBodyType()).withIntegrationType(config.getIntegrationType()).build();
        this.integrationConfigDAO.save(ic);
    }

    @Override
    @Transactional(readOnly=true)
    public SearchResultDTO getIntegrationConfig(SearchRequestDTO searchR) throws ValidationException, DomainException {
        Validate.notNull((Object)searchR);
        Validate.notNull((Object)searchR.getProjectId(), (String)" Project Id is manditory", (Object[])new Object[0]);
        SearchEntityResponce templates = this.integrationConfigDAO.getIntegrationConfig(searchR);
        ArrayList<SdIntegrationConfigDTO> ret = null;
        if (CollectionUtil.isNotEmpty(templates.getData())) {
            ret = new ArrayList<SdIntegrationConfigDTO>(templates.getData().size());
            for (BaseModel t : templates.getData()) {
                ret.add(new SdIntegrationConfigDTO((SdIntegrationConfig)t));
            }
        }
        return new SearchResultDTO(searchR, templates.getTotalCount(), ret);
    }
}

