/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.service.impl;

import com.sapphire.itsm.mailrouting.dao.IMacromasterDAO;
import com.sapphire.itsm.mailrouting.dto.MacromasterDTO;
import com.sapphire.itsm.mailrouting.model.Macromaster;
import com.sapphireims.itsm.dto.TenantDTO;
import com.sapphireims.itsm.dto.projectcopy.ProjectExportRequestDTO;
import com.sapphireims.itsm.service.ICopyAndCompressFilesService;
import com.sapphireims.itsm.service.IMacroService;
import com.sapphireims.modulecopy.dto.ModuleCopyAttachmentsDTO;
import com.sapphireims.util.CollectionUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MacroService
implements IMacroService {
    @Value(value="${cache.metadata}")
    private boolean cacheMetaData;
    @Autowired
    private IMacromasterDAO macromasterDAO;
    @Autowired
    protected ICopyAndCompressFilesService copyAndCompressFilesService;

    @Override
    @Transactional
    public MacromasterDTO geMacromasterDTOById(Integer macroId) {
        if (this.cacheMetaData) {
            return this.geMacromasterDTOByIdFromCache(macroId);
        }
        Macromaster macro = (Macromaster)this.macromasterDAO.get(macroId);
        return new MacromasterDTO(macro);
    }

    @Override
    @Transactional
    @Cacheable(value={"Macromaster"})
    public MacromasterDTO geMacromasterDTOByIdFromCache(Integer macroId) {
        Macromaster macro = (Macromaster)this.macromasterDAO.get(macroId);
        if (macro != null) {
            MacromasterDTO dto = new MacromasterDTO(macro);
            return dto;
        }
        return null;
    }

    @Override
    public void exportAssetCreationMacroImage(ProjectExportRequestDTO pDTO) {
        ModuleCopyAttachmentsDTO mcaDTO = pDTO.getMcaDTO();
        if (pDTO.getTenant().getMapMacromasters() != null && pDTO.getTenant().getMapMacromasters().size() > 0) {
            for (Map.Entry<Integer, MacromasterDTO> entry : pDTO.getTenant().getMapMacromasters().entrySet()) {
                MacromasterDTO mmDTO = entry.getValue();
                if (mmDTO.getMacroHtmlType() != 19 || mmDTO.getMacroid() == 0 || mcaDTO == null) continue;
                Object customerAliasName = "";
                if (mcaDTO.getCustomerAliasName() != null && !mcaDTO.getCustomerAliasName().equals("")) {
                    customerAliasName = mcaDTO.getCustomerAliasName() + "\\";
                }
                String oldUIPath = mcaDTO.getWarFilePath() + "\\cmdb_images\\servicedesk\\" + (String)customerAliasName + "SD_MACRO_ASSETCREATION_" + mmDTO.getMacroid() + ".gif";
                String destinationPath = this.copyAndCompressFilesService.getDestinationDirectoryPath();
                try {
                    File oldUIFile = new File(oldUIPath);
                    if (!oldUIFile.exists() || oldUIFile.isDirectory()) continue;
                    FileUtils.copyFile((File)oldUIFile, (File)FileUtils.getFile((String[])new String[]{destinationPath + "\\SD_MACRO_ASSETCREATION_" + mmDTO.getMacroid() + ".gif"}));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    @Override
    public ProjectExportRequestDTO replaceAndUpdateMacroAttchmentFiles(ProjectExportRequestDTO req, TenantDTO tenant) {
        ModuleCopyAttachmentsDTO mcaDTO = req.getMcaDTO();
        if (mcaDTO != null) {
            Object customerAliasName = "";
            if (mcaDTO.getCustomerAliasName() != null && !mcaDTO.getCustomerAliasName().equals("")) {
                customerAliasName = "\\" + mcaDTO.getCustomerAliasName();
            }
            String sourcePath = mcaDTO.getWarFilePath() + "\\cmdb_images\\servicedesk" + (String)customerAliasName;
            String fileLoc = mcaDTO.getModulePath();
            if (CollectionUtil.isNotEmpty(tenant.getMacromasters())) {
                for (MacromasterDTO mDto : tenant.getMacromasters()) {
                    if (mDto.isPresentInDb()) continue;
                    Macromaster mmObject = tenant.getMapMacromastersEntity().get(mDto.getMacroid());
                    Integer oldAttachment = mDto.getMacroid();
                    File oldUIFromCopy = new File(fileLoc + "\\SD_MACRO_ASSETCREATION_" + oldAttachment + ".gif");
                    try {
                        if (!oldUIFromCopy.exists() || oldUIFromCopy.isDirectory()) continue;
                        String fileName = "SD_MACRO_ASSETCREATION_" + mmObject.getMacroid();
                        FileUtils.copyFile((File)oldUIFromCopy, (File)FileUtils.getFile((String[])new String[]{sourcePath + "\\" + fileName + ".gif"}));
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        return req;
    }
}

