/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.service.impl;

import com.sapphireims.itsm.service.IMaskingService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;

@Service
public class MaskingServiceImpl
implements IMaskingService {
    private static final Log logger = LogFactory.getLog((String)"ITSM.log");

    @Override
    public String applyPatternMask(String pattern, String input) {
        String maskedTextBoxValue = input;
        try {
            int patternLength = pattern.length();
            int inputLength = input.length();
            if (pattern.contains("-")) {
                String[] inputParts;
                String[] patternParts = pattern.split("-");
                if (patternParts.length == (inputParts = input.split("-")).length && patternLength == inputLength) {
                    StringBuilder maskedOutput = new StringBuilder();
                    for (int i = 0; i < patternParts.length; ++i) {
                        StringBuilder partOutput = new StringBuilder();
                        String patternPart = patternParts[i];
                        String inputPart = inputParts[i];
                        int partLength = patternPart.length();
                        for (int j = 0; j < partLength; ++j) {
                            char patternChar = patternPart.charAt(j);
                            char inputChar = inputPart.charAt(j);
                            if (patternChar == '*') {
                                partOutput.append(patternPart.charAt(j));
                                continue;
                            }
                            partOutput.append(inputChar);
                        }
                        maskedOutput.append((CharSequence)partOutput);
                        if (i >= patternParts.length - 1) continue;
                        maskedOutput.append("-");
                    }
                    maskedTextBoxValue = maskedOutput.toString();
                } else {
                    maskedTextBoxValue = input;
                }
            } else {
                StringBuilder maskedText = new StringBuilder();
                int patternIndex = 0;
                if (inputLength < patternLength) {
                    for (int i = 0; i < inputLength; ++i) {
                        char textBoxChar = input.charAt(i);
                        if (patternIndex >= patternLength) {
                            maskedText.append(textBoxChar);
                            continue;
                        }
                        char patternChar = pattern.charAt(patternIndex);
                        if (patternChar == '*') {
                            maskedText.append(patternChar);
                        } else {
                            maskedText.append(textBoxChar);
                        }
                        if (patternChar == '*') continue;
                        ++patternIndex;
                    }
                } else {
                    maskedText = new StringBuilder(input);
                    int prefix = pattern.indexOf("*");
                    int suffix = pattern.lastIndexOf("*");
                    String replaceStr = pattern.substring(prefix, suffix + 1);
                    maskedText.replace(prefix, suffix + 1, replaceStr).toString();
                }
                maskedTextBoxValue = maskedText.toString();
            }
        }
        catch (Exception e) {
            logger.error((Object)("MaskingServiceImpl :: (--Exception Caught--) occured in applyPatternMask " + e.getMessage()), (Throwable)e);
        }
        return maskedTextBoxValue;
    }
}

