/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.service.impl;

import com.sapphireims.dao.IHibernateRepositoryOperations;
import com.sapphireims.dto.DataSource;
import com.sapphireims.dto.MinMetaData;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.itsm.dao.IDepartmentMasterDAO;
import com.sapphireims.itsm.dao.ISdCategorymasterDAO;
import com.sapphireims.itsm.dao.ISdDependentMasterDAO;
import com.sapphireims.itsm.dao.ISdNotificationTemplateDAO;
import com.sapphireims.itsm.dao.ISdProjectRolesDAO;
import com.sapphireims.itsm.dao.ISdServiceDAO;
import com.sapphireims.itsm.dao.ISdSmsNotificationTemplateDAO;
import com.sapphireims.itsm.dao.ISdStatecategoryMasterDAO;
import com.sapphireims.itsm.dao.ISdStatesMasterDAO;
import com.sapphireims.itsm.dao.ISdSubcategorymasterDAO;
import com.sapphireims.itsm.dao.ISdUipMasterDAO;
import com.sapphireims.itsm.dao.ISdWorkgroupMasterDAO;
import com.sapphireims.itsm.dao.IServicedeskLocationMasterDAO;
import com.sapphireims.itsm.mindto.UserMgmtMasterMinDTO;
import com.sapphireims.itsm.model.enummodel.SdDTOEnum;
import com.sapphireims.itsm.service.IMinMetaDataService;
import com.sapphireims.util.Validate;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MinMetaDataService
implements IMinMetaDataService {
    private static final String PROJECT_ID_IS_MANDATORY = " Project Id is mandatory";
    @Autowired
    private ISdCategorymasterDAO sdCategorymasterDAO;
    @Autowired
    private ISdSubcategorymasterDAO sdSubcategorymasterDAO;
    @Autowired
    private ISdServiceDAO sdServiceDAO;
    @Autowired
    private ISdStatesMasterDAO sdStatesMasterDAO;
    @Autowired
    protected ISdUipMasterDAO sdUipMasterDAO;
    @Autowired
    private ISdProjectRolesDAO sdProjectRolesDAO;
    @Autowired
    protected IServicedeskLocationMasterDAO servicedeskLocationMasterDAO;
    @Autowired
    protected IDepartmentMasterDAO departmentMasterDAO;
    @Autowired
    protected ISdWorkgroupMasterDAO workgroupMasterDAO;
    @Autowired
    protected ISdStatecategoryMasterDAO sdStatecategoryMasterDAO;
    @Autowired
    protected ISdDependentMasterDAO sdDependentMasterDAO;
    @Autowired
    protected ISdNotificationTemplateDAO sdNotificationTemplateDAO;
    @Autowired
    @Qualifier(value="hibernateRepositoryOperations")
    protected IHibernateRepositoryOperations hibernateDaoOperations;
    @Autowired
    protected ISdSmsNotificationTemplateDAO sdSmsNotificationTemplateDAO;

    @Override
    @Transactional
    public MinMetaData getMetaData(DataSource datasource) throws ValidationException, DomainException {
        Validate.notNull((Object)datasource, (String)"Data Source can't Be empty", (Object[])new Object[0]);
        MinMetaData metadata = new MinMetaData(datasource);
        switch (datasource.getType()) {
            case ADDITIONAL_PARMS: {
                this.getAdditionalParms(metadata);
                break;
            }
            case CATEGORY: {
                this.getCategory(metadata);
                break;
            }
            case DEPENDENT_MASTER: {
                this.getDependentMaster(metadata);
                break;
            }
            case MACRO_MASTER: {
                this.getMacroMaster(metadata);
                break;
            }
            case PROJECT: {
                this.getProject(metadata);
                break;
            }
            case PROJECT_ROLES: {
                this.getProjectRoles(metadata);
                break;
            }
            case SERVICE: {
                this.getService(metadata);
                break;
            }
            case STATE: {
                this.getState(metadata);
                break;
            }
            case SUB_CATEGORY: {
                this.getSubCategory(metadata);
                break;
            }
            case WORK_GROUP: {
                this.getWorkGroup(metadata);
                break;
            }
            case SUB_CATEGORY_BASEDON_SERVICE: {
                this.getSubcategoryBasedOnService(metadata);
                break;
            }
            case STATE_CATEGORY: {
                this.getStateCategoryBasedOnProject(metadata);
                break;
            }
            case DEPENDENT_MASTER2: {
                this.getDependentMaster2(metadata);
                break;
            }
            case DEPENDENT_MASTER3: {
                this.getDependentMaster3(metadata);
                break;
            }
            case PROJECT_ROLES_BY_ROLENAME: {
                this.getSdProjectRolesByRoleName(metadata);
                break;
            }
            case SD_NOTIFICATION_TEMPLATE: {
                this.getSdNotificationTemplate(metadata);
                break;
            }
            case USER_DETAILS_BY_PROJECTROLES: {
                this.getUserMgmtMasterByProjectRoles(metadata);
                break;
            }
            case SMS_NOTIFICATION_TEMPLATE: {
                this.getSdSMSNotificationTemplate(metadata);
                break;
            }
            case PROJECT_ROLES_BY_WORKFLOW: {
                this.getSdProjectRolesByWorkflow(metadata);
                break;
            }
        }
        return metadata;
    }

    private void getWorkGroup(MinMetaData metadata) throws DomainException {
        if (metadata.getDatasource().getProjectid() == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, PROJECT_ID_IS_MANDATORY);
        }
        metadata.setData(this.workgroupMasterDAO.getWorkGroup(metadata.getDatasource()));
    }

    private void getSubCategory(MinMetaData metadata) throws DomainException {
        if (metadata.getDatasource().getProjectid() == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, PROJECT_ID_IS_MANDATORY);
        }
        metadata.setData(this.sdSubcategorymasterDAO.getSubCategory(metadata.getDatasource()));
    }

    private void getState(MinMetaData metadata) throws DomainException {
        if (metadata.getDatasource().getProjectid() == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " Project Id is manditory");
        }
        metadata.setData(this.sdStatesMasterDAO.getSdStateMasterMinDataByProject(metadata.getDatasource().getProjectid()));
    }

    private void getService(MinMetaData metadata) throws DomainException {
        if (metadata.getDatasource().getProjectid() == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, PROJECT_ID_IS_MANDATORY);
        }
        metadata.setData(this.sdServiceDAO.getSdServiceMinDataFromProjectId(metadata.getDatasource().getProjectid()));
    }

    private void getProjectRoles(MinMetaData metadata) throws DomainException {
        if (metadata.getDatasource().getProjectid() == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " Project Id is manditory");
        }
        metadata.setData(this.sdProjectRolesDAO.getSdProjectRolesMinDataByProject(metadata.getDatasource().getProjectid()));
    }

    private void getProject(MinMetaData metadata) {
    }

    private void getMacroMaster(MinMetaData metadata) {
    }

    private void getDependentMaster(MinMetaData metadata) throws DomainException {
        if (metadata.getDatasource().getFilterParm1().isEmpty()) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " FilterParm1 is manditory");
        }
        metadata.setData(this.sdDependentMasterDAO.getDerivedField1BySubcategory(metadata.getDatasource().getProjectid(), metadata.getDatasource().getFilterParm1()));
    }

    private void getCategory(MinMetaData metadata) throws DomainException {
        if (metadata.getDatasource().getProjectid() == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, PROJECT_ID_IS_MANDATORY);
        }
        if (metadata.getDatasource().getFilterParm1().isEmpty()) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " FilterParm1(services) is manditory");
        }
        metadata.setData(this.sdCategorymasterDAO.getSdCategorymasterByProjectIdAndService(metadata.getDatasource().getProjectid(), metadata.getDatasource().getFilterParm1()));
    }

    private void getAdditionalParms(MinMetaData metadata) throws DomainException {
        if (metadata.getDatasource().getProjectid() == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " Project Id is manditory");
        }
    }

    private void getSubcategoryBasedOnService(MinMetaData metadata) throws DomainException {
        if (metadata.getDatasource().getProjectid() == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, PROJECT_ID_IS_MANDATORY);
        }
        metadata.setData(this.sdSubcategorymasterDAO.getSdSubcategoryMinDataBasedOnService(metadata.getDatasource()));
    }

    private void getStateCategoryBasedOnProject(MinMetaData metadata) throws DomainException {
        if (metadata.getDatasource().getProjectid() == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, PROJECT_ID_IS_MANDATORY);
        }
        metadata.setData(this.sdStatecategoryMasterDAO.getStateCategoryMinDataByProject(metadata.getDatasource().getProjectid()));
    }

    private void getDependentMaster2(MinMetaData metadata) throws DomainException {
        if (metadata.getDatasource().getFilterParm1().isEmpty()) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " FilterParm1(subcategory) is mandatory");
        }
        if (metadata.getDatasource().getFilterParm2().isEmpty()) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " FilterParm2(derived field1) is mandatory");
        }
        metadata.setData(this.sdDependentMasterDAO.getDerivedField2BySubcategory(metadata.getDatasource().getProjectid(), metadata.getDatasource().getFilterParm1(), metadata.getDatasource().getFilterParm2()));
    }

    private void getDependentMaster3(MinMetaData metadata) throws DomainException {
        if (metadata.getDatasource().getFilterParm1().isEmpty()) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " FilterParm1(subcategory) is mandatory");
        }
        if (metadata.getDatasource().getFilterParm2().isEmpty()) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " FilterParm2(derived field1) is mandatory");
        }
        if (metadata.getDatasource().getFilterParm2().isEmpty()) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " FilterParm2(derived field2) is mandatory");
        }
        metadata.setData(this.sdDependentMasterDAO.getDerivedField3BySubcategory(metadata.getDatasource().getProjectid(), metadata.getDatasource().getFilterParm1(), metadata.getDatasource().getFilterParm2(), metadata.getDatasource().getFilterParm3()));
    }

    private void getSdProjectRolesByRoleName(MinMetaData metadata) throws DomainException {
        if (metadata.getDatasource().getProjectid() == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, PROJECT_ID_IS_MANDATORY);
        }
        if (metadata.getDatasource().getFilterParm1().isEmpty()) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " FilterParm1(role name) is mandatory");
        }
        metadata.setData(this.sdProjectRolesDAO.getSdProjectRolesMinDataByProjectAndRoleName(metadata.getDatasource().getProjectid(), metadata.getDatasource().getFilterParm1()));
    }

    private void getSdNotificationTemplate(MinMetaData metadata) throws DomainException {
        if (metadata.getDatasource().getProjectid() == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, PROJECT_ID_IS_MANDATORY);
        }
        metadata.setData(this.sdNotificationTemplateDAO.getSdNotificationTemplateMinDataByProjectId(metadata.getDatasource().getProjectid()));
    }

    private void getUserMgmtMasterByProjectRoles(MinMetaData metadata) throws DomainException {
        if (metadata.getDatasource().getProjectid() == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, PROJECT_ID_IS_MANDATORY);
        }
        metadata.setData(this.getUserMgmtMasterByProjectRoles(metadata.getDatasource().getProjectid()));
    }

    private void getSdSMSNotificationTemplate(MinMetaData metadata) throws DomainException {
        if (metadata.getDatasource().getProjectid() == 0) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, PROJECT_ID_IS_MANDATORY);
        }
        metadata.setData(this.sdSmsNotificationTemplateDAO.getSdSMSNotificationTemplateMinDataByProjectId(metadata.getDatasource().getProjectid()));
    }

    private void getSdProjectRolesByWorkflow(MinMetaData metadata) throws DomainException {
        if (metadata.getDatasource().getFilterParm1().isEmpty()) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " FilterParm1(statemovementId) is mandatory");
        }
        metadata.setData(this.sdProjectRolesDAO.getSdProjectRolesByWorkflow(metadata.getDatasource().getFilterParm1()));
    }

    public List<UserMgmtMasterMinDTO> getUserMgmtMasterByProjectRoles(Integer projectId) {
        String query = "Select DISTINCT um.userDetails.userId AS id,um.fullName AS name from UserMgmtMaster um,UserDetails ud,SdProjectRolesDetails rd,SdProjectRoles rm where um.userDetails.userId=ud.userId and ud.userStatus=0 and um.userDetails.userId=rd.userId and rd.sdProjectRoles.projectRoleId = rm.projectRoleId and rm.sdProjectMaster.projectId=:projectId";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, SdDTOEnum.USERMGMT_MIN_DTO);
    }
}

