/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.service.impl;

import com.sapphireims.exception.DomainException;
import com.sapphireims.itsm.dao.ISdQuickCallTemplatesDAO;
import com.sapphireims.itsm.dao.ISdQuickCallTemplatesMasterDAO;
import com.sapphireims.itsm.dao.ISdQuickcalltemplatesDetailsDAO;
import com.sapphireims.itsm.dao.SdQuicktemplateAdditionalfieldvaluesDAO;
import com.sapphireims.itsm.dao.SdQuicktemplateAttachmentdetailsDAO;
import com.sapphireims.itsm.dao.SdQuicktemplateFieldvaluesDAO;
import com.sapphireims.itsm.dao.SdQuicktemplateGridvaluesDAO;
import com.sapphireims.itsm.dto.SdQuickCallTemplatesDTO;
import com.sapphireims.itsm.model.SdQuickcalltemplates;
import com.sapphireims.itsm.service.QuickTemplateService;
import com.sapphireims.util.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class QuickTemplateServiceImpl
implements QuickTemplateService {
    @Autowired
    protected ISdQuickCallTemplatesDAO quickCallTemplatesDAO;
    @Autowired
    protected ISdQuickCallTemplatesMasterDAO quickCallTemplatesMasterDAO;
    @Autowired
    protected ISdQuickcalltemplatesDetailsDAO quickcalltemplatesDetailsDAO;
    @Autowired
    private SdQuicktemplateFieldvaluesDAO fixedFieldvaluesDAO;
    @Autowired
    private SdQuicktemplateAdditionalfieldvaluesDAO additionalfieldsDAO;
    @Autowired
    private SdQuicktemplateGridvaluesDAO gridValuesDAO;
    @Autowired
    private SdQuicktemplateAttachmentdetailsDAO attachmentsDAO;

    @Override
    @Transactional(readOnly=true)
    @Cacheable(value={"quick_template"}, key="#templateId")
    public SdQuickCallTemplatesDTO getQuickTemplateById(Integer templateId) throws DomainException {
        Validate.notNull((Object)templateId, (String)" Template id is mandiroty ", (Object[])new Object[0]);
        SdQuickcalltemplates template = (SdQuickcalltemplates)this.quickCallTemplatesDAO.get(templateId);
        if (template == null) {
            throw new DomainException(DomainException.ErrorCode.NO_SUCH_ENTITY, " No Template with id {} ", new Object[]{templateId});
        }
        return new SdQuickCallTemplatesDTO(template, this.fixedFieldvaluesDAO.getFieldvaluesByQuickCallTemplateId(templateId), this.additionalfieldsDAO.getAdditionalfieldvaluesByQuickCallTemplateId(templateId), this.gridValuesDAO.getGridvaluesByQuickCallTemplateId(templateId), this.attachmentsDAO.getAttachmentsByQuickCallTemplateId(templateId));
    }
}

