/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.itsm.service.impl;

import com.sapphireims.cmdb.dto.AssetDTO;
import com.sapphireims.cmdb.dto.asset.AssetAdditionalParams;
import com.sapphireims.cmdb.dto.asset.AssetAttribute;
import com.sapphireims.dto.BaseMinDTO;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.itsm.dao.ISdRequestNumberFormatDAO;
import com.sapphireims.itsm.dto.SdAdditionalparamsDTO;
import com.sapphireims.itsm.dto.SdConfigSettingsDTO;
import com.sapphireims.itsm.dto.SdRequestNumberFormatDTO;
import com.sapphireims.itsm.dto.projectcopy.ProjectDTO;
import com.sapphireims.itsm.dto.ticket.Attribute;
import com.sapphireims.itsm.dto.ticket.SdRequestNumberFormatParamDTO;
import com.sapphireims.itsm.dto.ticket.TicketDTO;
import com.sapphireims.itsm.mindto.CategoryMinDTO;
import com.sapphireims.itsm.mindto.DepartmentMinDTO;
import com.sapphireims.itsm.mindto.DerivedFieldMinDTO;
import com.sapphireims.itsm.mindto.LocationMinDTO;
import com.sapphireims.itsm.mindto.SubCategoryMinDTO;
import com.sapphireims.itsm.model.SdRequestTracker;
import com.sapphireims.itsm.model.SdRequestnumberformat;
import com.sapphireims.itsm.model.SdServiceReqMaster;
import com.sapphireims.itsm.service.ISDRequestNumberFormatService;
import com.sapphireims.itsm.service.ISdConfigsettingsService;
import com.sapphireims.itsm.service.ISdProjectMasterService;
import com.sapphireims.itsm.service.ISdRequestTrackerService;
import com.sapphireims.util.CollectionUtil;
import com.sapphireims.util.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SDRequestNumberFormatService
implements ISDRequestNumberFormatService {
    private static final String SPLITER = "||&&||";
    @Value(value="${cache.metadata}")
    private boolean cache;
    public static final Logger logger = LoggerFactory.getLogger((String)"ims");
    @Autowired
    private ISdRequestNumberFormatDAO sdRequestNumberFormatDAO;
    @Autowired
    private ISdProjectMasterService projectMasterService;
    @Autowired
    private ISdConfigsettingsService sdConfigsettingsService;
    @Autowired
    private ISdRequestTrackerService sdRequestTrackerService;

    @Override
    @Transactional
    public String getRequestID(SdRequestNumberFormatParamDTO s, TicketDTO t) throws DomainException, ValidationException {
        logger.info("------------Invoking request format Id -------------");
        String requestId = this.getRequestId(t, 0, this.getRecordParameters(t));
        if (requestId.isEmpty()) {
            requestId = String.valueOf(t.getProblemId());
        }
        logger.info("------------Completed request format Id requestId :: " + requestId);
        return requestId;
    }

    @Override
    @Transactional
    public SdRequestNumberFormatDTO getServiceRequestNumberFormatByProject(Integer projectId) throws DomainException, ValidationException {
        SdRequestNumberFormatDTO rformat = null;
        if (!this.cache) {
            List<SdRequestnumberformat> sdRequestFormat = this.sdRequestNumberFormatDAO.getSdRecordNumberFormatByProjectId(projectId);
            if (CollectionUtil.isNotEmpty(sdRequestFormat)) {
                rformat = new SdRequestNumberFormatDTO(sdRequestFormat.get(0));
            }
        } else {
            ProjectDTO p = this.projectMasterService.getProjectMetaData(projectId);
            rformat = p.getRequestNumberFormats() != null ? p.getRequestNumberFormats().get(0) : null;
        }
        return rformat;
    }

    private String getRecordParameters(TicketDTO t) throws DomainException, ValidationException {
        StringBuilder sb = new StringBuilder("{Project}|&|");
        try {
            List<SdAdditionalparamsDTO> additionalParms;
            ProjectDTO p = this.projectMasterService.getProjectMetaData(t.getProject().getId());
            String requestNumberFormat = null;
            if (t.getParent() != null && t.getParent().getProblemId() != null) {
                List<SdConfigSettingsDTO> settings = p.getSdConfigSettingses();
                for (SdConfigSettingsDTO set : settings) {
                    if (!set.getSettingKey().equalsIgnoreCase("SERVICEDESK_PARENT_CHILD_REQUEST_FORMAT_TAG")) continue;
                    requestNumberFormat = set.getSettingValue();
                }
            } else {
                List<SdRequestNumberFormatDTO> rformats = p.getRequestNumberFormats();
                if (CollectionUtil.isNotEmpty(rformats)) {
                    requestNumberFormat = rformats.get(0).getPrefix();
                    if (StringUtil.isEmpty((String)requestNumberFormat)) {
                        return "";
                    }
                } else {
                    return "";
                }
            }
            sb.append(t.getProject().getId()).append(SPLITER).append("{Service}|&|").append(t.getService().getId()).append(SPLITER).append("{Service Short Name}|&|").append(t.getService().getId());
            if (requestNumberFormat.contains("{Category}")) {
                sb.append(SPLITER).append("{Category}|&|").append(t.getCategory() != null ? t.getCategory().getCategoryId() : "0");
            }
            if (requestNumberFormat.contains("{Category Short Name}")) {
                sb.append(SPLITER).append("{Category Short Name}|&|").append(t.getCategory() != null ? t.getCategory().getCategoryId() : "0");
            }
            if (requestNumberFormat.contains("{Sub Category}")) {
                sb.append(SPLITER).append("{Sub Category}|&|").append(t.getSubCategory() != null ? t.getSubCategory().getId() : "0");
            }
            if (requestNumberFormat.contains("{Sub-Category Short Name}")) {
                sb.append(SPLITER).append("{Sub-Category Short Name}|&|").append(t.getSubCategory() != null ? t.getSubCategory().getId() : "0");
            }
            if (requestNumberFormat.contains("{Derived Field 1}")) {
                sb.append(SPLITER).append("{Derived Field 1}|&|").append(t.getDerivedField1() != null ? t.getDerivedField1().getId() : "0");
            }
            if (requestNumberFormat.contains("{Derived Field 1 Short Name}")) {
                sb.append(SPLITER).append("{Derived Field 1 Short Name}|&|").append(t.getDerivedField1() != null ? t.getDerivedField1().getId() : "0");
            }
            if (requestNumberFormat.contains("{Derived Field 2}")) {
                sb.append(SPLITER).append("{Derived Field 2}|&|").append(t.getDerivedField2() != null ? t.getDerivedField2().getId() : "0");
            }
            if (requestNumberFormat.contains("{Derived Field 2 Short Name}")) {
                sb.append(SPLITER).append("{Derived Field 2 Short Name}|&|").append(t.getDerivedField2() != null ? t.getDerivedField2().getId() : "0");
            }
            if (requestNumberFormat.contains("{Derived Field 3}")) {
                sb.append(SPLITER).append("{Derived Field 3}|&|").append(t.getDerivedField3() != null ? t.getDerivedField3().getId() : "0");
            }
            if (requestNumberFormat.contains("{Derived Field 3 Short Name}")) {
                sb.append(SPLITER).append("{Derived Field 3 Short Name}|&|").append(t.getDerivedField3() != null ? t.getDerivedField3().getId() : "0");
            }
            if (requestNumberFormat.contains("{Urgency}")) {
                sb.append(SPLITER).append("{Urgency}|&|").append(t.getUrgency() != null ? t.getUrgency().getId() : "0");
            }
            if (requestNumberFormat.contains("{Impact}")) {
                sb.append(SPLITER).append("{Impact}|&|").append(t.getImpact() != null ? t.getImpact().getId() : "0");
            }
            if (requestNumberFormat.contains("{Priority}")) {
                sb.append(SPLITER).append("{Priority}|&|").append(t.getPriority() != null ? t.getPriority().getId() : "0");
            }
            if (requestNumberFormat.contains("{Location}")) {
                sb.append(SPLITER).append("{Location}|&|").append(t.getLocation() != null ? t.getLocation().getId() : "0");
            }
            if (requestNumberFormat.contains("{Location Short Name}")) {
                sb.append(SPLITER).append("{Location Short Name}|&|").append(t.getLocation() != null ? t.getLocation().getId() : "0");
            }
            if (requestNumberFormat.contains("{Department}")) {
                sb.append(SPLITER).append("{Department}|&|").append(t.getDepartment() != null ? t.getDepartment().getId() : "0");
            }
            if (requestNumberFormat.contains("{Department Short Name}")) {
                sb.append(SPLITER).append("{Department Short Name}|&|").append(t.getDepartment() != null ? t.getDepartment().getId() : "0");
            }
            if (CollectionUtil.isNotEmpty(additionalParms = p.getAdditionalparams())) {
                for (SdAdditionalparamsDTO a : additionalParms) {
                    if (!requestNumberFormat.contains(a.getFieldDisplayname())) continue;
                    sb.append(SPLITER).append("{Custom_").append(a.getFieldid()).append("_").append(a.getFieldDisplayname()).append("}|&|");
                    try {
                        Attribute att;
                        if (t.getAdditionalParams() == null || (att = (Attribute)((Object)PropertyUtils.getProperty((Object)((Object)t.getAdditionalParams()), (String)a.getFieldName()))) == null) continue;
                        if (att.getData().isEmpty() && requestNumberFormat.contains("Expected Closure")) {
                            sb.append(t.getExpectedClosureTime() != null ? t.getExpectedClosureTime() : "");
                            continue;
                        }
                        sb.append(att.getData());
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        logger.error("Invalid Property " + a.getFieldName());
                    }
                }
            }
            if (requestNumberFormat.contains("{Asset_Custom_") || requestNumberFormat.contains("{Asset_")) {
                String fieldDisplayName;
                String[] fieldData;
                String assetFieldMacro;
                Matcher m;
                Pattern pattern;
                if (requestNumberFormat.contains("{Asset_Custom_")) {
                    pattern = Pattern.compile("\\{Asset_Custom_.*?\\}", 34);
                    m = pattern.matcher(requestNumberFormat);
                    while (m.find()) {
                        String[] fieldMetaData;
                        assetFieldMacro = m.group(0);
                        fieldData = assetFieldMacro.split("Custom\\_");
                        if (fieldData.length <= 1 || (fieldMetaData = fieldData[1].split("\\_")) == null || fieldMetaData.length <= 1) continue;
                        int fieldId = NumberUtils.toInt((String)fieldMetaData[0]);
                        fieldDisplayName = fieldMetaData[1];
                        sb.append(SPLITER).append("{Asset_Custom_").append(fieldId).append("_").append(fieldDisplayName).append("}|&|");
                        try {
                            AssetAttribute attribute;
                            AssetAdditionalParams assetAdditionalParams;
                            if (t.getAsset() == null || t.getAsset().getAdditionalParams() == null || (assetAdditionalParams = t.getAsset().getAdditionalParams()) == null || (attribute = (AssetAttribute)((Object)PropertyUtils.getProperty((Object)((Object)assetAdditionalParams), (String)fieldDisplayName))) == null) continue;
                            sb.append(fieldId);
                        }
                        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                            logger.error("Invalid Property " + fieldDisplayName);
                        }
                    }
                }
                if (requestNumberFormat.contains("{Asset_")) {
                    pattern = Pattern.compile("\\{Asset_.*?\\}", 34);
                    m = pattern.matcher(requestNumberFormat);
                    while (m.find()) {
                        assetFieldMacro = m.group(0);
                        if (assetFieldMacro.contains("Asset_Custom_") || (fieldData = assetFieldMacro.split("\\_")).length <= 1) continue;
                        fieldDisplayName = fieldData[1].replace("}", "");
                        sb.append(SPLITER).append("{Asset_").append(fieldDisplayName).append("}|&|");
                        if (t.getAsset() != null) {
                            sb.append(t.getAsset().getId());
                            continue;
                        }
                        sb.append(0);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("SDRequestNumberFormatService :: (--Exception Caught--) occured in getRecordParameters " + e.getMessage(), (Throwable)e);
        }
        return sb.toString();
    }

    public String replaceSDRequestNumberMacroValue(String requestParams, TicketDTO ticketDTO, String prefix) {
        try {
            prefix = this.replaceRequestNumberDateMacro(prefix);
            prefix = this.replaceSDFixedFieldMacro(ticketDTO, prefix);
            prefix = this.replaceAssetFixedFieldsMacro(ticketDTO, prefix);
            prefix = this.replaceSDorAssetCustomFieldMacro(requestParams, ticketDTO, prefix);
        }
        catch (Exception e) {
            logger.error("SDRequestNumberFormatService :: (--Exception Caught--) occured in replaceSDRequestNumberMacroValue " + e.getMessage(), (Throwable)e);
        }
        return prefix;
    }

    private String replaceAssetFixedFieldsMacro(TicketDTO ticketDTO, String prefix) {
        try {
            AssetDTO assetDTO = ticketDTO.getAsset();
            if (assetDTO != null) {
                prefix = prefix.replace("{Asset_Asset Number}", assetDTO.getAssetNumber());
                prefix = prefix.replace("{Asset_Asset Type}", assetDTO.getItemType().getItemType());
                prefix = prefix.replace("{Asset_Department}", assetDTO.getDepartment() != null ? assetDTO.getDepartment().getName() : "");
                if ((prefix = prefix.replace("{Asset_Extension No}", assetDTO.getExtensionNumber())).contains("{Asset_Host Name}")) {
                    prefix = prefix.replace("{Asset_Host Name}", assetDTO.getSystemId() != 0 ? this.sdRequestNumberFormatDAO.getInventoryFieldValue(assetDTO.getSystemId(), assetDTO.getSiteId()) : "");
                }
                prefix = prefix.replace("{Asset_Location}", assetDTO.getLocation() != null ? assetDTO.getLocation().getName() : "");
                if ((prefix = prefix.replace("{Asset_Project}", assetDTO.getProject() != null ? assetDTO.getProject().getCategoryValue() : "")).contains("{Asset_Site}")) {
                    prefix = prefix.replace("{Asset_Site}", this.sdRequestNumberFormatDAO.getSiteName(assetDTO.getSiteId()));
                }
                prefix = prefix.replace("{Asset_Site Name}", assetDTO.getSiteName() != null ? assetDTO.getSiteName().getCategoryValue() : "");
                prefix = prefix.replace("{Asset_Status}", assetDTO.getFilter() != null ? assetDTO.getFilter().getValue() : "");
                prefix = prefix.replace("{Asset_System Name}", assetDTO.getSystemName());
                prefix = prefix.replace("{Asset_User Name}", assetDTO.getAllocatedUser() != null ? assetDTO.getAllocatedUser().getFullName() : "");
            } else {
                prefix = prefix.replace("{Asset_Asset Number}", "").replace("{Asset_Asset Type}", "").replace("{Asset_Department}", "");
                prefix = prefix.replace("{Asset_Extension No}", "").replace("{Asset_Host Name}", "").replace("{Asset_Location}", "");
                prefix = prefix.replace("{Asset_Project}", "").replace("{Asset_Site}", "").replace("{Asset_Site Name}", "");
                prefix = prefix.replace("{Asset_Status}", "").replace("{Asset_System Name}", "").replace("{Asset_User Name}", "");
            }
        }
        catch (Exception e) {
            logger.error("SDRequestNumberFormatService :: (--Exception Caught--) occured in replaceSDRequestNumberMacroValue " + e.getMessage(), (Throwable)e);
        }
        return prefix;
    }

    private String replaceSDorAssetCustomFieldMacro(String requestFormat, TicketDTO ticketDTO, String prefix) {
        try {
            String[] requestParams;
            for (String requestParam : requestParams = requestFormat.split("\\|\\|&&\\|\\|")) {
                String[] params = requestParam.split("\\|&\\|");
                if (params[0].contains("{Custom_")) {
                    if (params.length == 1) {
                        prefix = prefix.replace(params[0], "");
                        continue;
                    }
                    prefix = prefix.replace(params[0], params[1]);
                    continue;
                }
                if (!params[0].contains("{Asset_Custom_")) continue;
                prefix = params.length == 1 ? prefix.replace(params[0], "") : prefix.replace(params[0], params[1]);
            }
        }
        catch (Exception e) {
            logger.error("SDRequestNumberFormatService :: (--Exception Caught--) occured in replaceSDorAssetCustomFieldMacro " + e.getMessage(), (Throwable)e);
        }
        return prefix;
    }

    private String replaceSDFixedFieldMacro(TicketDTO ticketDTO, String prefix) {
        try {
            prefix = this.replaceField(prefix, "{Project}", ticketDTO.getProject().getProjectName());
            prefix = this.replaceField(prefix, "{Service}", ticketDTO.getService().getServiceName());
            prefix = this.replaceField(prefix, "{Service Short Name}", ticketDTO.getService().getServiceShortName());
            prefix = this.replaceField(prefix, "{Category}", this.getNullableField(ticketDTO.getCategory(), CategoryMinDTO::getCategoryName));
            prefix = this.replaceField(prefix, "{Sub Category}", this.getNullableField(ticketDTO.getSubCategory(), SubCategoryMinDTO::getSubcategoryName));
            prefix = this.replaceField(prefix, "{Location}", this.getNullableField(ticketDTO.getLocation(), BaseMinDTO::getName));
            prefix = this.replaceField(prefix, "{Department}", this.getNullableField(ticketDTO.getDepartment(), BaseMinDTO::getName));
            prefix = this.replaceField(prefix, "{Urgency}", this.getNullableField(ticketDTO.getUrgency(), BaseMinDTO::getName));
            prefix = this.replaceField(prefix, "{Impact}", this.getNullableField(ticketDTO.getImpact(), BaseMinDTO::getName));
            prefix = this.replaceField(prefix, "{Priority}", this.getNullableField(ticketDTO.getPriority(), BaseMinDTO::getName));
            prefix = this.replaceField(prefix, "{Category Short Name}", this.getNullableField(ticketDTO.getCategory(), CategoryMinDTO::getCategoryshortName));
            prefix = this.replaceField(prefix, "{Sub-Category Short Name}", this.getNullableField(ticketDTO.getSubCategory(), SubCategoryMinDTO::getSubcategoryShortName));
            prefix = this.replaceField(prefix, "{Location Short Name}", this.getNullableField(ticketDTO.getLocation(), LocationMinDTO::getLocationShortName));
            prefix = this.replaceField(prefix, "{Department Short Name}", this.getNullableField(ticketDTO.getDepartment(), DepartmentMinDTO::getDepartmentShortName));
            prefix = this.replaceField(prefix, "{Derived Field 1}", this.getNullableField(ticketDTO.getDerivedField1(), BaseMinDTO::getName));
            prefix = this.replaceField(prefix, "{Derived Field 2}", this.getNullableField(ticketDTO.getDerivedField2(), BaseMinDTO::getName));
            prefix = this.replaceField(prefix, "{Derived Field 3}", this.getNullableField(ticketDTO.getDerivedField3(), BaseMinDTO::getName));
            prefix = this.replaceField(prefix, "{Derived Field 1 Short Name}", this.getNullableField(ticketDTO.getDerivedField1(), DerivedFieldMinDTO::getShortName));
            prefix = this.replaceField(prefix, "{Derived Field 2 Short Name}", this.getNullableField(ticketDTO.getDerivedField2(), DerivedFieldMinDTO::getShortName));
            prefix = this.replaceField(prefix, "{Derived Field 3 Short Name}", this.getNullableField(ticketDTO.getDerivedField3(), DerivedFieldMinDTO::getShortName));
        }
        catch (Exception e) {
            logger.error("SDRequestNumberFormatService :: (--Exception Caught--) occurred in replaceSDFixedFieldMacro: " + e.getMessage(), (Throwable)e);
        }
        return prefix;
    }

    private String replaceField(String prefix, String placeholder, String value) {
        return prefix.replace(placeholder, value != null ? value : "");
    }

    private <T> String getNullableField(T object, Function<T, String> extractor) {
        return Optional.ofNullable(object).map(extractor).orElse("");
    }

    public String replaceRequestNumberDateMacro(String prefix) {
        try {
            if (prefix.contains("{DD}") || prefix.contains("{MM}") || prefix.contains("{YYYY}") || prefix.contains("{YY}")) {
                Date dNow = new Date();
                SimpleDateFormat ft = new SimpleDateFormat("yyyy.MM.dd");
                String date = ft.format(dNow);
                String[] dateArr = date.split("\\.");
                prefix = prefix.replace("{DD}", dateArr[2]);
                prefix = prefix.replace("{MM}", dateArr[1]);
                prefix = prefix.replace("{YYYY}", dateArr[0]);
                prefix = prefix.replace("{YY}", dateArr[0].substring(2));
            }
        }
        catch (Exception e) {
            logger.error("SDRequestNumberFormatService :: (--Exception Caught--) occured in replaceRequestNumberDateMacro " + e.getMessage(), (Throwable)e);
        }
        return prefix;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public String getRequestId(TicketDTO ticketDTO, int bulkCallSubmission, String requestParams) throws DomainException, ValidationException {
        Object currentProjectRequestId = "";
        try {
            logger.info("getRequestId ----- Proxy class: " + String.valueOf(this.getClass()));
            int projectId = ticketDTO.getProject().getProjectId();
            int problemId = ticketDTO.getProblemId();
            int isChild = 0;
            int parentProblemId = 0;
            int parentProjectId = 0;
            int lastProblemId = 0;
            int lastChildProblemId = 0;
            String parentRequestId = "";
            String lastRequestId = "";
            String lastChildRequestId = "";
            if (ticketDTO.getParent() != null && ticketDTO.getParent().getProblemId() != null) {
                isChild = 1;
                parentProblemId = ticketDTO.getParent().getProblemId();
                parentProjectId = ticketDTO.getParent().getProject().getProjectId();
                parentRequestId = ticketDTO.getParent().getRequestId();
            }
            SdRequestNumberFormatDTO sdRequestFormatDTO = this.getServiceRequestNumberFormatByProject(projectId);
            boolean isConsider = false;
            int noOfDigits = 0;
            short considerPrefixIncrementParent = 0;
            short considerPrefixIncrementChild = 0;
            String startFrom = "";
            Object prefix = "";
            if (sdRequestFormatDTO != null) {
                noOfDigits = sdRequestFormatDTO.getNoOfDigits();
                prefix = sdRequestFormatDTO.getPrefix();
                considerPrefixIncrementParent = sdRequestFormatDTO.getConsiderPrefixForIncrementParent();
                considerPrefixIncrementChild = sdRequestFormatDTO.getConsiderPrefixForIncrementChild();
                startFrom = sdRequestFormatDTO.getStartFrom();
            }
            logger.error("bulkCallSubmission2222***************" + bulkCallSubmission);
            logger.info("------------Main Block projectId :: " + projectId);
            logger.info("------------Main Block problemId :: " + problemId);
            logger.info("------------Main Block prefix :: " + (String)prefix);
            logger.info("------------Main Block noOfDigits :: " + noOfDigits);
            logger.info("------------Main Block isChild :: " + isChild);
            logger.info("------------Main Block startFrom :: " + startFrom);
            if (bulkCallSubmission >= 0) {
                if (isChild != 0) {
                    String childFormat = "";
                    childFormat = this.sdConfigsettingsService.getSdSettingValue("SERVICEDESK_PARENT_CHILD_REQUEST_FORMAT_TAG", projectId, 0);
                    if (parentProjectId == projectId) {
                        SdServiceReqMaster lastChildRequest = this.sdRequestNumberFormatDAO.getSdServiceReqMaster(projectId, parentProblemId, problemId);
                        if (lastChildRequest != null) {
                            lastChildProblemId = lastChildRequest.getProblemId();
                            lastChildRequestId = lastChildRequest.getRequestId();
                        }
                        prefix = parentRequestId + childFormat;
                    } else {
                        SdServiceReqMaster sdServiceReqMaster = this.sdRequestNumberFormatDAO.getSdServiceReqMaster(projectId, 0, problemId);
                        if (sdServiceReqMaster == null) {
                            String temproraryRequestId = (String)prefix + startFrom;
                            prefix = parentRequestId + childFormat + temproraryRequestId + childFormat;
                        } else {
                            Object lastParentRequestId = sdServiceReqMaster.getRequestId();
                            int lastIncrementedValue = this.sdRequestNumberFormatDAO.getLastIncrementedRequestNumber(noOfDigits, projectId);
                            String ret = String.valueOf(lastIncrementedValue);
                            if (String.valueOf(lastIncrementedValue).length() < noOfDigits) {
                                ret = String.format("%0" + noOfDigits + "d", Integer.parseInt(ret));
                            }
                            String prefixPart = ((String)lastParentRequestId).substring(0, ((String)lastParentRequestId).indexOf(ret));
                            int incrementedValue = Integer.parseInt(ret) + 1;
                            lastParentRequestId = prefixPart + String.format("%0" + noOfDigits + "d", incrementedValue);
                            prefix = parentRequestId + childFormat + (String)lastParentRequestId + childFormat;
                        }
                    }
                    prefix = this.replaceSDRequestNumberMacroValue(requestParams, ticketDTO, (String)prefix);
                    int tempRequestID = this.getTempRequestID(projectId, parentProblemId, lastChildProblemId, lastChildRequestId, considerPrefixIncrementChild, (String)prefix, childFormat);
                    currentProjectRequestId = (String)prefix + tempRequestID;
                } else {
                    lastProblemId = this.sdRequestNumberFormatDAO.getLastProblemId(projectId, 0);
                    logger.info("------------Parent Block lastProblemId :: " + lastProblemId);
                    prefix = this.replaceSDRequestNumberMacroValue(requestParams, ticketDTO, (String)prefix);
                    if (lastProblemId == 0) {
                        currentProjectRequestId = (String)prefix + startFrom;
                    } else {
                        int tempRequestID = 0;
                        logger.info("------------Parent Block considerPrefixIncrementParent :: " + considerPrefixIncrementParent);
                        if (considerPrefixIncrementParent == 0) {
                            logger.info("------------Parent Block considerPrefixIncrementParent ==0  ");
                            int lastIncrementedNumber = this.sdRequestNumberFormatDAO.getLastIncrementedRequestNumber(noOfDigits, projectId);
                            tempRequestID = lastIncrementedNumber == 0 ? 1 : lastIncrementedNumber + 1;
                        } else {
                            logger.info("------------Parent Block prefix :: " + (String)prefix);
                            int requestFormatLength = ((String)prefix).length() + noOfDigits;
                            logger.info("------------Parent Block requestFormatLength :: " + requestFormatLength);
                            SdRequestTracker tracker = this.sdRequestTrackerService.getOrCreateLatestRequestForProject(projectId, (String)prefix, requestFormatLength);
                            lastProblemId = 0;
                            if (tracker != null) {
                                lastRequestId = tracker.getLastRequestId();
                                lastProblemId = tracker.getProblemId();
                            }
                            logger.info("------------Parent Block requestFormatLength :: " + requestFormatLength);
                            logger.info("------------Parent Block lastProblemId :: " + lastProblemId);
                            logger.info("------------Parent Block lastRequestId :: " + lastRequestId);
                            if (lastProblemId == 0) {
                                tempRequestID = 1;
                            } else {
                                tempRequestID = Integer.parseInt(lastRequestId.substring(lastRequestId.lastIndexOf((String)prefix) + ((String)prefix).length()));
                                ++tempRequestID;
                            }
                            logger.info("------------Parent Block tempRequestID :: " + tempRequestID);
                        }
                        String tempRequestIDStr = String.valueOf(tempRequestID);
                        currentProjectRequestId = tempRequestIDStr.length() < noOfDigits ? (String)prefix + String.format("%0" + noOfDigits + "d", tempRequestID) : (String)prefix + tempRequestIDStr;
                        logger.info("------------Parent Block currentProjectRequestId :: " + (String)currentProjectRequestId);
                        if (tempRequestIDStr.length() > noOfDigits) {
                            logger.info("------------Parent Block if tempRequestIDStr.length() > noOfDigits ---- ");
                            noOfDigits = tempRequestIDStr.length();
                            this.sdRequestNumberFormatDAO.updateSdRequestNumberFormat(noOfDigits, projectId);
                            logger.info("------------Parent Block noOfDigits :: " + noOfDigits);
                        }
                    }
                    logger.info("------------Parent Block Updating currentProjectRequestId :: " + (String)currentProjectRequestId);
                    this.sdRequestTrackerService.saveTracker(projectId, problemId, (String)prefix, (String)currentProjectRequestId);
                }
            } else if (bulkCallSubmission == -10) {
                SdServiceReqMaster sdServiceReqMaster = this.sdRequestNumberFormatDAO.getSdServiceReqMaster(projectId, 0, problemId);
                if (sdServiceReqMaster != null) {
                    lastRequestId = sdServiceReqMaster.getRequestId();
                }
                int tempRequestId = 0;
                if (!isConsider) {
                    tempRequestId = Integer.parseInt(lastRequestId) + 1;
                    currentProjectRequestId = String.valueOf(tempRequestId);
                } else {
                    String[] parts = lastRequestId.split((String)prefix);
                    tempRequestId = Integer.parseInt(parts[parts.length - 1]) + 1;
                    currentProjectRequestId = (String)prefix + String.format("%0" + noOfDigits + "d", tempRequestId);
                }
            }
        }
        catch (Exception ex) {
            logger.error("SDRequestNumberFormatService :: (--Exception Caught- ) occured in getRequestId" + ex.getMessage());
            ex.printStackTrace();
        }
        return currentProjectRequestId;
    }

    private int getTempRequestID(int projectId, int parentProblemId, int lastChildProblemId, String lastChildRequestId, int considerPrefixIncrementChild, String prefix, String childFormat) {
        int tempRequestID = 1;
        if (considerPrefixIncrementChild == 0) {
            if (lastChildProblemId == 0) {
                tempRequestID = 1;
            } else {
                String childDelimiter = "#";
                int lastBraceIndex = childFormat.lastIndexOf(125);
                String substringAfterBrace = childFormat.substring(lastBraceIndex + 1);
                if (!substringAfterBrace.isEmpty()) {
                    childDelimiter = substringAfterBrace;
                }
                int lastIndex = lastChildRequestId.lastIndexOf(childDelimiter);
                String lastPart = lastChildRequestId.substring(lastIndex + 1);
                tempRequestID = NumberUtils.toInt((String)lastPart, (int)0);
                ++tempRequestID;
            }
        } else {
            int requestFormatLength = prefix.length();
            SdServiceReqMaster sdServiceReqMaster = this.sdRequestNumberFormatDAO.getSdServiceReqBasedOnRequestFormat(projectId, prefix, requestFormatLength, parentProblemId);
            lastChildProblemId = 0;
            if (sdServiceReqMaster != null) {
                lastChildRequestId = sdServiceReqMaster.getRequestId();
                lastChildProblemId = sdServiceReqMaster.getProblemId();
            }
            if (lastChildProblemId == 0) {
                tempRequestID = 1;
            } else {
                tempRequestID = Integer.parseInt(lastChildRequestId.substring(lastChildRequestId.lastIndexOf(prefix) + prefix.length()));
                ++tempRequestID;
            }
        }
        return tempRequestID;
    }
}

